/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.plugin.jira.Xsquash.domain.dao.impl;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.util.UrlBuilder;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.log4j.Logger;
import org.squashtest.plugin.jira.Xsquash.domain.dao.TestCaseDao;
import org.squashtest.plugin.jira.Xsquash.domain.model.jira.SquashServerConfig;
import org.squashtest.plugin.jira.Xsquash.service.SquashServerConfigService;
import org.squashtest.plugin.jira.Xsquash.util.SquashRestApiRequestUtil;

@Named
public class TestCaseDaoImpl
implements TestCaseDao {
    private static final Logger log = Logger.getLogger(TestCaseDaoImpl.class);
    private static final String SQUASH_API_REQUIREMENTS_PATH = "/api/rest/latest/requirements";
    private static final String SQUASH_API_TESTCASES_PATH = "/api/rest/latest/test-cases/";
    private static final String SQUASH_API_FIELDS_PARAM = "fields";
    private static final String SQUASH_API_TESTCASE_FIELDS_VALUE = "*,steps[_type,id,action,attachments,datatable,docstring,comment,expected_result,keyword,called_test_case[_type,id,name],called_dataset[_type,id,name],delegate_parameter_values],datasets[id,name,parameter_values]";
    private static final String URL_PARAMETER_SERVER_NAME = "server_name";
    private static final String URL_PARAMETER_REMOTE_KEY = "remote_key";
    private static final String URL_PARAMETER_SIZE = "size";
    private static final String URL_PARAMETER_SIZE_VALUE = "500";
    private static final String URL_PARAMETER_PAGE = "page";
    @Inject
    private SquashServerConfigService sqService;

    @Override
    public String findSynchronizedSquashRequirementsAsJson(Issue issue, String pageNumber) {
        String issueKey = issue.getKey();
        log.debug((Object)String.format("Looking for page %s of SquashTM Test Case's linked to JIRA Issue %s", pageNumber, issueKey));
        String projectKey = issue.getProjectObject().getKey();
        SquashServerConfig squashServerConfig = this.sqService.getSquashServerConfigByJiraProjectKey(projectKey);
        String requestUrl = squashServerConfig.getSquashURL() + SQUASH_API_REQUIREMENTS_PATH;
        UrlBuilder urlBuilder = new UrlBuilder(requestUrl);
        HttpClientContext context = SquashRestApiRequestUtil.createHttpClientContext(urlBuilder.asURI(), squashServerConfig);
        String jiraServerName = squashServerConfig.getJiraServerNameInSquash();
        Map<String, String> restRequestParametersMap = this.buildParameterMap(issueKey, jiraServerName, pageNumber);
        urlBuilder.addParametersFromMap(restRequestParametersMap);
        return SquashRestApiRequestUtil.makeRestCallToSquash(urlBuilder.asURI(), context, squashServerConfig);
    }

    @Override
    public String findSquashTestCaseByIdAsJson(Long id, SquashServerConfig squashServerConfig) {
        log.debug((Object)String.format("Looking for page SquashTM Test Case with id %s", id));
        String requestURL = squashServerConfig.getSquashURL() + SQUASH_API_TESTCASES_PATH + id;
        UrlBuilder urlBuilder = new UrlBuilder(requestURL);
        HttpClientContext context = SquashRestApiRequestUtil.createHttpClientContext(urlBuilder.asURI(), squashServerConfig);
        urlBuilder.addParameter(SQUASH_API_FIELDS_PARAM, SQUASH_API_TESTCASE_FIELDS_VALUE);
        return SquashRestApiRequestUtil.makeRestCallToSquash(urlBuilder.asURI(), context, squashServerConfig);
    }

    private Map<String, String> buildParameterMap(String issueKey, String jiraServerName, String pageNumber) {
        HashMap<String, String> restRequestParametersMap = new HashMap<String, String>();
        restRequestParametersMap.put(URL_PARAMETER_REMOTE_KEY, issueKey);
        restRequestParametersMap.put(URL_PARAMETER_SERVER_NAME, jiraServerName);
        restRequestParametersMap.put(URL_PARAMETER_SIZE, URL_PARAMETER_SIZE_VALUE);
        restRequestParametersMap.put(URL_PARAMETER_PAGE, pageNumber);
        return restRequestParametersMap;
    }
}

