/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.plugin.jira.Xsquash.domain.dao.impl;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.squashtest.plugin.jira.Xsquash.domain.dao.JiraConfigDao;
import org.squashtest.plugin.jira.Xsquash.domain.model.jira.GlobalConfig;
import org.squashtest.plugin.jira.Xsquash.domain.model.jira.JsonTransformable;
import org.squashtest.plugin.jira.Xsquash.domain.model.jira.ProjectConfig;
import org.squashtest.plugin.jira.Xsquash.domain.model.jira.SquashServerConfig;

@Named
public class JiraConfigDaoImpl
implements JiraConfigDao {
    private static final Logger log = Logger.getLogger(JiraConfigDaoImpl.class);
    private ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private static final String XSQUASH_GLOBAL_CONFIG_KEY = "xsquash-global-configuration";
    private static final String XSQUASH_PROJECT_CONFIG_KEY = "xsquash-project-configuration";
    private static final String SQUASH_URL_ATTRIBUTE_EXTENSION = ".squash-url";
    private static final String LOGIN_ATTRIBUTE_EXTENSION = ".login";
    private static final String PASSWORD_ATTRIBUTE_EXTENSION = ".password";
    private static final String SERVER_NAME_ATTRIBUTE_EXTENSION = ".server-name";
    private static final String LEGACY_XSQUASH_GLOBAL_CONFIG_KEY = "org.squashtest.plugin.jira.Xsquash.servlet.ConfigResource$Config";
    private final PluginSettingsFactory pluginSettingsFactory;
    private final ProjectManager projectManager;

    @Inject
    public JiraConfigDaoImpl(@ComponentImport PluginSettingsFactory pluginSettingsFactory, @ComponentImport ProjectManager projectManager) {
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.projectManager = projectManager;
    }

    @Override
    public SquashServerConfig extractSquashServerProjectSettings(String projectKey) {
        ProjectConfig projectConfig = this.getProjectConfig(projectKey);
        if (projectConfig != null) {
            String squashServerUuid = projectConfig.getServerUuid();
            GlobalConfig globalConfig = this.getGlobalConfig();
            if (globalConfig != null) {
                return globalConfig.getSquashServerConfigMap().get(squashServerUuid);
            }
        }
        log.debug((Object)String.format("No Xsquash configuration find for project %s", projectKey));
        return null;
    }

    @Override
    public ProjectConfig getProjectConfig(String projectKey) {
        ProjectConfig result = null;
        try {
            PluginSettings pluginSettings = this.pluginSettingsFactory.createSettingsForKey(projectKey);
            String projectConfigString = (String)pluginSettings.get(XSQUASH_PROJECT_CONFIG_KEY);
            if (!StringUtils.isBlank((CharSequence)projectConfigString)) {
                result = (ProjectConfig)this.mapper.readValue(projectConfigString, ProjectConfig.class);
            }
        }
        catch (IOException e) {
            log.error((Object)"Error while parsing project config", (Throwable)e);
            throw new RuntimeException("Error while parsing project config", e);
        }
        return result;
    }

    @Override
    public List<ProjectConfig> getAllProjectConfig(String serverUUID) {
        ArrayList<ProjectConfig> projectConfigList = new ArrayList<ProjectConfig>();
        List jiraProjects = this.projectManager.getProjects();
        jiraProjects.stream().map(Project::getKey).forEach(projectKey -> {
            ProjectConfig projectConfig = this.getProjectConfig((String)projectKey);
            if (projectConfig != null && projectConfig.getServerUuid().equals(serverUUID)) {
                projectConfigList.add(projectConfig);
            }
        });
        return projectConfigList;
    }

    @Override
    public GlobalConfig getGlobalConfig() {
        GlobalConfig result;
        try {
            PluginSettings globalSettings = this.pluginSettingsFactory.createGlobalSettings();
            String globalConfigString = (String)globalSettings.get(XSQUASH_GLOBAL_CONFIG_KEY);
            result = !StringUtils.isBlank((CharSequence)globalConfigString) ? (GlobalConfig)this.mapper.readValue(globalConfigString, GlobalConfig.class) : this.migrateConfig();
        }
        catch (IOException e) {
            log.error((Object)"Error while parsing global config", (Throwable)e);
            throw new RuntimeException("Error while parsing global config", e);
        }
        return result;
    }

    @Override
    public void saveGlobalConfig(GlobalConfig globalConfig) {
        PluginSettings globalSettings = this.pluginSettingsFactory.createGlobalSettings();
        globalSettings.put(XSQUASH_GLOBAL_CONFIG_KEY, (Object)this.transformToJson(globalConfig));
    }

    @Override
    public void saveProjectConfig(ProjectConfig projectConfig) {
        PluginSettings pluginSettings = this.pluginSettingsFactory.createSettingsForKey(projectConfig.getProjectKey());
        pluginSettings.put(XSQUASH_PROJECT_CONFIG_KEY, (Object)this.transformToJson(projectConfig));
    }

    @Override
    public void deleteSquashServerFromGlobalConfig(String squashServerUuid) {
        try {
            PluginSettings globalSettings = this.pluginSettingsFactory.createGlobalSettings();
            String globalConfigString = (String)globalSettings.get(XSQUASH_GLOBAL_CONFIG_KEY);
            if (!StringUtils.isBlank((CharSequence)globalConfigString)) {
                GlobalConfig globalConfig = (GlobalConfig)this.mapper.readValue(globalConfigString, GlobalConfig.class);
                globalConfig.getSquashServerConfigMap().remove(squashServerUuid);
                globalSettings.put(XSQUASH_GLOBAL_CONFIG_KEY, (Object)this.transformToJson(globalConfig));
            }
        }
        catch (IOException e) {
            log.error((Object)"Error while deleting SquashTM server configuration", (Throwable)e);
            throw new RuntimeException("Error while deleting SquashTM server configuration", e);
        }
    }

    @Override
    public List<String> findJiraProjectUsingSquashServer(String serverUUID) {
        ArrayList<String> projectKeys = new ArrayList<String>();
        List projects = this.projectManager.getProjects();
        projects.stream().map(Project::getKey).forEach(projectKey -> {
            ProjectConfig projectConfig = this.getProjectConfig((String)projectKey);
            if (projectConfig != null && projectConfig.getServerUuid().equals(serverUUID)) {
                projectKeys.add((String)projectKey);
            }
        });
        return projectKeys;
    }

    @Override
    public boolean isNameAlreadyUsed(String squashServerName) {
        GlobalConfig globalConfig = this.getGlobalConfig();
        if (globalConfig != null) {
            return globalConfig.getSquashServerConfigMap().values().stream().map(SquashServerConfig::getSquashServerNameInJira).anyMatch(savedServerName -> savedServerName.equals(squashServerName));
        }
        return false;
    }

    @Override
    public boolean isUuidAlreadyUsed(String squashServer) {
        GlobalConfig globalConfig = this.getGlobalConfig();
        if (globalConfig != null) {
            return globalConfig.getSquashServerConfigMap().values().stream().map(SquashServerConfig::getId).anyMatch(savedServer -> savedServer.equals(squashServer));
        }
        return false;
    }

    private GlobalConfig migrateConfig() {
        GlobalConfig globalConfig = new GlobalConfig();
        PluginSettings globalSettings = this.pluginSettingsFactory.createGlobalSettings();
        String legacySquashUrlConfig = (String)globalSettings.get("org.squashtest.plugin.jira.Xsquash.servlet.ConfigResource$Config.squash-url");
        if (legacySquashUrlConfig != null) {
            String legacySquashServerNameConfig = (String)globalSettings.get("org.squashtest.plugin.jira.Xsquash.servlet.ConfigResource$Config.server-name");
            String legacySquashLoginConfig = (String)globalSettings.get("org.squashtest.plugin.jira.Xsquash.servlet.ConfigResource$Config.login");
            String legacySquashPasswordConfig = (String)globalSettings.get("org.squashtest.plugin.jira.Xsquash.servlet.ConfigResource$Config.password");
            SquashServerConfig serverConfig = this.initSquashServerConfig(legacySquashUrlConfig, legacySquashServerNameConfig, legacySquashLoginConfig, legacySquashPasswordConfig);
            globalConfig.getSquashServerConfigMap().put(serverConfig.getId(), serverConfig);
            this.removeLegacySettings(globalSettings);
        }
        globalSettings.put(XSQUASH_GLOBAL_CONFIG_KEY, (Object)this.transformToJson(globalConfig));
        return globalConfig;
    }

    private void removeLegacySettings(PluginSettings settings) {
        settings.put("org.squashtest.plugin.jira.Xsquash.servlet.ConfigResource$Config.squash-url", null);
        settings.put("org.squashtest.plugin.jira.Xsquash.servlet.ConfigResource$Config.server-name", null);
        settings.put("org.squashtest.plugin.jira.Xsquash.servlet.ConfigResource$Config.login", null);
        settings.put("org.squashtest.plugin.jira.Xsquash.servlet.ConfigResource$Config.password", null);
    }

    private SquashServerConfig initSquashServerConfig(String squashUrl, String serverName, String login, String password) {
        SquashServerConfig serverConfig = new SquashServerConfig();
        serverConfig.setSquashServerNameInJira("migrated server");
        serverConfig.setSquashURL(squashUrl);
        serverConfig.setJiraServerNameInSquash(serverName);
        serverConfig.setLogin(login);
        serverConfig.setPassword(password);
        return serverConfig;
    }

    private String transformToJson(JsonTransformable config) {
        String result;
        try {
            result = this.mapper.writeValueAsString((Object)config);
        }
        catch (IOException e) {
            log.error((Object)"Error while converting config to Json", (Throwable)e);
            throw new RuntimeException("Error while deleting SquashTM server configuration", e);
        }
        return result;
    }
}

