/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.plugin.jira.Xsquash.domain.dao.impl;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.util.UrlBuilder;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.log4j.Logger;
import org.squashtest.plugin.jira.Xsquash.domain.dao.IterationTestPlanItemDao;
import org.squashtest.plugin.jira.Xsquash.domain.model.jira.SquashServerConfig;
import org.squashtest.plugin.jira.Xsquash.domain.model.squash.SquashIterationTestPlanItemStub;
import org.squashtest.plugin.jira.Xsquash.service.SquashServerConfigService;
import org.squashtest.plugin.jira.Xsquash.util.SquashRestApiRequestUtil;

@Named
public class IterationTestPlanItemDaoImpl
implements IterationTestPlanItemDao {
    private static final Logger log = Logger.getLogger(IterationTestPlanItemDaoImpl.class);
    private static final String SQUASH_API_ITERATION_TEST_PLAN_ITEM_PATH = "/api/rest/latest/iteration-test-plan-items";
    private static final String SQUASH_API_FIELDS_PARAM = "fields";
    private static final String SQUASH_API_ITPI_FIELDS_VALUE = "*,referenced_test_case[_type,id,name,reference],referenced_dataset[_type,id,name],executions[_type,id,name,reference,comment,dataset_label,execution_mode,language,task_division,assignee_user,session_notes[kind,content,note_order,attachments],reviewed,progress_status,execution_steps[id,execution_status,action,expected_result,comment,referenced_test_step,attachments],execution_status,last_executed_by,last_executed_on,attachments],iteration[name,reference,scheduled_start_date,actual_start_date,parent[name,scheduled_start_date,actual_start_date]],exploratory_session_overview[id,charter,session_duration,comments,due_date,attachments]";
    private static final String URL_PARAMETER_SERVER_NAME = "server_name";
    private static final String URL_PARAMETER_REMOTE_KEY = "remote_key";
    private static final String URL_PARAMETER_SIZE = "size";
    private static final String URL_PARAMETER_SIZE_VALUE = "500";
    private static final String URL_PARAMETER_PAGE = "page";
    @Inject
    private SquashServerConfigService sqService;

    @Override
    public String findSquashTMIterationTestPlanItemsListByJiraIssueAsJson(Issue issue, String pageNumber) {
        String issueKey = issue.getKey();
        log.debug((Object)String.format("Looking for page %s of SquashTM ITPI's linked to JIRA Issue %s", pageNumber, issueKey));
        String projectKey = issue.getProjectObject().getKey();
        SquashServerConfig squashServerConfig = this.sqService.getSquashServerConfigByJiraProjectKey(projectKey);
        String requestURL = squashServerConfig.getSquashURL() + SQUASH_API_ITERATION_TEST_PLAN_ITEM_PATH;
        UrlBuilder urlBuilder = new UrlBuilder(requestURL);
        HttpClientContext context = SquashRestApiRequestUtil.createHttpClientContext(urlBuilder.asURI(), squashServerConfig);
        String jiraServerName = squashServerConfig.getJiraServerNameInSquash();
        Map<String, String> restRequestParametersMap = this.buildParameterMap(issueKey, jiraServerName, pageNumber);
        urlBuilder.addParametersFromMap(restRequestParametersMap);
        return SquashRestApiRequestUtil.makeRestCallToSquash(urlBuilder.asURI(), context, squashServerConfig);
    }

    @Override
    public String findSquashTMIterationTestPlanItemByIdAsJson(SquashIterationTestPlanItemStub squashItpiStub, SquashServerConfig squashServerConfig) {
        log.debug((Object)String.format("Looking for SquashTM ITPI with id %s", squashItpiStub.getId()));
        String requestURL = String.format("%s%s/%d", squashServerConfig.getSquashURL(), SQUASH_API_ITERATION_TEST_PLAN_ITEM_PATH, squashItpiStub.getId());
        UrlBuilder urlBuilder = new UrlBuilder(requestURL);
        HttpClientContext context = SquashRestApiRequestUtil.createHttpClientContext(urlBuilder.asURI(), squashServerConfig);
        urlBuilder.addParameter(SQUASH_API_FIELDS_PARAM, SQUASH_API_ITPI_FIELDS_VALUE);
        return SquashRestApiRequestUtil.makeRestCallToSquash(urlBuilder.asURI(), context, squashServerConfig);
    }

    private Map<String, String> buildParameterMap(String issueKey, String jiraServerName, String pageNumber) {
        HashMap<String, String> restRequestParametersMap = new HashMap<String, String>();
        restRequestParametersMap.put(URL_PARAMETER_REMOTE_KEY, issueKey);
        restRequestParametersMap.put(URL_PARAMETER_SERVER_NAME, jiraServerName);
        restRequestParametersMap.put(URL_PARAMETER_SIZE, URL_PARAMETER_SIZE_VALUE);
        restRequestParametersMap.put(URL_PARAMETER_PAGE, pageNumber);
        return restRequestParametersMap;
    }
}

