/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender.user;

import com.atlassian.confluence.security.login.LoginManager;
import com.atlassian.confluence.security.websudo.WebSudoManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.user.User;
import com.itlab.confluence.plugins.restextender.helper.ToolsHelper;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/userSessions")
public class UserSession {
    private static final Logger log = LoggerFactory.getLogger(UserSession.class);
    private final ToolsHelper toolsHelper;
    private final LoginManager loginManager;
    private final WebSudoManager webSudoManager;

    @Inject
    public UserSession(ToolsHelper toolsHelper) {
        this.toolsHelper = toolsHelper;
        this.loginManager = (LoginManager)ComponentLocator.getComponent(LoginManager.class);
        this.webSudoManager = (WebSudoManager)ComponentLocator.getComponent(WebSudoManager.class);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/wsActivate")
    public Response wsActivate(@Context HttpServletRequest request, @Context HttpServletResponse response) {
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.webSudoManager.isEnabled()) {
            this.webSudoManager.startSession(request, response);
        }
        return Response.ok().build();
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/resetFailedLoginCount")
    public Response resetFailedLoginCount(String jsonString) {
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        JSONObject jsonObject = new JSONObject(jsonString);
        ConfluenceUser confluenceUser = this.toolsHelper.getConfluenceUserByKey(jsonObject.getString("userKey"));
        if (confluenceUser != null) {
            this.loginManager.resetFailedLoginCount((User)confluenceUser);
        }
        return Response.ok().build();
    }
}

