/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender.notifyWatchers;

import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.user.User;
import com.itlab.confluence.plugins.restextender.helper.ToolsHelper;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/notifyWatchers")
public class NotifyWatchersUtils {
    private static final Logger log = LoggerFactory.getLogger(NotifyWatchersUtils.class);
    private final ToolsHelper toolsHelper;

    @Inject
    public NotifyWatchersUtils(ToolsHelper toolsHelper) {
        this.toolsHelper = toolsHelper;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/allowAll")
    public Response allowAll() {
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        this.toolsHelper.setBandanaObjectByType(this.toolsHelper.getNotifyWatchersAllowAll(), "allowAll");
        return Response.ok().build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/disallowAll")
    public Response disallowAll() {
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        this.toolsHelper.setBandanaObjectByType(this.toolsHelper.getNotifyWatchersAllowAll(), "disallowAll");
        return Response.ok().build();
    }

    @GET
    @Path(value="/set/save")
    public Response setPrimarySave() {
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        this.toolsHelper.setBandanaObjectByType(this.toolsHelper.getNotifyWatchersPrimaryButton(), "save");
        return Response.ok().build();
    }

    @GET
    @Path(value="/set/saveAndNotify")
    public Response setPrimarySaveAndNotify() {
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        this.toolsHelper.setBandanaObjectByType(this.toolsHelper.getNotifyWatchersPrimaryButton(), "saveAndNotify");
        return Response.ok().build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/configuration")
    public Response get(@Context HttpServletRequest request) {
        String notifyForUserLang;
        HashMap<String, String> response = new HashMap<String, String>();
        Object primaryButton = this.toolsHelper.getBandanaObjectByType(this.toolsHelper.getNotifyWatchersPrimaryButton());
        if (log.isDebugEnabled()) {
            log.debug("primaryButton : " + primaryButton);
        }
        if (primaryButton == null) {
            if (log.isDebugEnabled()) {
                log.debug("primaryButton NULL : " + primaryButton);
            }
            response.put("primaryButton", "save");
        } else if (primaryButton.toString().equalsIgnoreCase("saveAndNotify")) {
            if (log.isDebugEnabled()) {
                log.debug("primaryButton saveAndNotify : " + primaryButton);
            }
            response.put("primaryButton", "saveAndNotify");
        } else {
            if (log.isDebugEnabled()) {
                log.debug("primaryButton SAVE : " + primaryButton);
            }
            response.put("primaryButton", "save");
        }
        User user = this.toolsHelper.getAuthenticatedUser();
        I18NBeanFactory i18NBeanFactory = (I18NBeanFactory)ComponentLocator.getComponent(I18NBeanFactory.class);
        LocaleManager localeManager = (LocaleManager)ComponentLocator.getComponent(LocaleManager.class);
        response.put("notifyText", "Notify");
        response.put("notifyTextType", "fixed");
        response.put("userLang", "");
        if (user != null && localeManager.getLocale(user) != null && localeManager.getLocale(user).getLanguage() != null) {
            response.put("userLang", localeManager.getLocale(user).getLanguage());
        }
        if (!(notifyForUserLang = this.getNotifyForUserLang(user, localeManager)).equals("")) {
            response.put("notifyText", notifyForUserLang);
        } else {
            response.put("notifyText", i18NBeanFactory.getI18NBean(localeManager.getLocale(user)).getText("editor.minor.edit"));
            response.put("notifyTextType", "i18key");
        }
        if (this.toolsHelper.isConfluenceAdministrator()) {
            response.put("limitNotifyWatchers", "");
            Object allowAll = this.toolsHelper.getBandanaObjectByType(this.toolsHelper.getNotifyWatchersAllowAll());
            if (allowAll != null && allowAll.toString() != null && allowAll.toString().equalsIgnoreCase("allowAll")) {
                response.put("limitNotifyWatchers", "allowAll");
            }
        }
        return Response.ok(response).build();
    }

    private String getNotifyForUserLang(User user, LocaleManager localeManager) {
        String lang;
        String string = lang = user != null && localeManager.getLocale(user) != null && localeManager.getLocale(user).getLanguage() != null ? localeManager.getLocale(user).getLanguage().toLowerCase() : "";
        if (lang != null) {
            if (lang.equals("de") || lang.equals("de_de")) {
                return "Benachrichtigen";
            }
            if (lang.equals("en") || lang.equals("gb") || lang.equals("us") || lang.equals("en_gb") || lang.equals("en_us")) {
                return "Notify";
            }
            if (lang.equals("fr") || lang.equals("fr_fr")) {
                return "Notifier";
            }
            if (lang.equals("pl") || lang.equals("pl_pl")) {
                return "Powiadom";
            }
            if (lang.equals("nl") || lang.equals("nl_nl")) {
                return "Notificeer";
            }
        }
        return "";
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/getGroups")
    public Response getGroups() {
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        HashMap response = new HashMap();
        ArrayList<String> groupsArray = new ArrayList<String>();
        Object groups = this.toolsHelper.getBandanaObjectByType(this.toolsHelper.getNotifyWatchersGroups());
        if (groups != null) {
            if (groups.toString().contains("@@@")) {
                String[] groupsTable = groups.toString().split("@@@");
                for (int i = 0; i < groupsTable.length; ++i) {
                    groupsArray.add(groupsTable[i]);
                }
            } else if (!groups.toString().equals("")) {
                groupsArray.add(groups.toString());
            }
        }
        response.put("groups", groupsArray);
        return Response.ok(response).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/removeGroup/{groupName}")
    public Response removeGroup(@PathParam(value="groupName") String groupName) {
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        String newGroups = "";
        Object groups = this.toolsHelper.getBandanaObjectByType(this.toolsHelper.getNotifyWatchersGroups());
        if (groups != null) {
            if (groups.toString().contains("@@@")) {
                String[] groupsTable = groups.toString().split("@@@");
                for (int i = 0; i < groupsTable.length; ++i) {
                    if (groupsTable[i].equalsIgnoreCase(groupName)) continue;
                    if (!newGroups.equals("")) {
                        newGroups = newGroups + "@@@";
                    }
                    newGroups = newGroups + groupsTable[i];
                }
            } else if (!groups.toString().equals("")) {
                newGroups = groups.toString().replace(groupName, "");
            }
            this.toolsHelper.setBandanaObjectByType(this.toolsHelper.getNotifyWatchersGroups(), newGroups);
        }
        return Response.ok().build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/addGroup/{groupName}")
    public Response setGroups(@PathParam(value="groupName") String groupName) {
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        Object groups = this.toolsHelper.getBandanaObjectByType(this.toolsHelper.getNotifyWatchersGroups());
        if (groups != null && !groups.toString().equals("")) {
            this.toolsHelper.setBandanaObjectByType(this.toolsHelper.getNotifyWatchersGroups(), groups.toString() + "@@@" + groupName);
        } else {
            this.toolsHelper.setBandanaObjectByType(this.toolsHelper.getNotifyWatchersGroups(), groupName);
        }
        return Response.ok().build();
    }
}

