/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender.contactForm;

import com.atlassian.confluence.mail.ConfluenceMailServerManager;
import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.mail.Email;
import com.atlassian.mail.MailException;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.sal.api.component.ComponentLocator;
import com.itlab.confluence.plugins.restextender.helper.ToolsHelper;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/contactForm")
public class ContactFormApi {
    private static final Logger log = LoggerFactory.getLogger(ContactFormApi.class);
    private final ToolsHelper toolsHelper;
    private final UserAccessor userAccessor;

    @Inject
    public ContactFormApi(@ConfluenceImport UserAccessor userAccessor, ToolsHelper toolsHelper) {
        this.toolsHelper = toolsHelper;
        this.userAccessor = userAccessor;
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="sendMessage")
    public Response sendMessage(String jsonString, @Context HttpServletRequest request) {
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        HashMap<String, String> response = new HashMap<String, String>();
        JSONObject jsonObject = new JSONObject(jsonString);
        String message = jsonObject.getString("message").replace("@@quot@@", "\"").replace("@@br@@", "<br>");
        String spaceKeys = jsonObject.getString("spaceKeys");
        String replyTo = jsonObject.getString("replyTo");
        String title = jsonObject.getString("title");
        boolean skipConfluenceAdmins = jsonObject.getBoolean("skipConfluenceAdmins");
        boolean useBCC = jsonObject.getBoolean("useBCC");
        if (log.isDebugEnabled()) {
            log.debug("message IN " + message);
        }
        message = this.toolsHelper.getMailBody().replace("@@CONTENT@@", message);
        if (log.isDebugEnabled()) {
            log.debug("message OUT " + this.toolsHelper.getMailBody().replace("@@CONTENT@@", message));
            log.debug("spaceKeys " + spaceKeys);
            log.debug("title " + title);
            log.debug("skipConfluenceAdmins " + skipConfluenceAdmins);
            log.debug("useBCC " + useBCC);
            log.debug("replyTo " + replyTo);
        }
        Space space = this.toolsHelper.getSpaceFromSpaceDao(spaceKeys);
        ArrayList<ConfluenceUser> spaceAdmins = new ArrayList<ConfluenceUser>();
        String spaceAdminEmails = "";
        for (SpacePermission spacePermission : space.getPermissions()) {
            if (!spacePermission.getType().equalsIgnoreCase("SETSPACEPERMISSIONS")) continue;
            if (spacePermission.isGroupPermission() && spacePermission.getGroup() != null) {
                String groupName = spacePermission.getGroup();
                for (String userName : this.userAccessor.getMemberNamesAsList(this.userAccessor.getGroup(groupName))) {
                    if (this.toolsHelper.userIsDeactivated(userName)) continue;
                    ConfluenceUser confluenceUser = this.toolsHelper.getConfluenceUserByName(userName);
                    if (skipConfluenceAdmins && !this.toolsHelper.isConfluenceAdministrator(userName) && !spaceAdmins.contains(confluenceUser) && confluenceUser.getEmail() != null && !confluenceUser.getEmail().isEmpty()) {
                        spaceAdmins.add(confluenceUser);
                    }
                    if (skipConfluenceAdmins || spaceAdmins.contains(confluenceUser) || confluenceUser.getEmail() == null || confluenceUser.getEmail().isEmpty()) continue;
                    spaceAdmins.add(confluenceUser);
                }
                continue;
            }
            if (!spacePermission.isUserPermission() || spacePermission.getUserSubject() == null) continue;
            ConfluenceUser confluenceUser = spacePermission.getUserSubject();
            if (skipConfluenceAdmins && !this.toolsHelper.isConfluenceAdministrator(confluenceUser.getName()) && !spaceAdmins.contains(confluenceUser) && confluenceUser.getEmail() != null && !confluenceUser.getEmail().isEmpty()) {
                spaceAdmins.add(confluenceUser);
            }
            if (skipConfluenceAdmins || spaceAdmins.contains(confluenceUser) || confluenceUser.getEmail() == null || confluenceUser.getEmail().isEmpty()) continue;
            spaceAdmins.add(confluenceUser);
        }
        for (ConfluenceUser confluenceUser : spaceAdmins) {
            if (!spaceAdminEmails.isEmpty()) {
                spaceAdminEmails = spaceAdminEmails + ",";
            }
            spaceAdminEmails = spaceAdminEmails + confluenceUser.getEmail();
        }
        response.put("spaceAdminEmails", spaceAdminEmails);
        ConfluenceMailServerManager confluenceMailServerManager = (ConfluenceMailServerManager)ComponentLocator.getComponent(ConfluenceMailServerManager.class);
        SMTPMailServer smtpMailServer = confluenceMailServerManager.getDefaultSMTPMailServer();
        if (smtpMailServer != null && !spaceAdminEmails.isEmpty()) {
            String to = "";
            String bcc = "";
            if (useBCC) {
                bcc = spaceAdminEmails;
            } else {
                to = spaceAdminEmails;
            }
            Email mail = new Email(to, "", bcc);
            mail.setBody(message);
            mail.setSubject(title);
            mail.setMimeType("text/html;charset=utf-8");
            if (!replyTo.isEmpty() && this.toolsHelper.isValidEmail(replyTo)) {
                mail.setReplyTo(replyTo);
            }
            String mailMessage = "The email has been sent";
            ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(SMTPMailServer.class.getClassLoader());
            try {
                smtpMailServer.send(mail);
                response.put("status", "success");
            }
            catch (MailException ex) {
                response.put("status", "error");
                mailMessage = "Error while sending email - " + ex.getMessage();
            }
            Thread.currentThread().setContextClassLoader(threadClassLoader);
            response.put("message", mailMessage);
        } else {
            response.put("status", "warning");
            if (smtpMailServer != null) {
                response.put("message", "The email was not sent, the mail server is not configured");
            } else {
                response.put("message", "The email was not sent, no email addresses found for the selected criteria");
            }
        }
        return Response.ok(response).build();
    }
}

