/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender.breadcrumbs;

import com.itlab.confluence.plugins.restextender.helper.ToolsHelper;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/breadcrumbs")
public class BreadcrumbsApi {
    private static final Logger log = LoggerFactory.getLogger(BreadcrumbsApi.class);
    private final ToolsHelper toolsHelper;

    @Inject
    public BreadcrumbsApi(ToolsHelper toolsHelper) {
        this.toolsHelper = toolsHelper;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/state/{state}")
    public Response setState(@PathParam(value="state") String state) {
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("user", "anonymous");
        response.put("state", "");
        if (this.toolsHelper.getAuthenticatedConfluenceUser() != null && state != null && !state.isEmpty() && (state.equals("showAll") || state.equals("hideAll"))) {
            this.toolsHelper.setBandanaObjectByType(this.toolsHelper.getBreadcrumbsKey(), state);
        }
        return Response.ok().build();
    }
}

