/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender.avatar;

import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.user.PersonalInformation;
import com.atlassian.confluence.user.PersonalInformationManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.actions.ProfilePictureInfo;
import com.atlassian.core.exception.InfrastructureException;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.plugins.rest.api.multipart.FilePart;
import com.atlassian.plugins.rest.api.multipart.MultipartFormParam;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.user.User;
import com.itlab.confluence.plugins.restextender.helper.ToolsHelper;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/avatar")
public class AvatarRestApi {
    private static final Logger log = LoggerFactory.getLogger(AvatarRestApi.class);
    private final UserAccessor userAccessor;
    private ToolsHelper toolsHelper;

    @Inject
    public AvatarRestApi(@ConfluenceImport UserAccessor userAccessor, ToolsHelper toolsHelper) {
        this.userAccessor = userAccessor;
        this.toolsHelper = toolsHelper;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/test")
    public Response test() {
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("string", this.toolsHelper.getAuthenticatedUser().getName());
        return Response.ok(response).build();
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/image/{userName}")
    @Consumes(value={"multipart/form-data"})
    public Response setAvatarImage(@PathParam(value="userName") String userName, @MultipartFormParam(value="file") FilePart filePart) throws JSONException, IOException {
        userName = this.toolsHelper.decodeUrlParam(userName);
        log.debug("RESTAPI - set avatar image");
        log.debug("RESTAPI - userName: " + userName);
        HashMap<String, String> response = new HashMap<String, String>();
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.toolsHelper.isUserExistByName(userName)) {
            return this.toolsHelper.userNotFound(userName);
        }
        File file = this.getFileFromFilePart(filePart);
        if (file == null) {
            response.put("message", "please upload only 1 image");
            return Response.serverError().entity(response).build();
        }
        User confluenceUser = this.toolsHelper.getUserByName(userName);
        Attachment userPhotoAttachment = this.prepareAndReturnAttachment(Base64.encodeBase64String((byte[])FileUtils.readFileToByteArray((File)file)), confluenceUser);
        this.userAccessor.setUserProfilePicture(confluenceUser, userPhotoAttachment);
        response.put("message", "avatar changed");
        if (log.isDebugEnabled()) {
            response.put("items", "always 1");
            response.put("image", Base64.encodeBase64String((byte[])FileUtils.readFileToByteArray((File)file)));
        }
        return Response.ok(response).build();
    }

    private File getFileFromFilePart(FilePart filePart) throws ServiceException {
        try {
            File file = File.createTempFile("attachment-", ".tmp");
            if (!file.delete()) {
                log.debug("Could not remove newly created temp file. Continuing");
            }
            file.deleteOnExit();
            filePart.write(file);
            return file;
        }
        catch (IOException e) {
            return null;
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/base64/{userName}")
    public Response getAvatarBase64(@PathParam(value="userName") String userName, @Context HttpServletRequest request) throws JSONException, IOException {
        String tempBase64;
        String contentType;
        String lastBase64;
        HashMap<String, String> response;
        block6: {
            userName = this.toolsHelper.decodeUrlParam(userName);
            log.debug("RESTAPI - set avatar base64");
            log.debug("RESTAPI - userName: " + userName);
            response = new HashMap<String, String>();
            if (!this.toolsHelper.isLicenseIsValid()) {
                return this.toolsHelper.licenseIsInvalid();
            }
            if (!this.toolsHelper.isConfluenceAdministrator()) {
                return this.toolsHelper.permissionViolation();
            }
            if (!this.toolsHelper.isUserExistByName(userName)) {
                return this.toolsHelper.userNotFound(userName);
            }
            User confluenceUser = this.toolsHelper.getUserByName(userName);
            ProfilePictureInfo profilePictureInfo = this.userAccessor.getUserProfilePicture(confluenceUser);
            InputStream inputStream = profilePictureInfo.getBytes();
            lastBase64 = "";
            contentType = "";
            tempBase64 = "";
            try {
                tempBase64 = Base64.encodeBase64String((byte[])IOUtils.toByteArray((InputStream)inputStream));
                contentType = profilePictureInfo.getContentType();
            }
            catch (Exception ex) {
                if (!log.isDebugEnabled()) break block6;
                log.debug("Exception: " + ExceptionUtils.getStackTrace((Throwable)ex));
            }
        }
        if (tempBase64 != null && contentType != null && !tempBase64.equals("") && !contentType.equals("")) {
            lastBase64 = "data:" + contentType + ";base64," + tempBase64;
        }
        response.put("string", lastBase64);
        return Response.ok(response).build();
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/base64/{userName}")
    public Response setAvatarBase64(String userJSON, @PathParam(value="userName") String userName, @Context HttpServletRequest request) throws JSONException {
        userName = this.toolsHelper.decodeUrlParam(userName);
        log.debug("RESTAPI - set avatar base64");
        log.debug("RESTAPI - userName: " + userName);
        log.debug("RESTAPI - userJSON: " + userJSON);
        HashMap<String, String> response = new HashMap<String, String>();
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.toolsHelper.isUserExistByName(userName)) {
            return this.toolsHelper.userNotFound(userName);
        }
        JSONObject jsonObject = new JSONObject(userJSON);
        String base64string = jsonObject.getString("string");
        if (base64string.toLowerCase().startsWith("data:image")) {
            base64string = base64string.substring(base64string.indexOf("base64,") + 7);
        }
        User confluenceUser = this.toolsHelper.getUserByName(userName);
        Attachment userPhotoAttachment = this.prepareAndReturnAttachment(base64string, confluenceUser);
        this.userAccessor.setUserProfilePicture(confluenceUser, userPhotoAttachment);
        response.put("message", "avatar changed");
        if (log.isDebugEnabled()) {
            response.put("base64string", base64string);
        }
        return Response.ok(response).build();
    }

    private Attachment prepareAndReturnAttachment(String imageBase64, User user) {
        return this.saveNewAttachment(Base64.decodeBase64((String)imageBase64.replaceAll(System.getProperty("line.separator"), "+")), user);
    }

    private Attachment saveNewAttachment(byte[] imageBytes, User user) {
        AttachmentManager attachmentManager = (AttachmentManager)ComponentLocator.getComponent(AttachmentManager.class);
        PersonalInformationManager personalInformationManager = (PersonalInformationManager)ComponentLocator.getComponent(PersonalInformationManager.class);
        PersonalInformation userPersonalInformation = personalInformationManager.getOrCreatePersonalInformation(user);
        Attachment attachment = attachmentManager.getAttachment((ContentEntityObject)userPersonalInformation, "user-avatar");
        Attachment previousVersion = null;
        if (attachment == null) {
            attachment = new Attachment();
        } else {
            try {
                previousVersion = (Attachment)attachment.clone();
            }
            catch (Exception e) {
                throw new InfrastructureException((Throwable)e);
            }
        }
        attachment.setMediaType("image/jpeg");
        attachment.setFileName("user-avatar");
        attachment.setVersionComment("Uploaded Profile Picture [Extender for Confluence]");
        attachment.setFileSize((long)imageBytes.length);
        userPersonalInformation.addAttachment(attachment);
        ByteArrayInputStream is = new ByteArrayInputStream(imageBytes);
        try {
            attachmentManager.saveAttachment(attachment, previousVersion, (InputStream)is);
        }
        catch (IOException e) {
            throw new InfrastructureException("Error saving attachment data: " + e.getMessage(), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)is, null);
        }
        return attachment;
    }
}

