AJS.toInit(function() {
		  var baseUrl = AJS.contextPath();
		  var projectId = AJS.$("meta[name='projectId']").attr("content");
		    
		  function populateForm(projectId) {

        // PROJECT CONFIGURATION
		    AJS.$.ajax({
		      url: baseUrl + "/rest/time-tracking-stats/1.0/time-tracking-stats/project/" + projectId,
		      dataType: "json",
		      success: function(config) {
		        AJS.$("#time").attr("value", config.hours);
		        document.getElementById('field').value=config.field;
		      }
		    });

		    // COMPONENTS CONFIGURATION
		    var elements = document.querySelectorAll("#admin input[type=text]")

		    for (var i = 0, element; element = elements[i++];) {
		       
		        if (element.id != "time"){
		            AJS.$.ajax({
		  		      url: baseUrl + "/rest/time-tracking-stats/1.0/time-tracking-stats/project/" + projectId + "/"+ element.id,
		  		      dataType: "json",
		  		      success: function(config) {
  		  		    	if(config.hours){
		  		    		document.getElementById(config.componentId).value = config.hours;
	  	  		    	}
		  		      }
		  		    });
		        }
		    }
		  }

		  function updateConfig(projectId) {
		    
			  // PROJECT CONFIGURATION
			  AJS.$.ajax({
		      url: baseUrl + "/rest/time-tracking-stats/1.0/time-tracking-stats/project/" + projectId,
		      type: "PUT",
		      contentType: "application/json",
		      data: '{ "hours": ' +  AJS.$("#time").attr("value") + ', "field": "' + AJS.$("#field").attr("value") + '" }',
		      processData: false,
		      success: function(data) {
		    	  require(['aui/flag'], function(flag) {
		    		    var successFlag = flag({
				    	    type: 'success',
				    	    title: 'Success!',
				    	    body: 'Data has been saved successfully'
				    	});
		    		});
		      },
		      error: function() {
		    	  require(['aui/flag'], function(flag) {
		    		    var successFlag = flag({
				    	    type: 'error',
				    	    title: 'Sorry!',
				    	    body: 'Something happened and data has not been saved.'
				    	});
		    		});
		      }
		    });
		  

		    // COMPONENTS CONFIGURATION

		    var elements = document.querySelectorAll("#admin input[type=text]")

		    for (var i = 0, element; element = elements[i++];) {

		        if (element.id != "time"){
		            AJS.$.ajax({
                  url: baseUrl + "/rest/time-tracking-stats/1.0/time-tracking-stats/project/" + projectId + "/"+ element.id,
                  type: "PUT",
                  contentType: "application/json",
                  data: '{ "componentId": "' + element.id + '" , "hours": "' + element.value + '" }',
                  processData: false,
                  error: function() {
                    require(['aui/flag'], function(flag) {
                        var successFlag = flag({
                          type: 'error',
                          title: 'Sorry!',
                          body: 'Something happened and data has not been saved.'
                      });
                    });
                  }
		  		    });
		        }
		    }

		  } // fin de updateConfig
		  
		  
		  populateForm(projectId);

		  AJS.$("#admin").submit(function(e) {
		    e.preventDefault();
		    updateConfig(projectId);
		  });
		  
		});