/*!
* d3pie
* @author Ben Keen
* @version 0.1.8
* @date April 2015
* @repo http://github.com/benkeen/d3pie
*/
!function(d,c){"function"==typeof define&&define.amd?define([],c):"object"==typeof exports?module.exports=c(require()):d.d3pie=c(d)}(this,function(){var B="d3pie",A="0.1.6",z=0,y={header:{title:{text:"",color:"#333333",fontSize:18,font:"arial"},subtitle:{text:"",color:"#666666",fontSize:14,font:"arial"},location:"top-center",titleSubtitlePadding:8},footer:{text:"",color:"#666666",fontSize:14,font:"arial",location:"left"},size:{canvasHeight:500,canvasWidth:500,pieInnerRadius:"0%",pieOuterRadius:null},data:{sortOrder:"none",ignoreSmallSegments:{enabled:!1,valueType:"percentage",value:null},smallSegmentGrouping:{enabled:!1,value:1,valueType:"percentage",label:"Other",color:"#cccccc"},content:[]},labels:{outer:{format:"label",hideWhenLessThanPercentage:null,pieDistance:30},inner:{format:"percentage",hideWhenLessThanPercentage:null},mainLabel:{color:"#333333",font:"arial",fontSize:10},percentage:{color:"#dddddd",font:"arial",fontSize:10,decimalPlaces:0},value:{color:"#cccc44",font:"arial",fontSize:10},lines:{enabled:!0,style:"curved",color:"segment"},truncation:{enabled:!1,truncateLength:30},formatter:null},effects:{load:{effect:"default",speed:1000},pullOutSegmentOnClick:{effect:"bounce",speed:300,size:10},highlightSegmentOnMouseover:!0,highlightLuminosity:-0.2},tooltips:{enabled:!1,type:"placeholder",string:"",placeholderParser:null,styles:{fadeInSpeed:250,backgroundColor:"#000000",backgroundOpacity:0.5,color:"#efefef",borderRadius:2,font:"arial",fontSize:10,padding:4}},misc:{colors:{background:null,segments:["#2484c1","#65a620","#7b6888","#a05d56","#961a1a","#d8d23a","#e98125","#d0743c","#635222","#6ada6a","#0c6197","#7d9058","#207f33","#44b9b0","#bca44a","#e4a14b","#a3acb2","#8cc3e9","#69a6f9","#5b388f","#546e91","#8bde95","#d2ab58","#273c71","#98bf6e","#4daa4b","#98abc5","#cc1010","#31383b","#006391","#c2643f","#b0a474","#a5a39c","#a9c2bc","#22af8c","#7fcecf","#987ac6","#3d3b87","#b77b1c","#c9c2b6","#807ece","#8db27c","#be66a2","#9ed3c6","#00644b","#005064","#77979f","#77e079","#9c73ab","#1f79a7"],segmentStroke:"#ffffff"},gradient:{enabled:!1,percentage:95,color:"#000000"},canvasPadding:{top:5,right:5,bottom:5,left:5},pieCenterOffset:{x:0,y:0},cssPrefix:null},callbacks:{onload:null,onMouseoverSegment:null,onMouseoutSegment:null,onClickSegment:null}},x={initialCheck:function(h){var f=h.cssPrefix,l=h.element,k=h.options;if(!window.d3||!window.d3.hasOwnProperty("version")){return console.error("d3pie error: d3 is not available"),!1}if(!(l instanceof HTMLElement||l instanceof SVGElement)){return console.error("d3pie error: the first d3pie() param must be a valid DOM element (not jQuery) or a ID string."),!1}if(!/[a-zA-Z][a-zA-Z0-9_-]*$/.test(f)){return console.error("d3pie error: invalid options.misc.cssPrefix"),!1}if(!w.isArray(k.data.content)){return console.error("d3pie error: invalid config structure: missing data.content property."),!1}if(0===k.data.content.length){return console.error("d3pie error: no data supplied."),!1}for(var j=[],i=0;i<k.data.content.length;i++){"number"!=typeof k.data.content[i].value||isNaN(k.data.content[i].value)?console.log("not valid: ",k.data.content[i]):k.data.content[i].value<=0?console.log("not valid - should have positive value: ",k.data.content[i]):j.push(k.data.content[i])}return h.options.data.content=j,!0}},w={addSVGSpace:function(h){var g=h.element,l=h.options.size.canvasWidth,k=h.options.size.canvasHeight,j=h.options.misc.colors.background,i=d3.select(g).append("svg:svg").attr("width",l).attr("height",k);return"transparent"!==j&&i.style("background-color",function(){return j}),i},whenIdExists:function(g,f){var j=1,i=1000,h=setInterval(function(){document.getElementById(g)&&(clearInterval(h),f()),j>i&&clearInterval(h),j++},1)},whenElementsExist:function(g,f){var j=1,i=1000,h=setInterval(function(){for(var b=!0,a=0;a<g.length;a++){if(!document.getElementById(g[a])){b=!1;break}}b&&(clearInterval(h),f()),j>i&&clearInterval(h),j++},1)},shuffleArray:function(f){for(var e,h,g=f.length;0!==g;){h=Math.floor(Math.random()*g),g-=1,e=f[g],f[g]=f[h],f[h]=e}return f},processObj:function(e,d,f){return"string"==typeof d?w.processObj(e,d.split("."),f):1===d.length&&void 0!==f?(e[d[0]]=f,e[d[0]]):0===d.length?e:w.processObj(e[d[0]],d.slice(1),f)},getDimensions:function(g){var f=document.getElementById(g),j=0,i=0;if(f){var h=f.getBBox();j=h.width,i=h.height}else{console.log("error: getDimensions() "+g+" not found.")}return{w:j,h:i}},rectIntersect:function(e,d){var f=d.x>e.x+e.w||d.x+d.w<e.x||d.y+d.h<e.y||d.y>e.y+e.h;return !f},getColorShade:function(g,f){g=String(g).replace(/[^0-9a-f]/gi,""),g.length<6&&(g=g[0]+g[0]+g[1]+g[1]+g[2]+g[2]),f=f||0;for(var j="#",i=0;3>i;i++){var h=parseInt(g.substr(2*i,2),16);h=Math.round(Math.min(Math.max(0,h+h*f),255)).toString(16),j+=("00"+h).substr(h.length)}return j},initSegmentColors:function(g){for(var f=g.options.data.content,j=g.options.misc.colors.segments,i=[],h=0;h<f.length;h++){i.push(f[h].hasOwnProperty("color")?f[h].color:j[h])}return i},applySmallSegmentGrouping:function(j,h){var D;"percentage"===h.valueType&&(D=u.getTotalPieSize(j));for(var C=[],n=[],m=0,l=0;l<j.length;l++){if("percentage"===h.valueType){var k=j[l].value/D*100;if(k<=h.value){n.push(j[l]),m+=j[l].value;continue}j[l].isGrouped=!1,C.push(j[l])}else{if(j[l].value<=h.value){n.push(j[l]),m+=j[l].value;continue}j[l].isGrouped=!1,C.push(j[l])}}return n.length&&C.push({color:h.color,label:h.label,value:m,isGrouped:!0,groupedData:n}),C},showPoint:function(e,d,f){e.append("circle").attr("cx",d).attr("cy",f).attr("r",2).style("fill","black")},isFunction:function(d){var c={};return d&&"[object Function]"===c.toString.call(d)},isArray:function(b){return"[object Array]"===Object.prototype.toString.call(b)}},v=function(){var O,N,M,L,K,J,I=arguments[0]||{},H=1,G=arguments.length,F=!1,E=Object.prototype.toString,D=Object.prototype.hasOwnProperty,C={"[object Boolean]":"boolean","[object Number]":"number","[object String]":"string","[object Function]":"function","[object Array]":"array","[object Date]":"date","[object RegExp]":"regexp","[object Object]":"object"},g={isFunction:function(b){return"function"===g.type(b)},isArray:Array.isArray||function(b){return"array"===g.type(b)},isWindow:function(b){return null!==b&&b===b.window},isNumeric:function(b){return !isNaN(parseFloat(b))&&isFinite(b)},type:function(b){return null===b?String(b):C[E.call(b)]||"object"},isPlainObject:function(e){if(!e||"object"!==g.type(e)||e.nodeType){return !1}try{if(e.constructor&&!D.call(e,"constructor")&&!D.call(e.constructor.prototype,"isPrototypeOf")){return !1}}catch(d){return !1}var f;for(f in e){}return void 0===f||D.call(e,f)}};for("boolean"==typeof I&&(F=I,I=arguments[1]||{},H=2),"object"==typeof I||g.isFunction(I)||(I={}),G===H&&(I=this,--H),H;G>H;H++){if(null!==(O=arguments[H])){for(N in O){M=I[N],L=O[N],I!==L&&(F&&L&&(g.isPlainObject(L)||(K=g.isArray(L)))?(K?(K=!1,J=M&&g.isArray(M)?M:[]):J=M&&g.isPlainObject(M)?M:{},I[N]=v(F,J,L)):void 0!==L&&(I[N]=L))}}}return I},u={toRadians:function(b){return b*(Math.PI/180)},toDegrees:function(b){return b*(180/Math.PI)},computePieRadius:function(H){var G=H.options.size,F=H.options.misc.canvasPadding,E=G.canvasWidth-F.left-F.right,D=G.canvasHeight-F.top-F.bottom;"pie-center"!==H.options.header.location&&(D-=H.textComponents.headerHeight),H.textComponents.footer.exists&&(D-=H.textComponents.footer.h),D=0>D?0:D;var C,n,m=(D>E?E:D)/3;if(null!==G.pieOuterRadius){if(/%/.test(G.pieOuterRadius)){n=parseInt(G.pieOuterRadius.replace(/[\D]/,""),10),n=n>99?99:n,n=0>n?0:n;var l=D>E?E:D;if("none"!==H.options.labels.outer.format){var k=2*parseInt(H.options.labels.outer.pieDistance,10);l-k>0&&(l-=k)}m=Math.floor(l/100*n)/2}else{m=parseInt(G.pieOuterRadius,10)}}/%/.test(G.pieInnerRadius)?(n=parseInt(G.pieInnerRadius.replace(/[\D]/,""),10),n=n>99?99:n,n=0>n?0:n,C=Math.floor(m/100*n)):C=parseInt(G.pieInnerRadius,10),H.innerRadius=C,H.outerRadius=m},getTotalPieSize:function(e){for(var d=0,f=0;f<e.length;f++){d+=e[f].value}return d},sortPieData:function(e){var d=e.options.data.content,f=e.options.data.sortOrder;switch(f){case"none":break;case"random":d=w.shuffleArray(d);break;case"value-asc":d.sort(function(g,c){return g.value<c.value?-1:1});break;case"value-desc":d.sort(function(g,c){return g.value<c.value?1:-1});break;case"label-asc":d.sort(function(g,c){return g.label.toLowerCase()>c.label.toLowerCase()?1:-1});break;case"label-desc":d.sort(function(g,c){return g.label.toLowerCase()<c.label.toLowerCase()?1:-1})}return d},getPieTranslateCenter:function(b){return"translate("+b.x+","+b.y+")"},calculatePieCenter:function(j){var i=j.options.misc.pieCenterOffset,D=j.textComponents.title.exists&&"pie-center"!==j.options.header.location,C=j.textComponents.subtitle.exists&&"pie-center"!==j.options.header.location,n=j.options.misc.canvasPadding.top;D&&C?n+=j.textComponents.title.h+j.options.header.titleSubtitlePadding+j.textComponents.subtitle.h:D?n+=j.textComponents.title.h:C&&(n+=j.textComponents.subtitle.h);var m=0;j.textComponents.footer.exists&&(m=j.textComponents.footer.h+j.options.misc.canvasPadding.bottom);var l=(j.options.size.canvasWidth-j.options.misc.canvasPadding.left-j.options.misc.canvasPadding.right)/2+j.options.misc.canvasPadding.left,k=(j.options.size.canvasHeight-m-n)/2+n;l+=i.x,k+=i.y,j.pieCenter={x:l,y:k}},rotate:function(F,E,D,C,n){n=n*Math.PI/180;var m=Math.cos,l=Math.sin,k=(F-D)*m(n)-(E-C)*l(n)+D,j=(F-D)*l(n)+(E-C)*m(n)+C;return{x:k,y:j}},translate:function(g,f,j,i){var h=u.toRadians(i);return{x:g+j*Math.sin(h),y:f-j*Math.cos(h)}},pointIsInArc:function(F,E,D){var C=D.innerRadius()(E),n=D.outerRadius()(E),m=D.startAngle()(E),l=D.endAngle()(E),k=F.x*F.x+F.y*F.y,j=Math.atan2(F.x,-F.y);return j=0>j?j+2*Math.PI:j,k>=C*C&&n*n>=k&&j>=m&&l>=j}},t={add:function(j,i,D){var C=t.getIncludes(D),n=j.options.labels,m=j.svg.insert("g","."+j.cssPrefix+"labels-"+i).attr("class",j.cssPrefix+"labels-"+i),l=m.selectAll("."+j.cssPrefix+"labelGroup-"+i).data(j.options.data.content).enter().append("g").attr("id",function(b,a){return j.cssPrefix+"labelGroup"+a+"-"+i}).attr("data-index",function(d,c){return c}).attr("class",j.cssPrefix+"labelGroup-"+i).style("opacity",0),k={section:i,sectionDisplayType:D};C.mainLabel&&l.append("text").attr("id",function(b,a){return j.cssPrefix+"segmentMainLabel"+a+"-"+i}).attr("class",j.cssPrefix+"segmentMainLabel-"+i).text(function(e,d){var f=e.label;return n.formatter?(k.index=d,k.part="mainLabel",k.value=e.value,k.label=f,f=n.formatter(k)):n.truncation.enabled&&e.label.length>n.truncation.truncateLength&&(f=e.label.substring(0,n.truncation.truncateLength)+"..."),f}).style("font-size",n.mainLabel.fontSize+"px").style("font-family",n.mainLabel.font).style("fill",n.mainLabel.color),C.percentage&&l.append("text").attr("id",function(b,a){return j.cssPrefix+"segmentPercentage"+a+"-"+i}).attr("class",j.cssPrefix+"segmentPercentage-"+i).text(function(a,f){var e=s.getPercentage(j,f,j.options.labels.percentage.decimalPlaces);return n.formatter?(k.index=f,k.part="percentage",k.value=a.value,k.label=e,e=n.formatter(k)):e+="%",e}).style("font-size",n.percentage.fontSize+"px").style("font-family",n.percentage.font).style("fill",n.percentage.color),C.value&&l.append("text").attr("id",function(b,a){return j.cssPrefix+"segmentValue"+a+"-"+i}).attr("class",j.cssPrefix+"segmentValue-"+i).text(function(d,c){return k.index=c,k.part="value",k.value=d.value,k.label=d.value,n.formatter?n.formatter(k,d.value):d.value}).style("font-size",n.value.fontSize+"px").style("font-family",n.value.font).style("fill",n.value.color)},positionLabelElements:function(h,g,l){t["dimensions-"+g]=[];var k=d3.selectAll("."+h.cssPrefix+"labelGroup-"+g);k.each(function(C,n){var m=d3.select(this).selectAll("."+h.cssPrefix+"segmentMainLabel-"+g),b=d3.select(this).selectAll("."+h.cssPrefix+"segmentPercentage-"+g),a=d3.select(this).selectAll("."+h.cssPrefix+"segmentValue-"+g);t["dimensions-"+g].push({mainLabel:null!==m.node()?m.node().getBBox():null,percentage:null!==b.node()?b.node().getBBox():null,value:null!==a.node()?a.node().getBBox():null})});var j=5,i=t["dimensions-"+g];switch(l){case"label-value1":d3.selectAll("."+h.cssPrefix+"segmentValue-"+g).attr("dx",function(d,c){return i[c].mainLabel.width+j});break;case"label-value2":d3.selectAll("."+h.cssPrefix+"segmentValue-"+g).attr("dy",function(d,c){return i[c].mainLabel.height});break;case"label-percentage1":d3.selectAll("."+h.cssPrefix+"segmentPercentage-"+g).attr("dx",function(d,c){return i[c].mainLabel.width+j});break;case"label-percentage2":d3.selectAll("."+h.cssPrefix+"segmentPercentage-"+g).attr("dx",function(d,c){return i[c].mainLabel.width/2-i[c].percentage.width/2}).attr("dy",function(d,c){return i[c].mainLabel.height})}},computeLabelLinePositions:function(b){b.lineCoordGroups=[],d3.selectAll("."+b.cssPrefix+"labelGroup-outer").each(function(a,d){return t.computeLinePosition(b,d)})},computeLinePosition:function(N,M){var L,K,J,I,H=s.getSegmentAngle(M,N.options.data.content,N.totalSize,{midpoint:!0}),G=u.rotate(N.pieCenter.x,N.pieCenter.y-N.outerRadius,N.pieCenter.x,N.pieCenter.y,H),F=N.outerLabelGroupData[M].h/5,E=6,D=Math.floor(H/90),C=4;switch(2===D&&180===H&&(D=1),D){case 0:L=N.outerLabelGroupData[M].x-E-(N.outerLabelGroupData[M].x-E-G.x)/2,K=N.outerLabelGroupData[M].y+(G.y-N.outerLabelGroupData[M].y)/C,J=N.outerLabelGroupData[M].x-E,I=N.outerLabelGroupData[M].y-F;break;case 1:L=G.x+(N.outerLabelGroupData[M].x-G.x)/C,K=G.y+(N.outerLabelGroupData[M].y-G.y)/C,J=N.outerLabelGroupData[M].x-E,I=N.outerLabelGroupData[M].y-F;break;case 2:var j=N.outerLabelGroupData[M].x+N.outerLabelGroupData[M].w+E;L=G.x-(G.x-j)/C,K=G.y+(N.outerLabelGroupData[M].y-G.y)/C,J=N.outerLabelGroupData[M].x+N.outerLabelGroupData[M].w+E,I=N.outerLabelGroupData[M].y-F;break;case 3:var h=N.outerLabelGroupData[M].x+N.outerLabelGroupData[M].w+E;L=h+(G.x-h)/C,K=N.outerLabelGroupData[M].y+(G.y-N.outerLabelGroupData[M].y)/C,J=N.outerLabelGroupData[M].x+N.outerLabelGroupData[M].w+E,I=N.outerLabelGroupData[M].y-F}"straight"===N.options.labels.lines.style?N.lineCoordGroups[M]=[{x:G.x,y:G.y},{x:J,y:I}]:N.lineCoordGroups[M]=[{x:G.x,y:G.y},{x:L,y:K},{x:J,y:I}]},addLabelLines:function(f){var e=f.svg.insert("g","."+f.cssPrefix+"pieChart").attr("class",f.cssPrefix+"lineGroups").style("opacity",0),h=e.selectAll("."+f.cssPrefix+"lineGroup").data(f.lineCoordGroups).enter().append("g").attr("class",f.cssPrefix+"lineGroup"),g=d3.svg.line().interpolate("basis").x(function(b){return b.x}).y(function(b){return b.y});h.append("path").attr("d",g).attr("stroke",function(a,d){return"segment"===f.options.labels.lines.color?f.options.colors[d]:f.options.labels.lines.color}).attr("stroke-width",1).attr("fill","none").style("opacity",function(a,l){var k=f.options.labels.outer.hideWhenLessThanPercentage,j=s.getPercentage(f,l,f.options.labels.percentage.decimalPlaces),i=null!==k&&k>j||""===f.options.data.content[l].label;return i?0:1})},positionLabelGroups:function(d,c){"none"!==d.options.labels[c].format&&d3.selectAll("."+d.cssPrefix+"labelGroup-"+c).style("opacity",0).attr("transform",function(F,E){var D,C;if("outer"===c){D=d.outerLabelGroupData[E].x,C=d.outerLabelGroupData[E].y}else{var j=v(!0,{},d.pieCenter);if(d.innerRadius>0){var h=s.getSegmentAngle(E,d.options.data.content,d.totalSize,{midpoint:!0}),g=u.translate(d.pieCenter.x,d.pieCenter.y,d.innerRadius,h);j.x=g.x,j.y=g.y}var f=w.getDimensions(d.cssPrefix+"labelGroup"+E+"-inner"),b=f.w/2,a=f.h/4;D=j.x+(d.lineCoordGroups[E][0].x-j.x)/1.8,C=j.y+(d.lineCoordGroups[E][0].y-j.y)/1.8,D-=b,C+=a}return"translate("+D+","+C+")"})},fadeInLabelsAndLines:function(d){var c="default"===d.options.effects.load.effect?d.options.effects.load.speed:1;setTimeout(function(){var a="default"===d.options.effects.load.effect?400:1;d3.selectAll("."+d.cssPrefix+"labelGroup-outer").transition().duration(a).style("opacity",function(f,i){var h=d.options.labels.outer.hideWhenLessThanPercentage,g=s.getPercentage(d,i,d.options.labels.percentage.decimalPlaces);return null!==h&&h>g?0:1}),d3.selectAll("."+d.cssPrefix+"labelGroup-inner").transition().duration(a).style("opacity",function(f,i){var h=d.options.labels.inner.hideWhenLessThanPercentage,g=s.getPercentage(d,i,d.options.labels.percentage.decimalPlaces);return null!==h&&h>g?0:1}),d3.selectAll("g."+d.cssPrefix+"lineGroups").transition().duration(a).style("opacity",1),w.isFunction(d.options.callbacks.onload)&&setTimeout(function(){try{d.options.callbacks.onload()}catch(e){}},a)},c)},getIncludes:function(f){var e=!1,h=!1,g=!1;switch(f){case"label":e=!0;break;case"value":h=!0;break;case"percentage":g=!0;break;case"label-value1":case"label-value2":e=!0,h=!0;break;case"label-percentage1":case"label-percentage2":e=!0,g=!0}return{mainLabel:e,value:h,percentage:g}},computeOuterLabelCoords:function(b){b.svg.selectAll("."+b.cssPrefix+"labelGroup-outer").each(function(a,d){return t.getIdealOuterLabelPositions(b,d)}),t.resolveOuterLabelCollisions(b)},resolveOuterLabelCollisions:function(d){if("none"!==d.options.labels.outer.format){var c=d.options.data.content.length;t.checkConflict(d,0,"clockwise",c),t.checkConflict(d,c-1,"anticlockwise",c)}},checkConflict:function(J,I,H,G){var F,E;if(!(1>=G)){var D=J.outerLabelGroupData[I].hs;if(!("clockwise"===H&&"right"!==D||"anticlockwise"===H&&"left"!==D)){var C="clockwise"===H?I+1:I-1,n=J.outerLabelGroupData[I],i=J.outerLabelGroupData[C],f={labelHeights:J.outerLabelGroupData[0].h,center:J.pieCenter,lineLength:J.outerRadius+J.options.labels.outer.pieDistance,heightChange:J.outerLabelGroupData[0].h+1};if("clockwise"===H){for(F=0;I>=F;F++){if(E=J.outerLabelGroupData[F],w.rectIntersect(E,i)){t.adjustLabelPos(J,C,n,f);break}}}else{for(F=G-1;F>=I;F--){if(E=J.outerLabelGroupData[F],w.rectIntersect(E,i)){t.adjustLabelPos(J,C,n,f);break}}}t.checkConflict(J,C,H,G)}}},adjustLabelPos:function(j,i,D,C){var n,m,l,k;k=D.y+C.heightChange,m=C.center.y-k,n=Math.sqrt(Math.abs(C.lineLength)>Math.abs(m)?C.lineLength*C.lineLength-m*m:m*m-C.lineLength*C.lineLength),l="right"===D.hs?C.center.x+n:C.center.x-n-j.outerLabelGroupData[i].w,j.outerLabelGroupData[i].x=l,j.outerLabelGroupData[i].y=k},getIdealOuterLabelPositions:function(F,E){var D=d3.select("#"+F.cssPrefix+"labelGroup"+E+"-outer").node();if(D){var C=D.getBBox(),n=s.getSegmentAngle(E,F.options.data.content,F.totalSize,{midpoint:!0}),m=F.pieCenter.x,l=F.pieCenter.y-(F.outerRadius+F.options.labels.outer.pieDistance),j=u.rotate(m,l,F.pieCenter.x,F.pieCenter.y,n),h="right";n>180?(j.x-=C.width+8,h="left"):j.x+=8,F.outerLabelGroupData[E]={x:j.x,y:j.y,w:C.width,h:C.height,hs:h}}}},s={create:function(F){var E=F.pieCenter,D=F.options.colors,C=F.options.effects.load,n=F.options.misc.colors.segmentStroke,m=F.svg.insert("g","#"+F.cssPrefix+"title").attr("transform",function(){return u.getPieTranslateCenter(E)}).attr("class",F.cssPrefix+"pieChart"),l=d3.svg.arc().innerRadius(F.innerRadius).outerRadius(F.outerRadius).startAngle(0).endAngle(function(a){return a.value/F.totalSize*2*Math.PI}),j=m.selectAll("."+F.cssPrefix+"arc").data(F.options.data.content).enter().append("g").attr("class",F.cssPrefix+"arc"),h=C.speed;"none"===C.effect&&(h=0),j.append("path").attr("id",function(a,d){return F.cssPrefix+"segment"+d}).attr("fill",function(a,f){var c=D[f];return F.options.misc.gradient.enabled&&(c="url(#"+F.cssPrefix+"grad"+f+")"),c}).style("stroke",n).style("stroke-width",1).transition().ease("cubic-in-out").duration(h).attr("data-index",function(d,c){return c}).attrTween("d",function(a){var d=d3.interpolate({value:0},a);return function(c){return F.arc(d(c))}}),F.svg.selectAll("g."+F.cssPrefix+"arc").attr("transform",function(a,f){var e=0;return f>0&&(e=s.getSegmentAngle(f-1,F.options.data.content,F.totalSize)),"rotate("+e+")"}),F.arc=l},addGradients:function(d){var c=d.svg.append("defs").selectAll("radialGradient").data(d.options.data.content).enter().append("radialGradient").attr("gradientUnits","userSpaceOnUse").attr("cx",0).attr("cy",0).attr("r","120%").attr("id",function(a,e){return d.cssPrefix+"grad"+e});c.append("stop").attr("offset","0%").style("stop-color",function(a,e){return d.options.colors[e]}),c.append("stop").attr("offset",d.options.misc.gradient.percentage+"%").style("stop-color",d.options.misc.gradient.color)},addSegmentEventHandlers:function(d){var c=d3.selectAll("."+d.cssPrefix+"arc,."+d.cssPrefix+"labelGroup-inner,."+d.cssPrefix+"labelGroup-outer");c.on("click",function(){var a,h=d3.select(this);if(h.attr("class")===d.cssPrefix+"arc"){a=h.select("path")}else{var g=h.attr("data-index");a=d3.select("#"+d.cssPrefix+"segment"+g)}var f=a.attr("class")===d.cssPrefix+"expanded";s.onSegmentEvent(d,d.options.callbacks.onClickSegment,a,f),"none"!==d.options.effects.pullOutSegmentOnClick.effect&&(f?s.closeSegment(d,a.node()):s.openSegment(d,a.node()))}),c.on("mouseover",function(){var a,j,i=d3.select(this);if(i.attr("class")===d.cssPrefix+"arc"?a=i.select("path"):(j=i.attr("data-index"),a=d3.select("#"+d.cssPrefix+"segment"+j)),d.options.effects.highlightSegmentOnMouseover){j=a.attr("data-index");var h=d.options.colors[j];a.style("fill",w.getColorShade(h,d.options.effects.highlightLuminosity))}d.options.tooltips.enabled&&(j=a.attr("data-index"),q.showTooltip(d,j));var f=a.attr("class")===d.cssPrefix+"expanded";s.onSegmentEvent(d,d.options.callbacks.onMouseoverSegment,a,f)}),c.on("mousemove",function(){q.moveTooltip(d)}),c.on("mouseout",function(){var a,j,i=d3.select(this);if(i.attr("class")===d.cssPrefix+"arc"?a=i.select("path"):(j=i.attr("data-index"),a=d3.select("#"+d.cssPrefix+"segment"+j)),d.options.effects.highlightSegmentOnMouseover){j=a.attr("data-index");var h=d.options.colors[j];d.options.misc.gradient.enabled&&(h="url(#"+d.cssPrefix+"grad"+j+")"),a.style("fill",h)}d.options.tooltips.enabled&&(j=a.attr("data-index"),q.hideTooltip(d,j));var g=a.attr("class")===d.cssPrefix+"expanded";s.onSegmentEvent(d,d.options.callbacks.onMouseoutSegment,a,g)})},onSegmentEvent:function(g,f,j,i){if(w.isFunction(f)){var h=parseInt(j.attr("data-index"),10);f({segment:j.node(),index:h,expanded:i,data:g.options.data.content[h]})}},openSegment:function(d,c){d.isOpeningSegment||(d.isOpeningSegment=!0,d3.selectAll("."+d.cssPrefix+"expanded").length>0&&s.closeSegment(d,d3.select("."+d.cssPrefix+"expanded").node()),d3.select(c).transition().ease(d.options.effects.pullOutSegmentOnClick.effect).duration(d.options.effects.pullOutSegmentOnClick.speed).attr("transform",function(a,n){var m=d.arc.centroid(a),l=m[0],k=m[1],j=Math.sqrt(l*l+k*k),i=parseInt(d.options.effects.pullOutSegmentOnClick.size,10);return"translate("+l/j*i+","+k/j*i+")"}).each("end",function(b,a){d.currentlyOpenSegment=c,d.isOpeningSegment=!1,d3.select(this).attr("class",d.cssPrefix+"expanded")}))},closeSegment:function(d,c){d3.select(c).transition().duration(400).attr("transform","translate(0,0)").each("end",function(a,e){d3.select(this).attr("class",""),d.currentlyOpenSegment=null})},getCentroid:function(d){var c=d.getBBox();return{x:c.x+c.width/2,y:c.y+c.height/2}},getSegmentAngle:function(H,G,F,E){var D,C=v({compounded:!0,midpoint:!1},E),n=G[H].value;if(C.compounded){D=0;for(var m=0;H>=m;m++){D+=G[m].value}}"undefined"==typeof D&&(D=n);var l=D/F*360;if(C.midpoint){var g=n/F*360;l-=g/2}return l},getPercentage:function(f,e,h){var g=f.options.data.content[e].value/f.totalSize;return 0>=h?Math.round(100*g):(100*g).toFixed(h)}},r={offscreenCoord:-10000,addTitle:function(b){b.svg.selectAll("."+b.cssPrefix+"title").data([b.options.header.title]).enter().append("text").text(function(c){return c.text}).attr({id:b.cssPrefix+"title","class":b.cssPrefix+"title",x:r.offscreenCoord,y:r.offscreenCoord}).attr("text-anchor",function(){var a;return a="top-center"===b.options.header.location||"pie-center"===b.options.header.location?"middle":"left"}).attr("fill",function(c){return c.color}).style("font-size",function(c){return c.fontSize+"px"}).style("font-family",function(c){return c.font})},positionTitle:function(F){var E,D=F.textComponents,C=F.options.header.location,n=F.options.misc.canvasPadding,m=F.options.size.canvasWidth,l=F.options.header.titleSubtitlePadding;E="top-left"===C?n.left:(m-n.right)/2+n.left,E+=F.options.misc.pieCenterOffset.x;var k=n.top+D.title.h;if("pie-center"===C){if(k=F.pieCenter.y,D.subtitle.exists){var j=D.title.h+l+D.subtitle.h;k=k-j/2+D.title.h}else{k+=D.title.h/4}}F.svg.select("#"+F.cssPrefix+"title").attr("x",E).attr("y",k)},addSubtitle:function(d){var c=d.options.header.location;d.svg.selectAll("."+d.cssPrefix+"subtitle").data([d.options.header.subtitle]).enter().append("text").text(function(b){return b.text}).attr("x",r.offscreenCoord).attr("y",r.offscreenCoord).attr("id",d.cssPrefix+"subtitle").attr("class",d.cssPrefix+"subtitle").attr("text-anchor",function(){var b;return b="top-center"===c||"pie-center"===c?"middle":"left"}).attr("fill",function(b){return b.color}).style("font-size",function(b){return b.fontSize+"px"}).style("font-family",function(b){return b.font})},positionSubtitle:function(g){var f,j=g.options.misc.canvasPadding,i=g.options.size.canvasWidth;f="top-left"===g.options.header.location?j.left:(i-j.right)/2+j.left,f+=g.options.misc.pieCenterOffset.x;var h=r.getHeaderHeight(g);g.svg.select("#"+g.cssPrefix+"subtitle").attr("x",f).attr("y",h)},addFooter:function(b){b.svg.selectAll("."+b.cssPrefix+"footer").data([b.options.footer]).enter().append("text").text(function(c){return c.text}).attr("x",r.offscreenCoord).attr("y",r.offscreenCoord).attr("id",b.cssPrefix+"footer").attr("class",b.cssPrefix+"footer").attr("text-anchor",function(){var a="left";return"bottom-center"===b.options.footer.location?a="middle":"bottom-right"===b.options.footer.location&&(a="left"),a}).attr("fill",function(c){return c.color}).style("font-size",function(c){return c.fontSize+"px"}).style("font-family",function(c){return c.font})},positionFooter:function(i){var h,n=i.options.footer.location,m=i.textComponents.footer.w,l=i.options.size.canvasWidth,k=i.options.size.canvasHeight,j=i.options.misc.canvasPadding;h="bottom-left"===n?j.left:"bottom-right"===n?l-m-j.right:l/2,i.svg.select("#"+i.cssPrefix+"footer").attr("x",h).attr("y",k-j.bottom)},getHeaderHeight:function(f){var e;if(f.textComponents.title.exists){var h=f.textComponents.title.h+f.options.header.titleSubtitlePadding+f.textComponents.subtitle.h;e="pie-center"===f.options.header.location?f.pieCenter.y-h/2+h:h+f.options.misc.canvasPadding.top}else{if("pie-center"===f.options.header.location){var g=f.options.misc.canvasPadding.bottom+f.textComponents.footer.h;e=(f.options.size.canvasHeight-g)/2+f.options.misc.canvasPadding.top+f.textComponents.subtitle.h/2}else{e=f.options.misc.canvasPadding.top+f.textComponents.subtitle.h}}return e}},q={addTooltips:function(d){var c=d.svg.insert("g").attr("class",d.cssPrefix+"tooltips");c.selectAll("."+d.cssPrefix+"tooltip").data(d.options.data.content).enter().append("g").attr("class",d.cssPrefix+"tooltip").attr("id",function(a,e){return d.cssPrefix+"tooltip"+e}).style("opacity",0).append("rect").attr({rx:d.options.tooltips.styles.borderRadius,ry:d.options.tooltips.styles.borderRadius,x:-d.options.tooltips.styles.padding,opacity:d.options.tooltips.styles.backgroundOpacity}).style("fill",d.options.tooltips.styles.backgroundColor),c.selectAll("."+d.cssPrefix+"tooltip").data(d.options.data.content).append("text").attr("fill",function(a){return d.options.tooltips.styles.color}).style("font-size",function(a){return d.options.tooltips.styles.fontSize}).style("font-family",function(a){return d.options.tooltips.styles.font}).text(function(a,f){var e=d.options.tooltips.string;return"caption"===d.options.tooltips.type&&(e=a.caption),q.replacePlaceholders(d,e,f,{label:a.label,value:a.value,percentage:s.getPercentage(d,f,d.options.labels.percentage.decimalPlaces)})}),c.selectAll("."+d.cssPrefix+"tooltip rect").attr({width:function(a,f){var e=w.getDimensions(d.cssPrefix+"tooltip"+f);return e.w+2*d.options.tooltips.styles.padding},height:function(a,f){var e=w.getDimensions(d.cssPrefix+"tooltip"+f);return e.h+2*d.options.tooltips.styles.padding},y:function(a,f){var e=w.getDimensions(d.cssPrefix+"tooltip"+f);return -(e.h/2)+1}})},showTooltip:function(e,d){var f=e.options.tooltips.styles.fadeInSpeed;q.currentTooltip===d&&(f=1),q.currentTooltip=d,d3.select("#"+e.cssPrefix+"tooltip"+d).transition().duration(f).style("opacity",function(){return 1}),q.moveTooltip(e)},moveTooltip:function(b){d3.selectAll("#"+b.cssPrefix+"tooltip"+q.currentTooltip).attr("transform",function(a){var h=d3.mouse(this.parentNode),g=h[0]+b.options.tooltips.styles.padding+2,f=h[1]-2*b.options.tooltips.styles.padding-2;return"translate("+g+","+f+")"})},hideTooltip:function(d,c){d3.select("#"+d.cssPrefix+"tooltip"+c).style("opacity",function(){return 0}),d3.select("#"+d.cssPrefix+"tooltip"+q.currentTooltip).attr("transform",function(a,h){var g=d.options.size.canvasWidth+1000,f=d.options.size.canvasHeight+1000;return"translate("+g+","+f+")"})},replacePlaceholders:function(g,f,j,i){w.isFunction(g.options.tooltips.placeholderParser)&&g.options.tooltips.placeholderParser(j,i);var h=function(){return function(d){var c=arguments[1];return i.hasOwnProperty(c)?i[arguments[1]]:arguments[0]}};return f.replace(/\{(\w+)\}/g,h(i))}},p=function(d,c){if(this.element=d,"string"==typeof d){var b=d.replace(/^#/,"");this.element=document.getElementById(b)}var a={};v(!0,a,y,c),this.options=a,null!==this.options.misc.cssPrefix?this.cssPrefix=this.options.misc.cssPrefix:(this.cssPrefix="p"+z+"_",z++),x.initialCheck(this)&&(d3.select(this.element).attr(B,A),this.options.data.content=u.sortPieData(this),this.options.data.smallSegmentGrouping.enabled&&(this.options.data.content=w.applySmallSegmentGrouping(this.options.data.content,this.options.data.smallSegmentGrouping)),this.options.colors=w.initSegmentColors(this),this.totalSize=u.getTotalPieSize(this.options.data.content),o.call(this))};p.prototype.recreate=function(){x.initialCheck(this)&&(this.options.data.content=u.sortPieData(this),this.options.data.smallSegmentGrouping.enabled&&(this.options.data.content=w.applySmallSegmentGrouping(this.options.data.content,this.options.data.smallSegmentGrouping)),this.options.colors=w.initSegmentColors(this),this.totalSize=u.getTotalPieSize(this.options.data.content),o.call(this))},p.prototype.redraw=function(){this.element.innerHTML="",o.call(this)},p.prototype.destroy=function(){this.element.innerHTML="",d3.select(this.element).attr(B,null)},p.prototype.getOpenSegment=function(){var d=this.currentlyOpenSegment;if(null!==d&&"undefined"!=typeof d){var c=parseInt(d3.select(d).attr("data-index"),10);return{element:d,index:c,data:this.options.data.content[c]}}return null},p.prototype.openSegment=function(b){b=parseInt(b,10),0>b||b>this.options.data.content.length-1||s.openSegment(this,d3.select("#"+this.cssPrefix+"segment"+b).node())},p.prototype.closeSegment=function(){var b=this.currentlyOpenSegment;b&&s.closeSegment(this,b)},p.prototype.updateProp=function(f,e){switch(f){case"header.title.text":var h=w.processObj(this.options,f);w.processObj(this.options,f,e),d3.select("#"+this.cssPrefix+"title").html(e),(""===h&&""!==e||""!==h&&""===e)&&this.redraw();break;case"header.subtitle.text":var g=w.processObj(this.options,f);w.processObj(this.options,f,e),d3.select("#"+this.cssPrefix+"subtitle").html(e),(""===g&&""!==e||""!==g&&""===e)&&this.redraw();break;case"callbacks.onload":case"callbacks.onMouseoverSegment":case"callbacks.onMouseoutSegment":case"callbacks.onClickSegment":case"effects.pullOutSegmentOnClick.effect":case"effects.pullOutSegmentOnClick.speed":case"effects.pullOutSegmentOnClick.size":case"effects.highlightSegmentOnMouseover":case"effects.highlightLuminosity":w.processObj(this.options,f,e);break;default:w.processObj(this.options,f,e),this.destroy(),this.recreate()}};var o=function(){this.svg=w.addSVGSpace(this),this.textComponents={headerHeight:0,title:{exists:""!==this.options.header.title.text,h:0,w:0},subtitle:{exists:""!==this.options.header.subtitle.text,h:0,w:0},footer:{exists:""!==this.options.footer.text,h:0,w:0}},this.outerLabelGroupData=[],this.textComponents.title.exists&&r.addTitle(this),this.textComponents.subtitle.exists&&r.addSubtitle(this),r.addFooter(this);var d=this;w.whenIdExists(this.cssPrefix+"footer",function(){r.positionFooter(d);var a=w.getDimensions(d.cssPrefix+"footer");d.textComponents.footer.h=a.h,d.textComponents.footer.w=a.w});var c=[];this.textComponents.title.exists&&c.push(this.cssPrefix+"title"),this.textComponents.subtitle.exists&&c.push(this.cssPrefix+"subtitle"),this.textComponents.footer.exists&&c.push(this.cssPrefix+"footer"),w.whenElementsExist(c,function(){if(d.textComponents.title.exists){var a=w.getDimensions(d.cssPrefix+"title");d.textComponents.title.h=a.h,d.textComponents.title.w=a.w}if(d.textComponents.subtitle.exists){var f=w.getDimensions(d.cssPrefix+"subtitle");d.textComponents.subtitle.h=f.h,d.textComponents.subtitle.w=f.w}if(d.textComponents.title.exists||d.textComponents.subtitle.exists){var e=0;d.textComponents.title.exists&&(e+=d.textComponents.title.h,d.textComponents.subtitle.exists&&(e+=d.options.header.titleSubtitlePadding)),d.textComponents.subtitle.exists&&(e+=d.textComponents.subtitle.h),d.textComponents.headerHeight=e}u.computePieRadius(d),u.calculatePieCenter(d),r.positionTitle(d),r.positionSubtitle(d),d.options.misc.gradient.enabled&&s.addGradients(d),s.create(d),t.add(d,"inner",d.options.labels.inner.format),t.add(d,"outer",d.options.labels.outer.format),t.positionLabelElements(d,"inner",d.options.labels.inner.format),t.positionLabelElements(d,"outer",d.options.labels.outer.format),t.computeOuterLabelCoords(d),t.positionLabelGroups(d,"outer"),t.computeLabelLinePositions(d),d.options.labels.lines.enabled&&"none"!==d.options.labels.outer.format&&t.addLabelLines(d),t.positionLabelGroups(d,"inner"),t.fadeInLabelsAndLines(d),d.options.tooltips.enabled&&q.addTooltips(d),s.addSegmentEventHandlers(d)})};return p});