/*
 * Decompiled with CFR 0.152.
 */
package es.excentia.jira.plugins.stats.util;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import es.excentia.jira.plugins.stats.util.FormatUtils;
import es.excentia.jira.plugins.stats.util.IssueUtil;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public final class VersionUtil {
    private static final Logger LOG = Logger.getLogger(VersionUtil.class);

    private VersionUtil() {
    }

    public static Long getTotalTimespentForVersions(List<Map<String, Object>> list, boolean bl) {
        LOG.debug((Object)("Getting timespent for versions (released = " + bl + ")"));
        Long l = 0L;
        NumberFormat numberFormat = FormatUtils.getNumber();
        for (Map<String, Object> map : list) {
            Boolean bl2 = (boolean)((Boolean)map.get("released"));
            Boolean bl3 = (boolean)((Boolean)map.get("archived"));
            if ((!bl || !bl2.booleanValue() || bl3.booleanValue()) && (bl || bl2.booleanValue() || bl3.booleanValue())) continue;
            try {
                l = l + numberFormat.parse((String)map.get("timespent")).longValue();
            }
            catch (ParseException parseException) {
                LOG.error((Object)("Error parsing timespent for version " + map.get("name") + ": " + parseException.getMessage()));
            }
        }
        LOG.debug((Object)("Timespent for versions = " + l));
        return l;
    }

    public static Long getTotalTimespentForArchivedVersions(List<Map<String, Object>> list) {
        LOG.debug((Object)"Getting timespent for archived versions");
        Long l = 0L;
        NumberFormat numberFormat = FormatUtils.getNumber();
        for (Map<String, Object> map : list) {
            Boolean bl = (boolean)((Boolean)map.get("archived"));
            if (!bl.booleanValue()) continue;
            try {
                l = l + numberFormat.parse((String)map.get("timespent")).longValue();
            }
            catch (ParseException parseException) {
                LOG.error((Object)("Error parsing timespent for version " + map.get("name") + ": " + parseException.getMessage()));
            }
        }
        LOG.debug((Object)("Timespent for archived versions = " + l));
        return l;
    }

    public static Long getTotalTimespentForVersion(Map<String, Object> map) {
        LOG.debug((Object)"Getting timespent for version");
        NumberFormat numberFormat = FormatUtils.getNumber();
        Long l = 0L;
        if (map != null) {
            try {
                l = l + numberFormat.parse((String)map.get("timespent")).longValue();
            }
            catch (ParseException parseException) {
                LOG.error((Object)("Error parsing timespent for version " + map.get("name") + ": " + parseException.getMessage()));
            }
        }
        LOG.debug((Object)("Timespent for version = " + l));
        return l;
    }

    public static List<Map<String, Object>> generateVersionObjects(Map<String, Long> map, Issue[] issueArray, Long l, Project project) {
        Long[] longArray;
        Version version;
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        NumberFormat numberFormat = FormatUtils.getNumber();
        NumberFormat numberFormat2 = FormatUtils.getPercentage();
        for (Map.Entry<String, Long> object2 : map.entrySet()) {
            version = new HashMap();
            longArray = object2.getKey();
            String string = "None";
            Version version2 = null;
            if (!"-".equals(longArray)) {
                version2 = ComponentAccessor.getVersionManager().getVersion(Long.valueOf(Long.parseLong((String)longArray)));
                string = version2.getName();
                version.put("released", version2.isReleased());
                version.put("archived", version2.isArchived());
                version.put("releaseDate", VersionUtil.getReleaseDateFormatted(version2));
                version.put("startDate", VersionUtil.getStartDateFormatted(version2));
            }
            Long[] longArray2 = version2 == null ? IssueUtil.getTotalIssueTimeWithNoVersion(issueArray) : IssueUtil.getTotalIssueTime(issueArray, version2);
            Long l2 = longArray2[0];
            Long l3 = object2.getValue();
            Long l4 = longArray2[1];
            if (l3 == null) {
                l3 = 0L;
            }
            version.put("id", longArray);
            version.put("name", string);
            version.put("estimated", numberFormat.format((double)l2.longValue() / 3600.0));
            version.put("timespent", numberFormat.format((double)l3.longValue() / 3600.0));
            version.put("remaining", numberFormat.format((double)l4.longValue() / 3600.0));
            version.put("percent", numberFormat2.format((double)l3.longValue() / (double)l.longValue()));
            version.put("expected", numberFormat.format((double)(l3 + l4) / 3600.0));
            version.put("estimatedDeviation", numberFormat.format((double)(l2 - l3) / 3600.0));
            arrayList.add((Map<String, Object>)version);
            LOG.debug((Object)("Version " + string + " - Estimated/timespent/remaining: " + l2 + "/" + l3 + "/" + l4));
        }
        List list = ComponentAccessor.getVersionManager().getVersions(project);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            version = (Version)iterator.next();
            if (map.containsKey(version.getId().toString())) continue;
            longArray = IssueUtil.getTotalIssueTime(issueArray, version);
            arrayList.add(VersionUtil.generateEmptyVersionMap(version, numberFormat.format((double)longArray[0].longValue() / 3600.0), numberFormat.format((double)longArray[1].longValue() / 3600.0)));
        }
        return arrayList;
    }

    public static Map<String, Object> generateEmptyVersionMap(Version version, String string, String string2) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("id", version.getId().toString());
        hashMap.put("name", version.getName());
        hashMap.put("released", version.isReleased());
        hashMap.put("archived", version.isArchived());
        hashMap.put("releaseDate", VersionUtil.getReleaseDateFormatted(version));
        hashMap.put("startDate", VersionUtil.getStartDateFormatted(version));
        hashMap.put("estimated", string);
        hashMap.put("timespent", "0");
        hashMap.put("remaining", string2);
        hashMap.put("percent", "0%");
        hashMap.put("expected", "0");
        hashMap.put("estimatedDeviation", "0");
        return hashMap;
    }

    public static String getReleaseDateFormatted(Version version) {
        DateFormat dateFormat = FormatUtils.getDate();
        Date date = version.getReleaseDate();
        String string = "-";
        if (date != null) {
            string = dateFormat.format(date);
        }
        return string;
    }

    public static String getStartDateFormatted(Version version) {
        DateFormat dateFormat = FormatUtils.getDate();
        Date date = version.getStartDate();
        String string = "-";
        if (date != null) {
            string = dateFormat.format(date);
        }
        return string;
    }

    public static Map<String, Object> generateUnknowVersionObject(List<Map<String, Object>> list, Issue[] issueArray) {
        Map<String, Object> map2;
        Object object = new HashMap<String, Object>();
        for (Map<String, Object> map2 : list) {
            if (!"-".equals(map2.get("id"))) continue;
            LOG.debug((Object)("Worklogs without version " + map2.get("id") + " - Estimated/timespent/remaining: " + map2.get("estimated") + "//" + map2.get("timespent") + "/" + map2.get("remaining")));
            object = map2;
        }
        Long[] longArray = IssueUtil.getTotalIssueTimeWithNoVersion(issueArray);
        map2 = FormatUtils.getNumber();
        if (object.isEmpty()) {
            object.put("id", "-");
            object.put("name", "None");
            object.put("estimated", ((NumberFormat)((Object)map2)).format((double)longArray[0].longValue() / 3600.0));
            object.put("timespent", "0");
            object.put((String)"remaining", (Object)((NumberFormat)((Object)map2)).format((double)longArray[1].longValue() / 3600.0));
            object.put("percent", "0%");
            object.put("expected", "0");
            object.put("estimatedDeviation", "0");
        } else {
            object.put("estimated", ((NumberFormat)((Object)map2)).format((double)longArray[0].longValue() / 3600.0));
            object.put("remaining", ((NumberFormat)((Object)map2)).format((double)longArray[1].longValue() / 3600.0));
        }
        return object;
    }
}

