/*
 * Decompiled with CFR 0.152.
 */
package es.excentia.jira.plugins.stats.util;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.issue.worklog.WorklogManager;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.query.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public final class IssueUtil {
    public static final int SECONDS_PER_HOUR = 3600;
    private static final Logger LOG = Logger.getLogger(IssueUtil.class);

    private IssueUtil() {
    }

    public static Issue[] getProjectIssues(ApplicationUser applicationUser, String string, SearchService searchService) throws SearchException {
        JqlQueryBuilder jqlQueryBuilder = JqlQueryBuilder.newBuilder();
        Query query = jqlQueryBuilder.where().project(new String[]{string}).buildQuery();
        SearchResults searchResults = searchService.search(applicationUser, query, PagerFilter.getUnlimitedFilter());
        return searchResults.getResults().toArray(new Issue[searchResults.getTotal()]);
    }

    public static Long[] getTotalIssueTime(Issue[] issueArray, ApplicationUser applicationUser) {
        Long l = 0L;
        Long l2 = 0L;
        for (Issue issue : issueArray) {
            if (issue == null) continue;
            Long l3 = issue.getEstimate();
            Long l4 = issue.getOriginalEstimate();
            ApplicationUser applicationUser2 = issue.getAssigneeUser();
            if (applicationUser == null || applicationUser2 == null || !applicationUser2.getName().equals(applicationUser.getName())) continue;
            if (l4 != null) {
                l = l + l4;
            }
            if (l3 == null || issue.getResolutionDate() != null) continue;
            l2 = l2 + l3;
        }
        LOG.trace((Object)("Issues: " + issueArray.length + "      Total user estimated: " + l + " Total user remaining: " + l2));
        return new Long[]{l, l2};
    }

    public static Long[] getTotalIssueTime(Issue[] issueArray, Version version) {
        Long l = 0L;
        Long l2 = 0L;
        for (Issue issue : issueArray) {
            if (issue == null) continue;
            Long l3 = issue.getEstimate();
            Long l4 = issue.getOriginalEstimate();
            Collection collection = issue.getFixVersions();
            if ((version == null || !collection.contains(version)) && (version != null || !collection.isEmpty())) continue;
            if (l4 != null) {
                l = l + l4;
            }
            if (l3 == null || issue.getResolutionDate() != null) continue;
            l2 = l2 + l3;
        }
        if (version != null) {
            LOG.trace((Object)("Version " + version.getName() + "    Total version estimated: " + l + " Total version remaining: " + l2));
        }
        return new Long[]{l, l2};
    }

    public static Long[] getTotalIssueTimeWithNoVersion(Issue[] issueArray) {
        Long l = 0L;
        Long l2 = 0L;
        for (Issue issue : issueArray) {
            if (issue == null) continue;
            Long l3 = issue.getEstimate();
            Long l4 = issue.getOriginalEstimate();
            Collection collection = issue.getFixVersions();
            if (!collection.isEmpty()) continue;
            if (l4 != null) {
                l = l + l4;
            }
            if (l3 == null || issue.getResolutionDate() != null) continue;
            l2 = l2 + l3;
        }
        LOG.trace((Object)("Without version - estimated: " + l + " - remaining: " + l2));
        return new Long[]{l, l2};
    }

    public static Long[] getTotalIssueTime(Issue[] issueArray, ProjectComponent projectComponent) {
        Long l = 0L;
        Long l2 = 0L;
        for (Issue issue : issueArray) {
            if (issue == null) continue;
            Long l3 = issue.getEstimate();
            Long l4 = issue.getOriginalEstimate();
            LOG.trace((Object)("Remaining/estimated: " + l3 + "/" + l4));
            if (!IssueUtil.isComponentInIssue(projectComponent, issue) && (projectComponent != null || !issue.getComponents().isEmpty())) continue;
            if (l4 != null) {
                l = l + l4;
            }
            if (l3 == null || issue.getResolutionDate() != null) continue;
            l2 = l2 + l3;
        }
        LOG.trace((Object)("Issues: " + issueArray.length + "      Total component estimated: " + l + " Total component remaining: " + l2));
        return new Long[]{l, l2};
    }

    public static Long[] getTotalIssueTime(Issue[] issueArray, IssueType issueType) {
        Long l = 0L;
        Long l2 = 0L;
        for (Issue issue : issueArray) {
            if (issue == null) continue;
            Long l3 = issue.getEstimate();
            Long l4 = issue.getOriginalEstimate();
            LOG.trace((Object)("Remaining/estimated: " + l3 + "/" + l4));
            if (issueType == null || !issueType.equals(issue.getIssueType())) continue;
            if (l4 != null) {
                l = l + l4;
            }
            if (l3 == null || issue.getResolutionDate() != null) continue;
            l2 = l2 + l3;
        }
        LOG.trace((Object)("Issues: " + issueArray.length + "      Total issue type estimated: " + l + " Total issue type remaining: " + l2));
        return new Long[]{l, l2};
    }

    public static Long[] getTotalIssueTime(Issue[] issueArray, String string, String string2) {
        Long l = 0L;
        Long l2 = 0L;
        for (Issue issue : issueArray) {
            if (issue == null) continue;
            Long l3 = issue.getEstimate();
            Long l4 = issue.getOriginalEstimate();
            LOG.trace((Object)("Remaining/estimated: " + l3 + "/" + l4));
            String string3 = IssueUtil.getFieldValue(string, issue);
            if (string2 == null || !string3.equals(string2)) continue;
            if (l4 != null) {
                l = l + l4;
            }
            if (l3 == null || issue.getResolutionDate() != null) continue;
            l2 = l2 + l3;
        }
        LOG.trace((Object)("Issues: " + issueArray.length + "      Total issue type estimated: " + l + " Total issue type remaining: " + l2));
        return new Long[]{l, l2};
    }

    private static boolean isComponentInIssue(ProjectComponent projectComponent, Issue issue) {
        if (projectComponent != null) {
            Collection collection = issue.getComponents();
            for (ProjectComponent projectComponent2 : collection) {
                if (!projectComponent.getId().equals(projectComponent2.getId())) continue;
                return true;
            }
        }
        return false;
    }

    public static Long[] getTotalIssueTime(Issue[] issueArray) {
        Long[] longArray = new Long[]{0L, 0L, 0L};
        for (Issue issue : issueArray) {
            Long l;
            Object object;
            Long l2 = issue.getOriginalEstimate();
            if (l2 != null) {
                object = longArray;
                int n = 0;
                Long.valueOf(object[n] + l2);
            }
            if ((object = issue.getTimeSpent()) != null) {
                Long[] longArray2 = longArray;
                int n = 1;
                Long.valueOf(longArray2[n] + (Long)object);
            }
            if ((l = issue.getEstimate()) == null || issue.getResolutionDate() != null) continue;
            Long[] longArray3 = longArray;
            int n = 2;
            Long.valueOf(longArray3[n] + l);
        }
        LOG.trace((Object)("Issues: " + issueArray.length + "      Total estimated/worked/remaining: " + longArray[0] + "/" + longArray[1] + "/" + longArray[2]));
        return longArray;
    }

    public static int getNumberOfOpenedIssues(ApplicationUser applicationUser, ApplicationUser applicationUser2, SearchService searchService) throws SearchException {
        JqlQueryBuilder jqlQueryBuilder = JqlQueryBuilder.newBuilder();
        Query query = jqlQueryBuilder.where().assigneeUser(applicationUser2.getName()).and().statusCategory().notEq("done").buildQuery();
        SearchResults searchResults = searchService.search(applicationUser, query, PagerFilter.getUnlimitedFilter());
        return searchResults.getTotal();
    }

    public static Map<String, Map<String, Long>> getTimespentFromWorklogs(Worklog[] worklogArray, Date date, Date date2, UserManager userManager, String string) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        HashMap<String, Object> hashMap3 = new HashMap<String, Object>();
        HashMap<String, Long> hashMap4 = new HashMap<String, Long>();
        HashMap<String, Long> hashMap5 = new HashMap<String, Long>();
        for (Worklog worklog : worklogArray) {
            Long l;
            Object object;
            Long l2;
            Object object22;
            Object object3;
            String string2 = "";
            if (worklog.getAuthorKey() == null) {
                string2 = "anonymous";
            } else {
                object3 = userManager.getUserByKey(worklog.getAuthorKey());
                if (object3 == null) {
                    string2 = "-";
                    LOG.debug((Object)("WARNING: Worklog " + worklog.getId() + " with time spent (" + worklog.getTimeSpent() + " for author key " + worklog.getAuthorKey() + " but JIRA user is NULL!"));
                } else {
                    string2 = object3.getName();
                }
            }
            LOG.trace((Object)("Worklog (" + worklog.getId() + ") data: author = " + string2 + " - Timespent = " + worklog.getTimeSpent()));
            if (!worklog.getUpdated().after(date) || !worklog.getUpdated().before(date2)) continue;
            object3 = (Long)hashMap.get(string2);
            if (object3 == null) {
                object3 = 0L;
            }
            object3 = (Long)object3 + worklog.getTimeSpent();
            hashMap.put(string2, object3);
            LOG.trace((Object)("Worklog for author " + string2 + " and issue " + worklog.getIssue().getKey() + " : " + worklog.getTimeSpent()));
            Collection collection = worklog.getIssue().getFixVersions();
            for (Object object22 : collection) {
                l2 = (Long)hashMap2.get(object22.getId().toString());
                if (l2 == null) {
                    l2 = 0L;
                }
                l2 = l2 + worklog.getTimeSpent();
                hashMap2.put(object22.getId().toString(), l2);
                LOG.trace((Object)("Worklog for version " + object22.getName() + " and issue " + worklog.getIssue().getKey() + " : " + worklog.getTimeSpent()));
            }
            if (collection.isEmpty()) {
                object = (Long)hashMap2.get("-");
                if (object == null) {
                    object = 0L;
                }
                object = (Long)object + worklog.getTimeSpent();
                hashMap2.put("-", object);
                LOG.trace((Object)("Worklog without version for issue " + worklog.getIssue().getKey() + " : " + worklog.getTimeSpent()));
            }
            object = worklog.getIssue().getComponents();
            object22 = object.iterator();
            while (object22.hasNext()) {
                l2 = (ProjectComponent)object22.next();
                l = (Long)hashMap3.get(l2.getId().toString());
                if (l == null) {
                    l = 0L;
                }
                l = l + worklog.getTimeSpent();
                hashMap3.put(l2.getId().toString(), l);
                LOG.trace((Object)("Worklog for component " + l2.getName() + " and issue " + worklog.getIssue().getKey() + " : " + worklog.getTimeSpent()));
            }
            if (object.isEmpty()) {
                object22 = (Long)hashMap3.get("-");
                if (object22 == null) {
                    object22 = 0L;
                }
                object22 = (Long)object22 + worklog.getTimeSpent();
                hashMap3.put("-", object22);
                LOG.trace((Object)("Worklog without component for issue " + worklog.getIssue().getKey() + " : " + worklog.getTimeSpent()));
            }
            if ((l2 = (Long)hashMap4.get((object22 = worklog.getIssue().getIssueType()).getId())) == null) {
                l2 = 0L;
            }
            l2 = l2 + worklog.getTimeSpent();
            hashMap4.put(object22.getId(), l2);
            LOG.trace((Object)("Worklog for issue type " + object22.getName() + " and issue " + worklog.getIssue().getKey() + " : " + worklog.getTimeSpent()));
            if (string == null || "none".equals(string) || "".equals(string)) continue;
            l = ComponentAccessor.getFieldManager().getField(string);
            String string3 = IssueUtil.getFieldValue(string, worklog.getIssue());
            Long l3 = (Long)hashMap5.get(string3);
            if (l3 == null) {
                l3 = 0L;
            }
            l3 = l3 + worklog.getTimeSpent();
            hashMap5.put(string3, l3);
            LOG.debug((Object)("Worklog for additional field " + l.getName() + " (" + string + ") and value " + string3 + " and issue " + worklog.getIssue().getKey() + " : " + worklog.getTimeSpent()));
        }
        LOG.trace((Object)("Worklogs: " + worklogArray.length + "      Users: " + hashMap.size() + "        Versions: " + hashMap2.size() + "      Components: " + hashMap3.size() + "       Issue Types: " + hashMap4.size()));
        HashMap hashMap6 = new HashMap();
        hashMap6.put("users", hashMap);
        hashMap6.put("versions", hashMap2);
        hashMap6.put("components", hashMap3);
        hashMap6.put("issueTypes", hashMap4);
        hashMap6.put("additionalField", hashMap5);
        return hashMap6;
    }

    public static String getFieldValue(String string, Issue issue) {
        String string2 = "-";
        if (ComponentAccessor.getFieldManager().isCustomFieldId(string)) {
            CustomField customField = ComponentAccessor.getCustomFieldManager().getCustomFieldObject(string);
            Object object = issue.getCustomFieldValue(customField);
            if (object != null) {
                string2 = object.toString();
            }
            LOG.debug((Object)("The field id " + string + " is a custom field and value for issue " + issue.getKey() + " is " + string2));
        } else if ("priority".equals(string) && issue.getPriority() != null) {
            string2 = issue.getPriority().getNameTranslation(ComponentAccessor.getJiraAuthenticationContext().getLocale().toString());
        } else if ("creator".equals(string) && issue.getCreator() != null) {
            string2 = issue.getCreator().getDisplayName();
        } else if ("environment".equals(string)) {
            string2 = issue.getEnvironment();
        } else if ("resolution".equals(string) && issue.getResolution() != null) {
            string2 = issue.getResolution().getNameTranslation(ComponentAccessor.getJiraAuthenticationContext().getLocale().toString());
        } else if ("reporter".equals(string) && issue.getReporter() != null) {
            string2 = issue.getReporter().getDisplayName();
        }
        if (string2 == null || "null".equals(string2)) {
            string2 = "-";
        }
        return string2;
    }

    public static Long getTimespentForIssues(Issue[] issueArray) {
        Long l = 0L;
        for (Issue issue : issueArray) {
            l = l + issue.getTimeSpent();
        }
        return l;
    }

    public static Worklog[] getIssuesWorklogs(Issue[] issueArray, WorklogManager worklogManager) {
        ArrayList arrayList = new ArrayList();
        for (Issue issue : issueArray) {
            List list = worklogManager.getByIssue(issue);
            LOG.trace((Object)("Issue " + issue.getKey() + " has " + list.size() + " worklogs."));
            arrayList.addAll(list);
        }
        LOG.debug((Object)("There are " + issueArray.length + " issues with " + arrayList.size() + " worklogs."));
        return arrayList.toArray(new Worklog[arrayList.size()]);
    }
}

