/*
 * Decompiled with CFR 0.152.
 */
package es.excentia.jira.plugins.stats.util;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.IssueTypeManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import es.excentia.jira.plugins.stats.util.FormatUtils;
import es.excentia.jira.plugins.stats.util.IssueUtil;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public final class IssueTypeUtil {
    private static final Logger LOG = Logger.getLogger(IssueTypeUtil.class);

    private IssueTypeUtil() {
    }

    public static Long getTotalTimespentForIssueTypes(List<Map<String, Object>> list) {
        LOG.debug((Object)"Getting timespent for all issue types");
        Long l = 0L;
        NumberFormat numberFormat = FormatUtils.getNumber();
        for (Map<String, Object> map : list) {
            try {
                l = l + numberFormat.parse((String)map.get("timespent")).longValue();
            }
            catch (ParseException parseException) {
                LOG.error((Object)("Error parsing timespent for issue types " + map.get("name") + ": " + parseException.getMessage()));
            }
        }
        LOG.debug((Object)("Timespent for issue types = " + l));
        return l;
    }

    public static Long getTotalTimespentForIssueType(Map<String, Object> map) {
        LOG.debug((Object)"Getting timespent for issue type");
        NumberFormat numberFormat = FormatUtils.getNumber();
        Long l = 0L;
        if (map != null) {
            try {
                l = l + numberFormat.parse((String)map.get("timespent")).longValue();
            }
            catch (ParseException parseException) {
                LOG.error((Object)("Error parsing timespent for issue type " + map.get("name") + ": " + parseException.getMessage()));
            }
        }
        LOG.debug((Object)("Timespent for issue type = " + l));
        return l;
    }

    public static List<Map<String, Object>> generateIssueTypesObjects(Map<String, Long> map, Issue[] issueArray, Long l, Project project, IssueTypeManager issueTypeManager) {
        Long[] longArray;
        IssueType issueType;
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        NumberFormat numberFormat = FormatUtils.getNumber();
        NumberFormat numberFormat2 = FormatUtils.getPercentage();
        for (Map.Entry<String, Long> object2 : map.entrySet()) {
            issueType = new HashMap();
            longArray = object2.getKey();
            String string = "None";
            String string2 = "";
            IssueType issueType2 = null;
            LOG.debug((Object)("Building issue type map for issue type " + (String)longArray));
            if (!"-".equals(longArray)) {
                issueType2 = issueTypeManager.getIssueType((String)longArray);
                string = issueType2.getNameTranslation(ComponentAccessor.getJiraAuthenticationContext().getI18nHelper());
                string2 = issueType2.getCompleteIconUrl();
            }
            LOG.debug((Object)("Issue type name: " + string));
            Long[] longArray2 = IssueUtil.getTotalIssueTime(issueArray, issueType2);
            Long l2 = longArray2[0];
            Long l3 = object2.getValue();
            Long l4 = longArray2[1];
            if (l3 == null) {
                l3 = 0L;
            }
            issueType.put("id", longArray);
            issueType.put("name", string);
            issueType.put("iconUrl", string2);
            issueType.put("estimated", numberFormat.format((double)l2.longValue() / 3600.0));
            issueType.put("timespent", numberFormat.format((double)l3.longValue() / 3600.0));
            issueType.put("timespent-chart", (long)((double)l3.longValue() / 3600.0));
            issueType.put("remaining", numberFormat.format((double)l4.longValue() / 3600.0));
            issueType.put("percent", numberFormat2.format((double)l3.longValue() / (double)l.longValue()));
            issueType.put("expected", numberFormat.format((double)(l3 + l4) / 3600.0));
            issueType.put("estimatedDeviation", numberFormat.format((double)(l2 - l3) / 3600.0));
            arrayList.add((Map<String, Object>)issueType);
            LOG.debug((Object)("Issue type " + string + " - Estimated/timespent/remaining: " + l2 + "/" + l3 + "/" + l4));
        }
        Collection collection = ComponentAccessor.getIssueTypeSchemeManager().getIssueTypesForProject(project);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            issueType = (IssueType)iterator.next();
            longArray = IssueUtil.getTotalIssueTime(issueArray, issueType);
            if (longArray[0] <= 0L && longArray[1] <= 0L || map.containsKey(issueType.getId())) continue;
            arrayList.add(IssueTypeUtil.generateEmptyIssueTypeMap(issueType, numberFormat.format((double)longArray[0].longValue() / 3600.0), numberFormat.format((double)longArray[1].longValue() / 3600.0)));
        }
        return arrayList;
    }

    public static Map<String, Object> generateEmptyIssueTypeMap(IssueType issueType, String string, String string2) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("id", issueType.getId());
        hashMap.put("name", issueType.getNameTranslation(ComponentAccessor.getJiraAuthenticationContext().getI18nHelper()));
        hashMap.put("iconUrl", issueType.getCompleteIconUrl());
        hashMap.put("estimated", string);
        hashMap.put("timespent", "0");
        hashMap.put("timespent-chart", "0");
        hashMap.put("remaining", string2);
        hashMap.put("percent", "0%");
        hashMap.put("expected", "0");
        hashMap.put("estimatedDeviation", "0");
        return hashMap;
    }
}

