/*
 * Decompiled with CFR 0.152.
 */
package es.excentia.jira.plugins.stats.util;

import com.atlassian.jira.issue.Issue;
import es.excentia.jira.plugins.stats.util.FormatUtils;
import es.excentia.jira.plugins.stats.util.IssueUtil;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public final class FieldUtil {
    private static final Logger LOG = Logger.getLogger(FieldUtil.class);

    private FieldUtil() {
    }

    public static List<Map<String, Object>> generateFieldValuesObjects(Map<String, Long> map, Issue[] issueArray, Long l, String string) {
        Long[] longArray;
        Object object;
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        NumberFormat numberFormat = FormatUtils.getNumber();
        NumberFormat numberFormat2 = FormatUtils.getPercentage();
        for (Map.Entry<String, Long> object22 : map.entrySet()) {
            object = new HashMap();
            longArray = object22.getKey();
            if ("null".equals(longArray)) {
                longArray = "-";
            }
            LOG.debug((Object)("Building field value map for field " + string + " and value " + (String)longArray));
            Long[] longArray2 = IssueUtil.getTotalIssueTime(issueArray, string, (String)longArray);
            Long l2 = longArray2[0];
            Long l3 = object22.getValue();
            Long l4 = longArray2[1];
            if (l3 == null) {
                l3 = 0L;
            }
            object.put("value", longArray);
            object.put("estimated", numberFormat.format((double)l2.longValue() / 3600.0));
            object.put("timespent", numberFormat.format((double)l3.longValue() / 3600.0));
            object.put("timespent-chart", (long)((double)l3.longValue() / 3600.0));
            object.put("remaining", numberFormat.format((double)l4.longValue() / 3600.0));
            object.put("percent", numberFormat2.format((double)l3.longValue() / (double)l.longValue()));
            object.put("expected", numberFormat.format((double)(l3 + l4) / 3600.0));
            object.put("estimatedDeviation", numberFormat.format((double)(l2 - l3) / 3600.0));
            arrayList.add((Map<String, Object>)object);
            LOG.debug((Object)("Field value " + (String)longArray + " - Estimated/timespent/remaining: " + l2 + "/" + l3 + "/" + l4));
        }
        ArrayList<String> arrayList2 = FieldUtil.getEmptyTimeSpentFieldValues(map, string, issueArray);
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            longArray = IssueUtil.getTotalIssueTime(issueArray, string, (String)object);
            if (longArray[0] <= 0L && longArray[1] <= 0L) continue;
            arrayList.add(FieldUtil.generateEmptyFieldValueMap((String)object, numberFormat.format((double)longArray[0].longValue() / 3600.0), numberFormat.format((double)longArray[1].longValue() / 3600.0)));
        }
        return arrayList;
    }

    private static ArrayList<String> getEmptyTimeSpentFieldValues(Map<String, Long> map, String string, Issue[] issueArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Issue issue : issueArray) {
            String string2;
            if (issue == null || map.containsKey(string2 = IssueUtil.getFieldValue(string, issue)) || arrayList.contains(string2)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static Map<String, Object> generateEmptyFieldValueMap(String string, String string2, String string3) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("value", string);
        hashMap.put("estimated", string2);
        hashMap.put("timespent", "0");
        hashMap.put("timespent-chart", "0");
        hashMap.put("remaining", string3);
        hashMap.put("percent", "0%");
        hashMap.put("expected", "0");
        hashMap.put("estimatedDeviation", "0");
        return hashMap;
    }
}

