/*
 * Decompiled with CFR 0.152.
 */
package es.excentia.jira.plugins.stats.util;

import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.project.Project;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import es.excentia.jira.plugins.stats.admin.ComponentConfigurationRepresentation;
import es.excentia.jira.plugins.stats.util.FormatUtils;
import es.excentia.jira.plugins.stats.util.IssueUtil;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public final class ComponentUtil {
    private static final Logger LOG = Logger.getLogger(ComponentUtil.class);

    private ComponentUtil() {
    }

    public static Long getTotalTimespentForComponents(List<Map<String, Object>> list) {
        LOG.debug((Object)"Getting timespent for components");
        Long l = 0L;
        NumberFormat numberFormat = FormatUtils.getNumber();
        for (Map<String, Object> map : list) {
            try {
                l = l + numberFormat.parse((String)map.get("timespent")).longValue();
            }
            catch (ParseException parseException) {
                LOG.error((Object)("Error parsing timespent for component " + map.get("name") + ": " + parseException.getMessage()));
            }
        }
        LOG.debug((Object)("Timespent for components = " + l));
        return l;
    }

    public static Long getTotalTimespentForComponent(Map<String, Object> map) {
        LOG.debug((Object)"Getting timespent for component");
        NumberFormat numberFormat = FormatUtils.getNumber();
        Long l = 0L;
        if (map != null) {
            try {
                l = l + numberFormat.parse((String)map.get("timespent")).longValue();
            }
            catch (ParseException parseException) {
                LOG.error((Object)("Error parsing timespent for component " + map.get("name") + ": " + parseException.getMessage()));
            }
        }
        LOG.debug((Object)("Timespent for component = " + l));
        return l;
    }

    public static List<Map<String, Object>> generateComponentObjects(PluginSettingsFactory pluginSettingsFactory, Map<String, Long> map, Issue[] issueArray, Long l, Project project) {
        String string;
        Long[] longArray;
        ProjectComponent projectComponent;
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        NumberFormat numberFormat = FormatUtils.getNumber();
        NumberFormat numberFormat2 = FormatUtils.getPercentage();
        String string2 = null;
        for (Map.Entry<String, Long> object2 : map.entrySet()) {
            projectComponent = new HashMap();
            longArray = object2.getKey();
            string = "None";
            ProjectComponent projectComponent2 = null;
            LOG.debug((Object)("Building component map for component " + (String)longArray));
            if (!"-".equals(longArray)) {
                projectComponent2 = ComponentAccessor.getProjectComponentManager().getProjectComponent(Long.valueOf(Long.parseLong((String)longArray)));
                string = projectComponent2.getName();
            }
            LOG.debug((Object)("Component name: " + string));
            Long[] longArray2 = IssueUtil.getTotalIssueTime(issueArray, projectComponent2);
            Long l2 = longArray2[0];
            Long l3 = object2.getValue();
            Long l4 = longArray2[1];
            if (l3 == null) {
                l3 = 0L;
            }
            projectComponent.put("id", longArray);
            projectComponent.put("name", string);
            projectComponent.put("estimated", numberFormat.format((double)l2.longValue() / 3600.0));
            projectComponent.put("timespent", numberFormat.format((double)l3.longValue() / 3600.0));
            projectComponent.put("remaining", numberFormat.format((double)l4.longValue() / 3600.0));
            projectComponent.put("percent", numberFormat2.format((double)l3.longValue() / (double)l.longValue()));
            projectComponent.put("expected", numberFormat.format((double)(l3 + l4) / 3600.0));
            PluginSettings pluginSettings = pluginSettingsFactory.createSettingsForKey(project.getId() + "-" + (String)longArray);
            string2 = (String)pluginSettings.get(ComponentConfigurationRepresentation.class.getName() + ".hours");
            if (string2 == null) {
                string2 = "0";
            }
            projectComponent.put("contracted", numberFormat.format(Long.valueOf(string2)));
            projectComponent.put("estimatedDeviation", numberFormat.format((double)(l2 - l3) / 3600.0));
            arrayList.add((Map<String, Object>)projectComponent);
            LOG.debug((Object)("Component " + string + " - Estimated/timespent/remaining: " + l2 + "/" + l3 + "/" + l4));
        }
        Collection collection = ComponentAccessor.getProjectComponentManager().findAllForProject(project.getId());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            projectComponent = (ProjectComponent)iterator.next();
            if (map.containsKey(projectComponent.getId().toString())) continue;
            longArray = IssueUtil.getTotalIssueTime(issueArray, projectComponent);
            LOG.debug((Object)("-->" + project.getKey() + "-" + projectComponent.getId()));
            string = pluginSettingsFactory.createSettingsForKey(project.getId() + "-" + projectComponent.getId());
            LOG.debug((Object)("settings: " + string + ":" + string.get(ComponentConfigurationRepresentation.class.getName() + ".hours") + "_" + string.get(ComponentConfigurationRepresentation.class.getName() + ".componentId")));
            string2 = (String)string.get(ComponentConfigurationRepresentation.class.getName() + ".hours");
            if (string2 == null) {
                string2 = "0";
            }
            arrayList.add(ComponentUtil.generateEmptyComponentMap(projectComponent, numberFormat.format((double)longArray[0].longValue() / 3600.0), numberFormat.format((double)longArray[1].longValue() / 3600.0), string2));
        }
        return arrayList;
    }

    public static Map<String, Object> generateEmptyComponentMap(ProjectComponent projectComponent, String string, String string2, String string3) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("id", projectComponent.getId().toString());
        hashMap.put("name", projectComponent.getName());
        hashMap.put("estimated", string);
        hashMap.put("timespent", "0");
        hashMap.put("remaining", string2);
        hashMap.put("percent", "0%");
        hashMap.put("expected", string2);
        hashMap.put("estimatedDeviation", string2);
        hashMap.put("contracted", string3);
        LOG.debug((Object)("Component " + projectComponent.getName() + " - Estimated/timespent/remaining: " + string + "/0/" + string2 + " - Contracted:" + string3));
        return hashMap;
    }

    public static Map<String, Object> generateUnknowComponentObject(List<Map<String, Object>> list) {
        for (Map<String, Object> map : list) {
            if (!"-".equals(map.get("id"))) continue;
            LOG.debug((Object)("Worklogs without component " + map.get("id") + " - Estimated/timespent/remaining: " + map.get("estimated") + "//" + map.get("timespent") + "/" + map.get("remaining")));
            return map;
        }
        return null;
    }
}

