/*
 * Decompiled with CFR 0.152.
 */
package es.excentia.jira.plugins.stats.tab;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.IssueTypeManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.issue.worklog.WorklogManager;
import com.atlassian.jira.plugin.projectpanel.impl.AbstractProjectTabPanel;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.browse.BrowseContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import es.excentia.jira.plugins.stats.admin.ConfigurationRepresentation;
import es.excentia.jira.plugins.stats.util.ComponentUtil;
import es.excentia.jira.plugins.stats.util.FieldUtil;
import es.excentia.jira.plugins.stats.util.FormatUtils;
import es.excentia.jira.plugins.stats.util.IssueTypeUtil;
import es.excentia.jira.plugins.stats.util.IssueUtil;
import es.excentia.jira.plugins.stats.util.VersionUtil;
import java.net.URI;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ProjectStatsTabPanel
extends AbstractProjectTabPanel {
    private final UserManager userManager;
    private final SearchService searchService;
    private final WorklogManager worklogManager;
    private final PluginSettingsFactory pluginSettingsFactory;
    private final PluginLicenseManager licenseManager;
    private final IssueTypeManager issueTypeManager;
    private static final Logger LOG = Logger.getLogger(ProjectStatsTabPanel.class);
    private NumberFormat percentage;
    private NumberFormat number;

    public ProjectStatsTabPanel(SearchService searchService, WorklogManager worklogManager, UserManager userManager, PluginSettingsFactory pluginSettingsFactory, PluginLicenseManager pluginLicenseManager, IssueTypeManager issueTypeManager) {
        this.searchService = searchService;
        this.worklogManager = worklogManager;
        this.userManager = userManager;
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.licenseManager = pluginLicenseManager;
        this.issueTypeManager = issueTypeManager;
        this.number = FormatUtils.getNumber();
        this.percentage = FormatUtils.getPercentage();
    }

    public boolean showPanel(BrowseContext browseContext) {
        return true;
    }

    public Map<String, Object> createVelocityParams(BrowseContext browseContext) {
        Project project = browseContext.getProject();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Map<Object, Object> map = new HashMap();
        String string = "";
        String string2 = "";
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        PluginLicense pluginLicense = null;
        if (this.licenseManager.getLicense().isDefined()) {
            pluginLicense = (PluginLicense)this.licenseManager.getLicense().get();
            LOG.debug((Object)("Plugin license found. Description: " + pluginLicense.getDescription()));
            bl = true;
            bl4 = pluginLicense.isEvaluation();
            bl5 = pluginLicense.isMaintenanceExpired();
            if (pluginLicense.getError().isDefined()) {
                string2 = ((LicenseError)pluginLicense.getError().get()).name();
                LOG.debug((Object)("Plugin license error: " + string2));
                bl3 = true;
            } else {
                LOG.debug((Object)"Plugin license is valid. ");
                bl2 = true;
                try {
                    map = this.generateReportObjects(project);
                }
                catch (SearchException | NullPointerException throwable) {
                    string = throwable.getMessage();
                    LOG.debug((Object)("ERROR during plugin execution: " + string));
                    LOG.debug((Object)"ERROR: {}", throwable);
                }
                hashMap.put("project", map);
                hashMap.put("errorMessage", string);
            }
        } else {
            LOG.debug((Object)"Plugin unlicensed. ");
        }
        LOG.debug((Object)("Plugin license info: Licensed (" + bl + "), Valid (" + bl2 + "), Error (" + bl3 + "), Evaluation (" + bl4 + "), Expired (" + bl5 + ")"));
        hashMap.put("licensed", bl);
        hashMap.put("licenseHasError", bl3);
        hashMap.put("licenseIsValid", bl2);
        hashMap.put("licenseError", string2);
        hashMap.put("pluginLicense", pluginLicense);
        return hashMap;
    }

    public final Map<String, Object> generateReportObjects(Project project) throws SearchException {
        Object object;
        Long l;
        Long l2;
        Long l3;
        Object object2;
        Object object3;
        LOG.debug((Object)("Generating report for project " + project));
        ApplicationUser applicationUser = this.authenticationContext.getLoggedInUser();
        this.number = FormatUtils.getNumber();
        this.percentage = FormatUtils.getPercentage();
        Collection collection = this.userManager.getAllApplicationUsers();
        Calendar calendar = Calendar.getInstance();
        Date date = calendar.getTime();
        calendar.set(2000, 1, 1);
        Date date2 = calendar.getTime();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("object", project);
        String string = project.getName();
        String string2 = project.getId().toString();
        AvatarService avatarService = ComponentAccessor.getAvatarService();
        LOG.debug((Object)("Project name: " + string + "      Project ID: " + string2));
        Issue[] issueArray = IssueUtil.getProjectIssues(applicationUser, project.getName(), this.searchService);
        Worklog[] worklogArray = IssueUtil.getIssuesWorklogs(issueArray, this.worklogManager);
        LOG.debug((Object)("Number of issues in this project: " + issueArray.length));
        hashMap.put("totalissues", issueArray.length);
        Long[] longArray = IssueUtil.getTotalIssueTime(issueArray);
        hashMap.put("hoursEstimated", this.number.format((double)longArray[0].longValue() / 3600.0));
        hashMap.put("hoursWorked", this.number.format((double)longArray[1].longValue() / 3600.0));
        hashMap.put("hoursRemaining", this.number.format((double)longArray[2].longValue() / 3600.0));
        hashMap.put("hoursFullEstimated", this.number.format((double)(longArray[1] + longArray[2]) / 3600.0));
        hashMap.put("hoursCurrentDeviation", this.number.format((double)(longArray[0] - longArray[1]) / 3600.0));
        hashMap.put("hoursExpectedDeviation", this.number.format((double)(longArray[0] - (longArray[1] + longArray[2])) / 3600.0));
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Long l4 = longArray[0];
        Long l5 = longArray[1];
        Long l6 = longArray[2];
        Long l7 = longArray[1] + longArray[2];
        LOG.debug((Object)(" Total project estimated/timespent/remaining: " + l4 + "/" + l5 + "/" + l6));
        LOG.debug((Object)("                                    Expected: " + l7));
        PluginSettings pluginSettings = this.pluginSettingsFactory.createSettingsForKey(string2);
        String string3 = (String)pluginSettings.get(ConfigurationRepresentation.class.getName() + ".hours");
        if (string3 == null) {
            string3 = "0";
        }
        hashMap.put("contractHours", this.number.format(Long.valueOf(string3)));
        hashMap.put("hoursContractedDeviation", this.number.format((double)Long.valueOf(string3).longValue() - (double)longArray[1].longValue() / 3600.0));
        String string4 = (String)pluginSettings.get(ConfigurationRepresentation.class.getName() + ".field");
        Map<String, Map<String, Long>> map = IssueUtil.getTimespentFromWorklogs(worklogArray, date2, date, this.userManager, string4);
        Map<String, Long> map2 = map.get("users");
        Map<String, Long> map3 = map.get("versions");
        Map<String, Long> map4 = map.get("components");
        Map<String, Long> map5 = map.get("issueTypes");
        Map<String, Long> map6 = map.get("additionalField");
        for (Map.Entry<String, Long> applicationUser2 : map2.entrySet()) {
            LOG.debug((Object)(" User " + applicationUser2.getKey() + " has worklogs on this project with timespent = " + applicationUser2.getValue()));
        }
        for (ApplicationUser applicationUser2 : collection) {
            object3 = new HashMap<String, Object>();
            object3.put("object", applicationUser2);
            object2 = IssueUtil.getTotalIssueTime(issueArray, applicationUser2);
            l3 = object2[0];
            l2 = map2.get(applicationUser2.getName());
            l = object2[1];
            if (l2 == null) {
                l2 = 0L;
            }
            double d = 0.0;
            if (longArray[1] != 0L) {
                d = (double)l2.longValue() / (double)longArray[1].longValue();
            }
            object3.put("estimated", this.number.format((double)l3.longValue() / 3600.0));
            object3.put("timespent", this.number.format((double)l2.longValue() / 3600.0));
            object3.put("remaining", this.number.format((double)l.longValue() / 3600.0));
            object3.put("percent", this.percentage.format(d));
            object3.put("expected", this.number.format((double)(l2 + l) / 3600.0));
            object3.put("estimatedDeviation", this.number.format((double)(l3 - l2) / 3600.0));
            URI uRI = avatarService.getAvatarUrlNoPermCheck(applicationUser2.getName(), Avatar.Size.MEDIUM);
            object3.put("avatar", uRI);
            if (l2 == 0L && l3 == 0L && l == 0L) continue;
            arrayList.add(object3);
            LOG.debug((Object)("User " + applicationUser2.getName() + " - Estimated/timespent/remaining: " + l3 + "/" + l2 + "/" + l));
            l5 = l5 - l2;
            l4 = l4 - l3;
            l6 = l6 - l;
        }
        l7 = l5 + l4;
        double d = 0.0;
        if (longArray[1] != 0L) {
            d = (double)l5.longValue() / (double)longArray[1].longValue();
        }
        LOG.debug((Object)(" Unknown user - Estimated/timespent/remaining: " + l4 + "/" + l5 + "/" + l6));
        LOG.debug((Object)("              - Expected: " + l7));
        if (l5 != 0L || l4 != 0L || l6 != 0L) {
            object3 = new HashMap();
            object3.put("estimated", this.number.format((double)l4.longValue() / 3600.0));
            object3.put("timespent", this.number.format((double)l5.longValue() / 3600.0));
            object3.put("remaining", this.number.format((double)l6.longValue() / 3600.0));
            object3.put("percent", this.percentage.format(d));
            object3.put("expected", this.number.format((double)l7.longValue() / 3600.0));
            object3.put("estimatedDeviation", this.number.format((double)(l4 - l5) / 3600.0));
            hashMap.put("unknownUser", object3);
        }
        LOG.debug((Object)"Now we have to order the user objects...");
        Collections.sort(arrayList, new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map<String, Object> map, Map<String, Object> map2) {
                String string = (String)map.get("percent");
                String string2 = (String)map2.get("percent");
                int n = Integer.parseInt(string.substring(0, string.indexOf(37)));
                int n2 = Integer.parseInt(string2.substring(0, string2.indexOf(37)));
                int n3 = n2 - n;
                LOG.trace((Object)("Comparing users: " + ((ApplicationUser)map.get("object")).getName() + " (" + n + ") - " + ((ApplicationUser)map2.get("object")).getName() + "(" + n2 + ") = comparison = " + n3));
                return n2 - n;
            }
        });
        LOG.debug((Object)"User objects ordered.");
        hashMap.put("users", arrayList);
        LOG.debug((Object)"Generating versions information...");
        object3 = VersionUtil.generateVersionObjects(map3, issueArray, longArray[1], project);
        LOG.debug((Object)("Number of versions: " + object3.size()));
        LOG.debug((Object)"Generating no version information...");
        object2 = VersionUtil.generateUnknowVersionObject((List<Map<String, Object>>)object3, issueArray);
        object3.remove(object2);
        LOG.debug((Object)"Done.");
        hashMap.put("versions", object3);
        hashMap.put("unknownVersion", object2);
        LOG.debug((Object)"Generating releases/unreleases time spent information...");
        l3 = VersionUtil.getTotalTimespentForVersions((List<Map<String, Object>>)object3, true);
        l2 = VersionUtil.getTotalTimespentForVersions((List<Map<String, Object>>)object3, false);
        l = VersionUtil.getTotalTimespentForArchivedVersions((List<Map<String, Object>>)object3);
        Long l8 = VersionUtil.getTotalTimespentForVersion((Map<String, Object>)object2);
        LOG.debug((Object)("Number of versions: " + object3.size()));
        hashMap.put("totalReleasedTimespent", this.number.format(l3));
        hashMap.put("totalUnreleasedTimespent", this.number.format(l2));
        hashMap.put("totalArchivedTimespent", this.number.format(l));
        hashMap.put("totalNoVersionTimespent", this.number.format(l8));
        int n = ComponentAccessor.getVersionManager().getVersionsReleased(project.getId(), false).size();
        int n2 = ComponentAccessor.getVersionManager().getVersionsUnreleased(project.getId(), false).size();
        int n3 = ComponentAccessor.getVersionManager().getVersionsArchived(project).size();
        int n4 = n + n2 + n3;
        hashMap.put("releasedVersionsNumber", n);
        hashMap.put("unreleasedVersionsNumber", n2);
        hashMap.put("archivedVersionsNumber", n3);
        hashMap.put("allVersionsNumber", n4);
        LOG.debug((Object)"Generating components information...");
        List<Map<String, Object>> list = ComponentUtil.generateComponentObjects(this.pluginSettingsFactory, map4, issueArray, longArray[1], project);
        LOG.debug((Object)("Number of components: " + list.size()));
        LOG.debug((Object)"Generating no component information...");
        Map<String, Object> map7 = ComponentUtil.generateUnknowComponentObject(list);
        list.remove(map7);
        LOG.debug((Object)"Done.");
        hashMap.put("components", list);
        hashMap.put("unknownComponent", map7);
        LOG.debug((Object)"Generating total component time spent information...");
        Long l9 = ComponentUtil.getTotalTimespentForComponents(list);
        Long l10 = ComponentUtil.getTotalTimespentForComponent(map7);
        hashMap.put("totalComponentsTimespent", this.number.format(l9));
        hashMap.put("totalNoComponentTimespent", this.number.format(l10));
        LOG.debug((Object)"Generating issue types information...");
        List<Map<String, Object>> list2 = IssueTypeUtil.generateIssueTypesObjects(map5, issueArray, longArray[1], project, this.issueTypeManager);
        LOG.debug((Object)("Number of issueTypes: " + list2.size()));
        hashMap.put("issueTypes", list2);
        LOG.debug((Object)"Generating total issue type time spent information...");
        Long l11 = IssueTypeUtil.getTotalTimespentForIssueTypes(list2);
        hashMap.put("totalIssueTypesTimespent", this.number.format(l11));
        hashMap.put("totalIssueTypesTimespentNumber", l11);
        if (string4 != null && !"none".equals(string4)) {
            LOG.debug((Object)"Generating additional field information...");
            object = FieldUtil.generateFieldValuesObjects(map6, issueArray, longArray[1], string4);
            LOG.debug((Object)("Number of additional field values: " + object.size()));
            Field field = ComponentAccessor.getFieldManager().getField(string4);
            if (field != null) {
                hashMap.put("additionalFieldName", field.getName());
            }
            hashMap.put("additionalFields", object);
        }
        object = avatarService.getAvatarUrlNoPermCheck(project.getProjectLead().getName(), Avatar.Size.MEDIUM);
        hashMap.put("avatarLead", object);
        return hashMap;
    }
}

