/*
 * Decompiled with CFR 0.152.
 */
package es.excentia.jira.plugins.stats.tab;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.bc.EntityNotFoundException;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.plugin.webfragment.contextproviders.AbstractJiraContextProvider;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import es.excentia.jira.plugins.stats.util.FormatUtils;
import es.excentia.jira.plugins.stats.util.IssueUtil;
import java.net.URI;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;

public class IssuePanel
extends AbstractJiraContextProvider {
    private final transient PluginLicenseManager licenseManager;
    private static final Logger LOG = Logger.getLogger(IssuePanel.class);
    private transient NumberFormat percentage;
    private transient NumberFormat number;

    public IssuePanel(PluginLicenseManager pluginLicenseManager, PluginSettingsFactory pluginSettingsFactory) {
        this.licenseManager = pluginLicenseManager;
        Locale locale = ComponentAccessor.getJiraAuthenticationContext().getLocale();
        this.number = NumberFormat.getNumberInstance(locale);
        this.percentage = NumberFormat.getPercentInstance(locale);
        this.number.setMaximumFractionDigits(0);
    }

    public Map<String, Object> getContextMap(ApplicationUser applicationUser, JiraHelper jiraHelper) {
        Issue issue = (Issue)jiraHelper.getContextParams().get("issue");
        return this.createVelocityParams(issue);
    }

    public Map<String, Object> createVelocityParams(Issue issue) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Map<Object, Object> map = new HashMap();
        String string = "";
        String string2 = "";
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        PluginLicense pluginLicense = null;
        if (this.licenseManager.getLicense().isDefined()) {
            pluginLicense = (PluginLicense)this.licenseManager.getLicense().get();
            LOG.debug((Object)("Plugin license found. Description: " + pluginLicense.getDescription()));
            bl = true;
            bl4 = pluginLicense.isEvaluation();
            bl5 = pluginLicense.isMaintenanceExpired();
            if (pluginLicense.getError().isDefined()) {
                string2 = ((LicenseError)pluginLicense.getError().get()).name();
                LOG.debug((Object)("Plugin license error: " + string2));
                bl3 = true;
            } else {
                LOG.debug((Object)"Plugin license is valid. ");
                bl2 = true;
                try {
                    map = this.generateReportObjects(issue);
                }
                catch (EntityNotFoundException | SearchException | NullPointerException | GenericEntityException throwable) {
                    string = throwable.getMessage();
                    LOG.debug((Object)("ERROR during plugin execution: " + string));
                    LOG.debug((Object)throwable);
                }
                hashMap.put("issue", map);
                hashMap.put("errorMessage", string);
            }
        } else {
            LOG.debug((Object)"Plugin unlicensed. ");
        }
        LOG.debug((Object)("Plugin license info: Licensed (" + bl + "), Valid (" + bl2 + "), Error (" + bl3 + "), Evaluation (" + bl4 + "), Expired (" + bl5 + ")"));
        hashMap.put("licensed", bl);
        hashMap.put("licenseHasError", bl3);
        hashMap.put("licenseIsValid", bl2);
        hashMap.put("licenseError", string2);
        hashMap.put("pluginLicense", pluginLicense);
        return hashMap;
    }

    public final Map<String, Object> generateReportObjects(Issue issue) throws SearchException, GenericEntityException, EntityNotFoundException {
        HashMap<String, Object> hashMap;
        LOG.debug((Object)("Generating report for issue " + issue.getKey()));
        Locale locale = ComponentAccessor.getJiraAuthenticationContext().getLocale();
        this.number = FormatUtils.getNumber();
        this.percentage = FormatUtils.getPercentage();
        Collection collection = ComponentAccessor.getUserManager().getAllApplicationUsers();
        Calendar calendar = Calendar.getInstance();
        Date date = calendar.getTime();
        calendar.set(2000, 1, 1);
        Date date2 = calendar.getTime();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        hashMap2.put("object", issue);
        AvatarService avatarService = ComponentAccessor.getAvatarService();
        Issue[] issueArray = new Issue[]{issue};
        Worklog[] worklogArray = IssueUtil.getIssuesWorklogs(issueArray, ComponentAccessor.getWorklogManager());
        LOG.debug((Object)("Number of issues: " + issueArray.length));
        hashMap2.put("totalissues", issueArray.length);
        Long[] longArray = IssueUtil.getTotalIssueTime(issueArray);
        ArrayList arrayList = new ArrayList();
        Long l = longArray[1];
        Map<String, Map<String, Long>> map = IssueUtil.getTimespentFromWorklogs(worklogArray, date2, date, ComponentAccessor.getUserManager(), null);
        Map<String, Long> map2 = map.get("users");
        for (Map.Entry<String, Long> applicationUser : map2.entrySet()) {
            LOG.debug((Object)(" User " + applicationUser.getKey() + " has worklogs on this issue with timespent = " + applicationUser.getValue()));
        }
        for (ApplicationUser applicationUser : collection) {
            hashMap = new HashMap<String, Object>();
            hashMap.put("object", applicationUser);
            Long[] longArray2 = IssueUtil.getTotalIssueTime(issueArray, applicationUser);
            Long l2 = longArray2[0];
            Long l3 = map2.get(applicationUser.getName());
            Long l4 = longArray2[1];
            if (l3 == null) {
                l3 = 0L;
            }
            double d = 0.0;
            if (longArray[1] != 0L) {
                d = (double)l3.longValue() / (double)longArray[1].longValue();
            }
            hashMap.put("timespent", ComponentAccessor.getJiraDurationUtils().getShortFormattedDuration(l3, locale));
            hashMap.put("percent", this.percentage.format(d));
            URI uRI = avatarService.getAvatarUrlNoPermCheck(applicationUser.getName(), Avatar.Size.MEDIUM);
            hashMap.put("avatar", uRI);
            if (l3 == 0L && l2 == 0L && l4 == 0L) continue;
            arrayList.add(hashMap);
            LOG.debug((Object)("User " + applicationUser.getName() + " - Estimated/timespent/remaining: " + l2 + "/" + l3 + "/" + l4));
            l = l - l3;
        }
        double d = 0.0;
        if (longArray[1] != 0L) {
            d = (double)l.longValue() / (double)longArray[1].longValue();
        }
        LOG.debug((Object)(" Unknown user - timespent: " + l));
        if (l != 0L) {
            hashMap = new HashMap();
            hashMap.put("timespent", ComponentAccessor.getJiraDurationUtils().getShortFormattedDuration(l, locale));
            hashMap.put("percent", this.percentage.format(d));
            hashMap2.put("unknownUser", hashMap);
        }
        LOG.debug((Object)"Now we have to order the user objects...");
        Collections.sort(arrayList, new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map<String, Object> map, Map<String, Object> map2) {
                String string = (String)map.get("percent");
                String string2 = (String)map2.get("percent");
                int n = 0;
                int n2 = 0;
                try {
                    n = Integer.parseInt(string.substring(0, string.indexOf(37)));
                    n2 = Integer.parseInt(string2.substring(0, string2.indexOf(37)));
                }
                catch (NumberFormatException numberFormatException) {
                    LOG.debug((Object)("Error ordering issues: (" + string + ") vs (" + string2 + ")"));
                    LOG.debug((Object)numberFormatException);
                }
                int n3 = n2 - n;
                LOG.trace((Object)("Comparing users: " + ((ApplicationUser)map.get("object")).getName() + " (" + n + ") - " + ((ApplicationUser)map2.get("object")).getName() + "(" + n2 + ") = comparison = " + n3));
                return n2 - n;
            }
        });
        LOG.debug((Object)"User objects ordered.");
        hashMap2.put("users", arrayList);
        return hashMap2;
    }
}

