/*
 * Decompiled with CFR 0.152.
 */
package es.excentia.jira.plugins.stats.admin;

import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import es.excentia.jira.plugins.stats.admin.ComponentConfigurationRepresentation;
import es.excentia.jira.plugins.stats.admin.ConfigurationRepresentation;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;

@Path(value="/time-tracking-stats")
@Produces(value={"application/json"})
public class TimeTrackingResource {
    private static final Logger LOG = Logger.getLogger(TimeTrackingResource.class);
    private final TransactionTemplate transactionTemplate;
    private final PluginSettingsFactory pluginSettingsFactory;

    public TimeTrackingResource(PluginSettingsFactory pluginSettingsFactory, TransactionTemplate transactionTemplate) {
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.transactionTemplate = transactionTemplate;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/project/{projectId}")
    public Response getResponseForProject(final @PathParam(value="projectId") String string) throws SearchException {
        LOG.info((Object)("User request for time-tracking-stats global configuration GET /project/" + string));
        return Response.ok((Object)this.transactionTemplate.execute(new TransactionCallback(){

            public Object doInTransaction() {
                PluginSettings pluginSettings = TimeTrackingResource.this.pluginSettingsFactory.createSettingsForKey(string);
                ConfigurationRepresentation configurationRepresentation = new ConfigurationRepresentation();
                String string3 = (String)pluginSettings.get(ConfigurationRepresentation.class.getName() + ".hours");
                String string2 = (String)pluginSettings.get(ConfigurationRepresentation.class.getName() + ".field");
                if (string3 != null) {
                    configurationRepresentation.setHours(Integer.parseInt(string3));
                }
                if (string2 != null) {
                    configurationRepresentation.setField(string2);
                }
                return configurationRepresentation;
            }
        })).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Path(value="/project/{projectId}")
    public Response put(final ConfigurationRepresentation configurationRepresentation, final @PathParam(value="projectId") String string) {
        LOG.info((Object)("User request for time-tracking-stats global configuration PUT /project/" + string));
        this.transactionTemplate.execute(new TransactionCallback(){

            public Object doInTransaction() {
                PluginSettings pluginSettings = TimeTrackingResource.this.pluginSettingsFactory.createSettingsForKey(string);
                pluginSettings.put(ConfigurationRepresentation.class.getName() + ".hours", (Object)Integer.toString(configurationRepresentation.getHours()));
                pluginSettings.put(ConfigurationRepresentation.class.getName() + ".field", (Object)configurationRepresentation.getField());
                return null;
            }
        });
        return Response.noContent().build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/project/{projectId}/{componentId}")
    public Response getResponseForComponent(final @PathParam(value="projectId") String string, final @PathParam(value="componentId") long l) {
        LOG.info((Object)("User request for time-tracking-stats component configuration GET /project/" + string + "/" + l));
        return Response.ok((Object)this.transactionTemplate.execute(new TransactionCallback(){

            public Object doInTransaction() {
                String string3;
                PluginSettings pluginSettings = TimeTrackingResource.this.pluginSettingsFactory.createSettingsForKey(string + "-" + l);
                ComponentConfigurationRepresentation componentConfigurationRepresentation = new ComponentConfigurationRepresentation();
                String string2 = (String)pluginSettings.get(ComponentConfigurationRepresentation.class.getName() + ".componentId");
                if (string2 != null) {
                    componentConfigurationRepresentation.setComponentId(Long.parseLong(string2));
                }
                if ((string3 = (String)pluginSettings.get(ComponentConfigurationRepresentation.class.getName() + ".hours")) != null) {
                    componentConfigurationRepresentation.setHours(Integer.parseInt(string3));
                }
                return componentConfigurationRepresentation;
            }
        })).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Path(value="/project/{projectId}/{componentId}")
    public Response putResponseForComponent(final ComponentConfigurationRepresentation componentConfigurationRepresentation, final @PathParam(value="projectId") String string, final @PathParam(value="componentId") long l) {
        LOG.info((Object)("User request for time-tracking-stats component configuration PUT /project/" + string + "/" + l));
        this.transactionTemplate.execute(new TransactionCallback(){

            public Object doInTransaction() {
                PluginSettings pluginSettings = TimeTrackingResource.this.pluginSettingsFactory.createSettingsForKey(string + "-" + l);
                pluginSettings.put(ComponentConfigurationRepresentation.class.getName() + ".componentId", (Object)Long.toString(componentConfigurationRepresentation.getComponentId()));
                pluginSettings.put(ComponentConfigurationRepresentation.class.getName() + ".hours", (Object)Integer.toString(componentConfigurationRepresentation.getHours()));
                return null;
            }
        });
        return Response.noContent().build();
    }
}

