/*
 * Decompiled with CFR 0.152.
 */
package es.excentia.jira.plugins.stats.admin;

import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponentManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.fields.FieldException;
import com.atlassian.jira.issue.fields.NavigableField;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class ProjectConfigServlet
extends HttpServlet {
    private static final long serialVersionUID = -7950640411169509010L;
    private static final Logger LOG = Logger.getLogger(ProjectConfigServlet.class);
    private final transient TemplateRenderer renderer;

    public ProjectConfigServlet(TemplateRenderer templateRenderer) {
        this.renderer = templateRenderer;
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String string = httpServletRequest.getParameter("projectKey");
        if (!this.userIsProjectAdmin(string)) {
            this.redirectToPrevious(httpServletRequest, httpServletResponse);
            return;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Project project = ComponentAccessor.getProjectManager().getProjectObjByKey(string);
        Long l = project.getId();
        hashMap.put("project", project);
        hashMap.put("projectId", l);
        hashMap.put("fields", this.getCustomFields(string));
        hashMap.put("components", this.getComponents(string));
        httpServletResponse.setContentType("text/html;charset=utf-8");
        this.renderer.render("templates/project-admin.vm", hashMap, (Writer)httpServletResponse.getWriter());
    }

    private void redirectToPrevious(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        httpServletResponse.sendRedirect(httpServletRequest.getHeader("referer"));
    }

    private boolean userIsProjectAdmin(String string) {
        if (string == null) {
            return false;
        }
        ApplicationUser applicationUser = ComponentAccessor.getJiraAuthenticationContext().getLoggedInUser();
        Project project = ComponentAccessor.getProjectManager().getProjectObjByKey(string);
        PermissionManager permissionManager = (PermissionManager)ComponentAccessor.getComponent(PermissionManager.class);
        return permissionManager.hasPermission(ProjectPermissions.ADMINISTER_PROJECTS, project, applicationUser);
    }

    private Map<String, String> getCustomFields(String string) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        if (string != null) {
            Collection collection;
            Project project = ComponentAccessor.getProjectManager().getProjectObjByKey(string);
            try {
                collection = ComponentAccessor.getFieldManager().getAllAvailableNavigableFields();
                if (collection != null) {
                    for (NavigableField navigableField : collection) {
                        String string2 = navigableField.getNameKey();
                        if (!"issue.field.resolution".equals(string2) && !"issue.field.creator".equals(string2) && !"issue.field.reporter".equals(string2) && !"issue.field.priority".equals(string2) && !"issue.field.environment".equals(string2)) continue;
                        treeMap.put(navigableField.getId(), navigableField.getName());
                    }
                }
            }
            catch (FieldException fieldException) {
                LOG.warn((Object)("Error while reading navigable fields: " + fieldException.getLocalizedMessage()), (Throwable)fieldException);
            }
            collection = ComponentAccessor.getCustomFieldManager().getCustomFieldObjects(project.getId(), new ArrayList());
            for (NavigableField navigableField : collection) {
                treeMap.put(navigableField.getId(), navigableField.getName());
            }
        }
        return treeMap;
    }

    private Map<Long, String> getComponents(String string) {
        TreeMap<Long, String> treeMap = new TreeMap<Long, String>();
        ProjectComponentManager projectComponentManager = ComponentAccessor.getProjectComponentManager();
        if (string != null) {
            Project project = ComponentAccessor.getProjectManager().getProjectObjByKey(string);
            Collection collection = projectComponentManager.findAllForProject(project.getId());
            for (ProjectComponent projectComponent : collection) {
                LOG.debug((Object)("component: " + projectComponent.getName()));
                treeMap.put(projectComponent.getId(), projectComponent.getName());
            }
        }
        return treeMap;
    }
}

