var aptis = aptis || {};
aptis.plugins = aptis.plugins || {};
aptis.plugins.shareYourJira = aptis.plugins.shareYourJira || {};

aptis.plugins.shareYourJira.deleteIssueShareClickHandler = function(e, element) {
	e.preventDefault();

    var id = AJS.$(element).data('issue-share-id');
    if (id === null || id === undefined || id === "") {
        return;
    }

    var shareItemRowDomId = AJS.$(element).data('share-item-row');
    if (shareItemRowDomId === null || shareItemRowDomId === undefined || shareItemRowDomId === "") {
        return;
    }

    if (window.confirm(AJS.I18n.getText('aptis-sjy-delete-share-question'))) {
        AJS.$.ajax({
            url: AJS.params.baseURL + '/rest/aptis/plugins/shareYourJira/issue/1.0/issueShareLink',
            type: 'DELETE',
            contentType: 'application/json',
            data: JSON.stringify({
                id: id
            })
        });

        //Hide the row element
        AJS.$('#' + shareItemRowDomId).hide();
    }
};

aptis.plugins.shareYourJira.deleteFilterShareClickHandler = function(e, element) {
    e.preventDefault();

    var filterShareId = AJS.$(element).data('filter-share-id');
    if (filterShareId === null || filterShareId === undefined || filterShareId === "") {
        return;
    }

    var shareItemRowDomId = AJS.$(element).data('share-item-row');
    if (shareItemRowDomId === null || shareItemRowDomId === undefined || shareItemRowDomId === "") {
        return;
    }

    if (window.confirm(AJS.I18n.getText('aptis-sjy-delete-share-question'))) {
        AJS.$.ajax({
            url: AJS.params.baseURL + '/rest/aptis/plugins/shareYourJira/filter/1.0/filterShareLink',
            type: 'DELETE',
            contentType: 'application/json',
            data: JSON.stringify({
                filterShareId: filterShareId
            })
        });

        //Hide the row element
        AJS.$('#' + shareItemRowDomId).hide();
    }
};

aptis.plugins.shareYourJira.activateIssueShareClickHandler = function(e, element) {
    e.preventDefault();

    var id = AJS.$(element).data('issue-share-id');
    if (id === null || id === undefined || id === "") {
        return;
    }

    var shareItemRowDomId = AJS.$(element).data('share-item-row');
    if (shareItemRowDomId === null || shareItemRowDomId === undefined || shareItemRowDomId === "") {
        return;
    }

    AJS.$.ajax({
        url: AJS.params.baseURL + '/rest/aptis/plugins/shareYourJira/issue/1.0/issueShareLink/activeStatus',
        type: 'PUT',
        contentType: 'application/json',
        data: JSON.stringify({
            id: id,
            active: true
        })
    });

    //Activate the row
    AJS.$('#' + shareItemRowDomId).removeClass('inactive');
};

aptis.plugins.shareYourJira.activateFilterShareClickHandler = function(e, element) {
    e.preventDefault();

    var filterShareId = AJS.$(element).data('filter-share-id');
    if (filterShareId === null || filterShareId === undefined || filterShareId === "") {
        return;
    }

    var shareItemRowDomId = AJS.$(element).data('share-item-row');
    if (shareItemRowDomId === null || shareItemRowDomId === undefined || shareItemRowDomId === "") {
        return;
    }

    AJS.$.ajax({
        url: AJS.params.baseURL + '/rest/aptis/plugins/shareYourJira/filter/1.0/filterShareLink/activeStatus',
        type: 'PUT',
        contentType: 'application/json',
        data: JSON.stringify({
            filterShareId: filterShareId,
            active: true
        })
    });

    //Activate the row
    AJS.$('#' + shareItemRowDomId).removeClass('inactive');
};

aptis.plugins.shareYourJira.inactivateIssueShareClickHandler = function(e, element) {
    e.preventDefault();

    var id = AJS.$(element).data('issue-share-id');
    if (id === null || id === undefined || id === "") {
        return;
    }

    var shareItemRowDomId = AJS.$(element).data('share-item-row');
    if (shareItemRowDomId === null || shareItemRowDomId === undefined || shareItemRowDomId === "") {
        return;
    }

    AJS.$.ajax({
        url: AJS.params.baseURL + '/rest/aptis/plugins/shareYourJira/issue/1.0/issueShareLink/activeStatus',
        type: 'PUT',
        contentType: 'application/json',
        data: JSON.stringify({
            id: id,
            active: false
        })
    });

    //Deactivate the row
    AJS.$('#' + shareItemRowDomId).addClass('inactive');
};

aptis.plugins.shareYourJira.inactivateFilterShareClickHandler = function(e, element) {
    e.preventDefault();

    var filterShareId = AJS.$(element).data('filter-share-id');
    if (filterShareId === null || filterShareId === undefined || filterShareId === "") {
        return;
    }

    var shareItemRowDomId = AJS.$(element).data('share-item-row');
    if (shareItemRowDomId === null || shareItemRowDomId === undefined || shareItemRowDomId === "") {
        return;
    }

    AJS.$.ajax({
        url: AJS.params.baseURL + '/rest/aptis/plugins/shareYourJira/filter/1.0/filterShareLink/activeStatus',
        type: 'PUT',
        contentType: 'application/json',
        data: JSON.stringify({
            filterShareId: filterShareId,
            active: false
        })
    });

    //Deactivate the row
    AJS.$('#' + shareItemRowDomId).addClass('inactive');
};

if (JIRA.ViewIssueTabs) {
    JIRA.ViewIssueTabs.onTabReady(function() {
        AJS.$('a.delete-share[data-issue-share-id]').unbind('click');
        AJS.$('a.delete-share[data-issue-share-id]').click(function(e) {
            return aptis.plugins.shareYourJira.deleteIssueShareClickHandler(e, this);
        });
    });
}

AJS.toInit(function () {
    AJS.$('body').on('click', '#aptis-sjy-create-issue-share-link', function (event) {
        event.preventDefault();
    });
});
