var aptis = aptis || {};
aptis.plugins = aptis.plugins || {};
aptis.plugins.shareYourJira = aptis.plugins.shareYourJira || {};
aptis.plugins.shareYourJira.shareTemplateController = aptis.plugins.shareYourJira.shareTemplateController || {};

aptis.plugins.shareYourJira.ShareIssueLinkFormController = {

	/**
	 * {String}
	 */
	_formElement: null,

	/**
	 * {Boolean}
	 */
	_startsInDialog: false,

	/**
	 * @var {Null|aptis.plugins.shareYourJira.JetiEmailHandler}
	 */
	_jetiEmailHandler: null,

	/**
	 * @var {Null|aptis.plugins.shareYourJira.PasswordFormHelper}
	 */
	_passwordFormHelper: null,

	/**
	 * @var {Null|aptis.plugins.shareYourJira.IssueQuery}
	 */
	_issueQuery: null,

	initController: function () {
		var me = this;

		me._formElement = AJS.$('#aptis-sjy-share-link form');
		me._startsInDialog = AJS.$('#aptis-sjy-share-link').parents('.jira-dialog').length > 0;

		me._initUserNameOrEmail();
		me._initSelect2Sortable();
		me._initSelect2Placeholder();

		//Wenn nicht im Dialog gestartet wird, dann muss der Cancel überschrieben werden
		if (!me._startsInDialog) {
			me._formElement.find('.aui-button.cancel').on('click', function () {
				window.history.back();
			});
		}

		if (me._extendedSettingsExist()) {
			AJS.$('#aptis-sjy-share-link .extended-issue-settings-link').hide();
		} else {
			AJS.$('#aptis-sjy-share-link .extended-settings-container').hide();
		}

		me._submitIssueShareForm();
		me._templateClickHandler();
		me._formCheckBoxToggle();
		me._getPasswordFormHelper().initPasswordChangeField(me._formElement);
	},

	/**
	 * @return {Boolean}
	 * @private
	 */
	_extendedSettingsExist: function() {
		var me = this;
		var commentVisibility = me._formElement.find('extended-settings-container:visible select[name="commentVisibility"]').val() || [];
		var attachmentVisibility = me._formElement.find('.extended-settings-container:visible select[name="attachmentVisibility"]').val() || [];
		var checkedElements = me._formElement.find('.extended-settings-container input:checked') || [];

		return commentVisibility.length > 0 || attachmentVisibility.length > 0 || checkedElements.length > 0;
	},

	_initUserNameOrEmail: function() {
		var me = this;
		me._formElement.find('input[name=usernameOrEmail]').auiSelect2({
			multiple: true,
			minimumInputLength: 1,
			ajax: {
				url: AJS.params.baseURL + '/rest/aptis/plugins/shareYourJira/common/1.0/userPicker',
				type: "GET",
				dataType: 'json',
				cache: false,
				data: function data(term) {
					return {
						searchText: term
					};
				},
				results: function results(data) {
					return {
						results: data
					};
				}
			},
			id: function id(user) {
				return user.email;
			},
			formatSelection: function formatSelection(user) {
				return user.formatSelection;
			},
			formatResult: function formatResult(user, container, query, escapeMarkup) {
				return user.formatResult;
			},
			formatNoMatches: function formatNoMatches(query) {
				return AJS.I18n.getText('jira-share-plugin.dialog.autocomplete.noresults');
			},
			formatInputTooShort: function () {
				return AJS.I18n.getText('aptis-syj-enter-username-or-email');
			}
		});

		me._formElement.find('input[name=usernameOrEmail]').change(function() {
			var value = AJS.$(this).val();
			if (value && value.length > 0) {
				me._formElement.find('button.submit').html(AJS.I18n.getText("jira-share-plugin.dialog.form.share"));
			} else {
				me._formElement.find('button.submit').html(AJS.I18n.getText("common.words.create"));
			}
		});
	},

	_initSelect2Sortable: function() {
		var me = this;
		me._formElement.find('.sortedFields').select2Sortable(AJS.$('select.sortedFields').data('order').split(','));
		me._formElement.find('.sortedAttachments').select2Sortable();
		me._formElement.find('.sortedComments').select2Sortable();
	},

	_templateClickHandler: function() {
		var me = this;
		me._formElement.find('.loadTemplateButton').on('click', loadShareTemplate);
		me._formElement.find('.deleteTemplateButton').on('click', deleteShareTemplate);
		me._formElement.find('#createTemplateButton').on('click', createShareTemplate);
	},

	_submitIssueShareForm: function() {
		var me = this;
		me._formElement.find('.aui-button.submit[name="issueShare"]').off('click');
		me._formElement.find('.aui-button.submit[name="issueShare"]').on('click', function (event) {
			event.preventDefault();

			var data = {
				issueId: me._formElement.find('input[name="issueId"]').val()
			};

			var displayingFields = AJS.$('select[name="displayingFields"]').val();
			if (displayingFields) {
				data['displayingFields'] = displayingFields;
			}

			var id = parseInt(me._formElement.find('input[name="id"]').val(), 10);
			var isNewIssueShare = id == 0;
			if (!isNewIssueShare) {
				data['id'] = id;
			}

			if (me._formElement.find('.extended-settings-container:visible input[name="validPeriodFromCheckbox"]').prop('checked')) {
				var validPeriodFrom = me._formElement.find('input[name="validPeriodFrom"]').val();
				if (validPeriodFrom && validPeriodFrom != "") {
					data['validPeriodFrom'] = validPeriodFrom;
				}
			}

			if (me._formElement.find('.extended-settings-container:visible input[name="validPeriodToCheckbox"]').prop('checked')) {
				var validPeriodTo = me._formElement.find('input[name="validPeriodTo"]').val();
				if (validPeriodTo && validPeriodTo != "") {
					data['validPeriodTo'] = validPeriodTo;
				}
			}

			if (me._formElement.find('.extended-settings-container:visible input[name="setPassword"]').prop('checked')) {
				var password = me._formElement.find('input[name="password"]').val();
				if (password && password != "") {
					data['password'] = password;
				}
			}

			if (me._formElement.find('.extended-settings-container:visible input[name="ipsLockCheckbox"]').prop('checked')) {
				var ipsLock = me._formElement.find('input[name="ipsLock"]').val();
				if (ipsLock && ipsLock != "") {
					data['ipsLock'] = ipsLock;
				}
			}

			var note = me._formElement.find('input[name="note"]').val();
			if (note && note != "") {
				data['note'] = note;
			}

			var onlyLoggedInUserChanged = false;
			me._formElement.find('input[name="onlyLoggedInUser"]').live('change', function () {
				onlyLoggedInUserChanged = true;
			});

			var onlyLoggedInUser = me._formElement.find('.extended-settings-container:visible input[name="onlyLoggedInUser"]').prop('checked');
			if (onlyLoggedInUserChanged || onlyLoggedInUser === true) {
				data['onlyLoggedInUser'] = onlyLoggedInUser;
			}

			data['commentVisibility'] = AJS.$('select[name="commentVisibility"]').val();
			data['attachmentVisibility'] = AJS.$('select[name="attachmentVisibility"]').val();

			var eMailAddresses = me._formElement.find('input[name=usernameOrEmail]').auiSelect2('val');
			var sendViaEMail = false;
			if (eMailAddresses && eMailAddresses.length > 0) {
				data['eMailAddresses'] = eMailAddresses;
				sendViaEMail = true;
			} else {
				data['eMailAddresses'] = [];
			}

			var eMailNote = me._formElement.find('textarea[name=eMailNote]').val();
			if (eMailNote && eMailNote != "") {
				data['eMailNote'] = eMailNote;
			}

			AJS.$.ajax({
				url: AJS.params.baseURL + '/rest/aptis/plugins/shareYourJira/issue/1.0/issueShareLink',
				type: id == 0 ? 'POST' : 'PUT',
				contentType: 'application/json',
				cache: false,
				processData: false,
				data: JSON.stringify(data),
				success: function (responseData) {
					if (responseData.issueShareUrl) {
						if (responseData.sendUsingJeti) {
							me._getIssueQuery().querySingleIssue(data.issueId, function(issue) {
								var subject = me._getMailSubject(AJS.Meta.get('remote-user-fullname'), issue.key, issue.fields.summary);
								var additionalLinkBody = "<a href=\"" + encodeURI(responseData.issueShareUrl) + "\">" + AJS.$('<div/>').text(issue.fields.summary).html() + "</a><br /><br />";
								var body = additionalLinkBody + data.eMailNote.replace(/(?:\r\n|\r|\n)/g, '<br />');

								me._getJetiEmailHandler().sendMail(issue, data.eMailAddresses, subject, body, responseData.jetiEmailTemplate, function(data) {
									me._handleSuccess(data.issueShareUrl, isNewIssueShare, sendViaEMail);
								})
							});
						} else {
							me._handleSuccess(responseData.issueShareUrl, isNewIssueShare, sendViaEMail);
						}
					}
				},
				error: function (jqXHR, textStatus, errorThrown) {
					if (jqXHR.responseText) {
						me._getJetiEmailHandler().handleError(jqXHR.responseText);
					} else {
						me._getJetiEmailHandler().handleError(errorThrown);
					}
				}
			});
		});
	},

	/**
	 * @param {String} shareUrl
	 * @param {Boolean} isNewIssueShare
	 * @param {Boolean} sendViaEMail
	 */
	_handleSuccess: function (shareUrl, isNewIssueShare, sendViaEMail) {
		var me = this;
		if (!me._startsInDialog && !isNewIssueShare && !sendViaEMail) {
			window.location.href = AJS.params.baseURL + '/plugins/servlet/shareYourJira/shareManagement';
			return;
		}

		if (me._startsInDialog && !isNewIssueShare && !sendViaEMail) {
			AJS.$('body').trigger({type: 'keydown', which: 27});
			me._renderNotification('success', AJS.I18n.getText('aptis-sjy-successfully-saved'));
			return;
		}

		if (sendViaEMail) {
			if (me._startsInDialog) {
				AJS.$('body').trigger({type: 'keydown', which: 27});
			}

			me._renderNotification('success', AJS.I18n.getText('aptis-syj-successfully-shared'));

			if (!me._startsInDialog){
				window.location.href = AJS.params.baseURL + '/plugins/servlet/shareYourJira/shareManagement';
			}
			return;
		}

		var html = '' +
			'<form class="aui" action="#">' +
			'	<div class="form-body">' +
			'		<p><label>' + AJS.I18n.getText("aptis-sjy-share-link-description") + '</label></p>' +
			'		<p><input onclick="this.select();" class="permalink text full-width-field" value="' + encodeURI(shareUrl) + '" readonly></p>' +
			'	</div>' +
			'	<div class="buttons-container">' +
			'		<div class="buttons">' +
			'			<a class="aui-button aui-button-primary" href="mailto:?body=' + encodeURIComponent(shareUrl) + '"><span class="aui-icon aui-icon-small aui-iconfont-email"></span>&nbsp;' + AJS.I18n.getText("aptis-sjy-mail-to") + '</a>' +
			'			<a class="aui-button aui-button" href="' + AJS.params.baseURL + '/plugins/servlet/shareYourJira/shareManagement">' + AJS.I18n.getText("aptis-syj-share-management-button") + '</a>' +
			'			<a class="aui-button aui-button-link cancel">' + AJS.I18n.getText('common.words.close') + '</a>' +
			'		</div>' +
			'	</div>' +
			'</form>'
		;
		AJS.$('#aptis-sjy-share-link form').html(html);

		AJS.$('#aptis-sjy-share-link form .aui-button.cancel').on('click', function () {
			if (me._startsInDialog) {
				AJS.$('body').trigger({type: 'keydown', which: 27});
			} else {
				window.history.back();
			}
		});
	},

	/**
	 * @param {String} userName
	 * @param {String} issueKey
	 * @param {String} issueSummary
	 * @returns {aptis.plugins.shareYourJira.local}
	 */
	_getMailSubject: function(userName, issueKey, issueSummary) {
		var subject = aptis.plugins.shareYourJira.locales['mailSubject'];
		subject = subject.replace("{0}", userName);
		subject = subject.replace("{1}", issueKey);
		subject = subject.replace("{2}", issueSummary);

		return subject;
	},

	/**
	 * @param {Object} event
	 * @private
	 */
	_extendedSettingsLinkClickHandler: function(event) {
		event.preventDefault();
		if (AJS.$('#aptis-sjy-share-link .extended-settings-container').is(':visible')) {
			AJS.$('#aptis-sjy-share-link .extended-settings-container').hide();
			AJS.$('#aptis-sjy-share-link .extended-issue-settings-link span').addClass("aui-iconfont-arrows-down");
			AJS.$('#aptis-sjy-share-link .extended-issue-settings-link span').removeClass("aui-iconfont-arrows-up");
		} else {
			AJS.$('#aptis-sjy-share-link .extended-settings-container').show();
			AJS.$('#aptis-sjy-share-link .extended-issue-settings-link span').addClass("aui-iconfont-arrows-up");
			AJS.$('#aptis-sjy-share-link .extended-issue-settings-link span').removeClass("aui-iconfont-arrows-down");
		}
	},

	_formCheckBoxToggle: function() {
		var me = this;
		AJS.$('#aptis-sjy-share-link .extended-issue-settings-link').off('click', me._extendedSettingsLinkClickHandler);
		AJS.$('#aptis-sjy-share-link .extended-issue-settings-link').on('click', me._extendedSettingsLinkClickHandler);

		me._formElement.find('input[name="validPeriodFrom"]').datePicker({'overrideBrowserDefault': true});
		me._formElement.find('input[name="validPeriodTo"]').datePicker({'overrideBrowserDefault': true});

		me._formElement.find('input[name="validPeriodFrom"]').live('change', function () {
			me._formElement.find('input[name="validPeriodFromCheckbox"]').prop('checked', true);
		});

		me._formElement.find('input[name="validPeriodTo"]').live('change', function () {
			me._formElement.find('input[name="validPeriodToCheckbox"]').prop('checked', true);
		});

		me._formElement.find('input[name="password"]').live('change', function () {
			me._formElement.find('input[name="setPassword"]').prop('checked', true);
		});

		me._formElement.find('input[name="password"]').live('click', function () {
			me._formElement.find('input[name="password"]').val('');
		});

		me._formElement.find('input[name="setPassword"]').change(function() {
			if (this.checked) {
				me._formElement.find('input[name="password"]').attr("disabled", false);
			} else {
				me._formElement.find('input[name="password"]').attr("disabled", true);
			}
		});

		me._formElement.find('input[name="ipsLock"]').live('change', function () {
			me._formElement.find('input[name="ipsLockCheckbox"]').prop('checked', true);
		});

		window.setTimeout(function() {
			me._formElement.find('input[name=usernameOrEmail]').auiSelect2('focus');
		}, 100);
	},

	/**
	 * @returns {aptis.plugins.common.ChangePasswordHandler}
	 * @private
	 */
	_getPasswordFormHelper: function() {
		if (!this._passwordFormHelper) {
			this._passwordFormHelper = aptis.plugins.shareYourJira.PasswordFormHelper;
		}
		return this._passwordFormHelper;
	},

	/**
	 * @returns {aptis.plugins.common.JetiEmailHandler}
	 * @private
	 */
	_getJetiEmailHandler: function() {
		if (!this._jetiEmailHandler) {
			this._jetiEmailHandler = aptis.plugins.shareYourJira.JetiEmailHandler;
		}
		return this._jetiEmailHandler;
	},

	/**
	 * @returns {aptis.plugins.common.IssueQuery}
	 * @private
	 */
	_getIssueQuery: function() {
		if (!this._issueQuery) {
			this._issueQuery = aptis.plugins.shareYourJira.IssueQuery;
		}
		return this._issueQuery;
	},

	_initSelect2Placeholder: function() {
		AJS.$('.aptis-sjy-add-field-button').on('click', function() {
			setTimeout(function () {
				AJS.$("select.sortedFields").select2({
					placeholder: AJS.I18n.getText("aptis-sjy-empty-field")
				});
			},10)
		});

		AJS.$('.aptis-sjy-add-attachment-button').on('click', function() {
			setTimeout(function () {
				AJS.$("select.sortedAttachments").select2({
					placeholder: AJS.I18n.getText("aptis-sjy-empty-attachment")
				});
			},10)
		});

		AJS.$('.aptis-sjy-add-comment-button').on('click', function() {
			setTimeout(function () {
				AJS.$("select.sortedComments").select2({
					placeholder: AJS.I18n.getText("aptis-sjy-empty-comment")
				});
			},10)
		});
	},

	/**
	 * @param {String} type
	 * @param {String} message
	 * @private
	 */
	_renderNotification: function (type, message) {
	    if (AJS.flags) {
			AJS.flag({
				type: type,
				title: message,
				close: 'auto'
			});
		} else {
			require('aui/flag')({
				type: type,
				title: message,
				close: 'auto'
			});
		}
	}
};