var aptis = aptis || {};
aptis.plugins = aptis.plugins || {};
aptis.plugins.shareYourJira = aptis.plugins.shareYourJira || {};

aptis.plugins.shareYourJira.ShareFilterLinkFormController = {

	/**
	 * {String}
	 */
	_formElement: null,

	/**
	 * @var {Null|aptis.plugins.shareYourJira.PasswordFormHelper}
	 */
	_passwordFormHelper: null,

	initController: function() {
		var me = this;
		me._formElement = AJS.$('#aptis-sjy-share-link form');

		me._initSelect2Sortable();
		me._initSelect2Placeholder();
		me._submitFilterShareForm();
		me._templateClickHandler();

		AJS.$('#aptis-sjy-share-link .extended-filter-settings-link').live('click', function(event) {
			event.preventDefault();
			if (AJS.$('#aptis-sjy-share-link .extended-settings-container').is(':visible')) {
				AJS.$('#aptis-sjy-share-link .extended-settings-container').hide();
				AJS.$('#aptis-sjy-share-link .extended-filter-settings-link span').addClass("aui-iconfont-arrows-down");
				AJS.$('#aptis-sjy-share-link .extended-filter-settings-link span').removeClass("aui-iconfont-arrows-up");
			} else {
				AJS.$('#aptis-sjy-share-link .extended-settings-container').show();
				AJS.$('#aptis-sjy-share-link .extended-filter-settings-link span').addClass("aui-iconfont-arrows-up");
				AJS.$('#aptis-sjy-share-link .extended-filter-settings-link span').removeClass("aui-iconfont-arrows-down");
			}
		});

		this._formCheckBoxToggle();
		this._getPasswordFormHelper().initPasswordChangeField(me._formElement);
	},

	_submitFilterShareForm: function() {
		var me = this;
		me._formElement.find('.aui-button.submit[name="filterShare"]').off('click');
		me._formElement.find('.aui-button.submit[name="filterShare"]').on('click', function (event) {
			event.preventDefault();

			var data = {
				filterId: me._formElement.find('input[name="filterId"]').val()
			};

			var displayingFields = AJS.$('select[name="displayingFields"]').val();
			if (displayingFields) {
				data['displayingFields'] = displayingFields;
			}

			var filterShareId = parseInt(me._formElement.find('input[name="filterShareId"]').val(), 10);
			var isNewFilterShare = filterShareId == 0;
			if (!isNewFilterShare) {
				data['filterShareId'] = filterShareId;
			}

			if (me._formElement.find('.extended-settings-container:visible input[name="validPeriodFromCheckbox"]').prop('checked')) {
				var validPeriodFrom = me._formElement.find('input[name="validPeriodFrom"]').val();
				if (validPeriodFrom && validPeriodFrom != "") {
					data['validPeriodFrom'] = validPeriodFrom;
				}
			}

			if (me._formElement.find('.extended-settings-container:visible input[name="validPeriodToCheckbox"]').prop('checked')) {
				var validPeriodTo = me._formElement.find('input[name="validPeriodTo"]').val();
				if (validPeriodTo && validPeriodTo != "") {
					data['validPeriodTo'] = validPeriodTo;
				}
			}

			if (me._formElement.find('.extended-settings-container:visible input[name="setPassword"]').prop('checked')) {
				var password = me._formElement.find('input[name="password"]').val();
				if (password && password != "") {
					data['password'] = password;
				}
			}

			if (me._formElement.find('.extended-settings-container:visible input[name="ipsLockCheckbox"]').prop('checked')) {
				var ipsLock = me._formElement.find('input[name="ipsLock"]').val();
				if (ipsLock && ipsLock != "") {
					data['ipsLock'] = ipsLock;
				}
			}

			var note = me._formElement.find('input[name="note"]').val();
			if (note && note != "") {
				data['note'] = note;
			}

			var onlyLoggedInUserChanged = false;
			me._formElement.find('input[name="onlyLoggedInUser"]').live('change', function() {
				onlyLoggedInUserChanged = true;
			});

			var onlyLoggedInUser = me._formElement.find('input[name="onlyLoggedInUser"]').prop('checked');
			if (onlyLoggedInUserChanged || onlyLoggedInUser === true) {
				data['onlyLoggedInUser'] = onlyLoggedInUser;
			}

			AJS.$.ajax({
				url: AJS.params.baseURL + '/rest/aptis/plugins/shareYourJira/filter/1.0/filterShareLink',
				type: filterShareId == 0 ? 'POST' : 'PUT',
				contentType: 'application/json',
				cache: false,
				processData: false,
				data: JSON.stringify(data),
				success: function(data) {
					if (data.filterShareId) {
						me.handleSuccess(data.filterShareId, isNewFilterShare);
					}
				},
				error: function(jqXHR, textStatus, errorThrown) {
					if (jqXHR.responseText) {
						me.handleError(jqXHR.responseText);
					} else {
						me.handleError(errorThrown);
					}
				}
			});
			return false;
		});
	},

	/**
	 * @param {String} filterShareId
	 * @param {Boolean} isNewFilterShare
	 */
	handleSuccess: function(filterShareId, isNewFilterShare) {
		if (isNewFilterShare) {
			window.location.href = AJS.params.baseURL + '/plugins/servlet/shareYourJira/showFilterShareLink?filterShareId=' + filterShareId;
		} else {
			window.location.href = AJS.params.baseURL + '/plugins/servlet/shareYourJira/shareManagement';
		}
	},

	/**
	 * @param {String} errorMessage
	 */
	handleError: function(errorMessage) {
		AJS.messages.error({
			body: errorMessage,
			fadeout: true
		});
	},

	_formCheckBoxToggle: function() {
		var me = this;

		if (me._formElement.find('.extended-settings-container input:checked').length > 0) {
			AJS.$('#aptis-sjy-share-link .extended-filter-settings-link').hide();
		} else {
			AJS.$('#aptis-sjy-share-link .extended-settings-container').hide();
		}

		me._formElement.find('input[name="validPeriodFrom"]').datePicker({'overrideBrowserDefault': true});
		me._formElement.find('input[name="validPeriodTo"]').datePicker({'overrideBrowserDefault': true});

		me._formElement.find('input[name="validPeriodFrom"]').live('change', function() {
			me._formElement.find('input[name="validPeriodFromCheckbox"]').prop('checked', true);
		});

		me._formElement.find('input[name="validPeriodTo"]').live('change', function() {
			me._formElement.find('input[name="validPeriodToCheckbox"]').prop('checked', true);
		});

		me._formElement.find('input[name="password"]').live('change', function() {
			me._formElement.find('input[name="setPassword"]').prop('checked', true);
		});

		me._formElement.find('input[name="password"]').live('click', function() {
			me._formElement.find('input[name="password"]').val('');
		});

		me._formElement.find('input[name="setPassword"]').change(function() {
			if (this.checked) {
				me._formElement.find('input[name="password"]').attr("disabled", false);
			} else {
				me._formElement.find('input[name="password"]').attr("disabled", true);
			}
		});

		me._formElement.find('input[name="ipsLock"]').live('change', function() {
			me._formElement.find('input[name="ipsLockCheckbox"]').prop('checked', true);
		});
	},

	_templateClickHandler: function() {
		var me = this;
		me._formElement.find('.loadTemplateButton').on('click', loadShareTemplate);
		me._formElement.find('.deleteTemplateButton').on('click', deleteShareTemplate);
		me._formElement.find('#createTemplateButton').on('click', createShareTemplate);
	},

	_initSelect2Sortable: function() {
		var me = this;
		me._formElement.find('.sortedFields').select2Sortable(AJS.$('select.sortedFields').data('order').split(','));
	},

	/**
	 * @returns {aptis.plugins.common.ChangePasswordHandler}
	 * @private
	 */
	_getPasswordFormHelper: function() {
		if (!this._passwordFormHelper) {
			this._passwordFormHelper = aptis.plugins.shareYourJira.PasswordFormHelper;
		}
		return this._passwordFormHelper;
	},

	_initSelect2Placeholder: function() {
		AJS.$('.aptis-sjy-add-field-button').on('click', function() {
			setTimeout(function () {
				AJS.$("select.sortedFields").select2({
					placeholder: AJS.I18n.getText("aptis-sjy-empty-field")
				});
			},10)
		});

		AJS.$('.aptis-sjy-add-attachment-button').on('click', function() {
			setTimeout(function () {
				AJS.$("select.sortedAttachments").select2({
					placeholder: AJS.I18n.getText("aptis-sjy-empty-attachment")
				});
			},10)
		});

		AJS.$('.aptis-sjy-add-comment-button').on('click', function() {
			setTimeout(function () {
				AJS.$("select.sortedComments").select2({
					placeholder: AJS.I18n.getText("aptis-sjy-empty-comment")
				});
			},10)
		});
	}
};
