var aptis = aptis || {};
aptis.plugins = aptis.plugins || {};
aptis.plugins.shareYourJira = aptis.plugins.shareYourJira || {};

aptis.plugins.shareYourJira.PasswordFormHelper = {

	/**
	 * @param {String} formElement
	 */
	showPasswordLink: function(formElement) {
		if(formElement.find('input[name="password"]').val()) {
			formElement.find('.change-password').css('display', 'block');
		}
	},

	/**
	 * @param {String} formElement
	 */
	changePasswordClickHandler: function(formElement) {
		formElement.find('.change-password').on('click', function (event) {
			formElement.find('input[name="password"]').attr("disabled", false);
			formElement.find('input[name="setPassword"]').prop('checked', true);
			formElement.find('input[name="password"]').val('');
			formElement.find('input[name="password"]').focus();
		});
	},

	/**
	 * @param {String} formElement
	 */
	initPasswordChangeField: function(formElement) {
		this.showPasswordLink(formElement);
		this.changePasswordClickHandler(formElement);
	}
};