var aptis = aptis || {};
aptis.plugins = aptis.plugins || {};
aptis.plugins.shareYourJira = aptis.plugins.shareYourJira || {};

aptis.plugins.shareYourJira.JetiEmailHandler = {

	/**
	 * @param {Issue} issue
	 * @param {Array} recipients
	 * @param {MailSubject} subject
	 * @param {String} body
	 * @param {String} emailTemplate
	 * @param {Function} callback
	 */
	sendMail: function(issue, recipients, subject, body, emailTemplate, callback) {
		var me = this;
		if(body == null) {
			body = "";
		}

		var jetiData = {
			issue: issue.key,
			to: recipients,
			cc: [],
			emailSubject: subject,
			emailBody: body,
			emailOptions: {
				replyToMe: false,
				mailAsMe: false,
				addComments: false,
				suppressCommentEvent: false,
				emailFormat: "html",
				richHtml: true
			}
		};
		if (emailTemplate) {
			jetiData.emailTemplate = emailTemplate;
		}
		AJS.$.ajax({
			url: AJS.params.baseURL + '/rest/jeti/1.0/email',
			type: 'POST',
			contentType: 'application/json',
			cache: false,
			processData: false,
			data: JSON.stringify(jetiData),
			success: function (data) {
				callback(data);
			},
			error: function (jqXHR, textStatus, errorThrown) {
				if (jqXHR.responseText) {
					me.handleError(jqXHR.responseText);
				} else {
					me.handleError(errorThrown);
				}
			}
		});
	},

	/**
	 * @param {String} errorMessage
	 */
	handleError: function(errorMessage) {
		AJS.messages.error({
			body: errorMessage,
			fadeout: true
		});
	}
};