var aptis = aptis || {};
aptis.plugins = aptis.plugins || {};
aptis.plugins.shareYourJira = aptis.plugins.shareYourJira || {};

aptis.plugins.shareYourJira.IssueQuery = {
	/**
	 * @param {String} issueId
	 * @param {Function} callback
	 */
	querySingleIssue: function(issueId, callback) {
		var me = this;
		AJS.$.ajax({
			url: AJS.params.baseURL + '/rest/api/2/issue/' + encodeURIComponent(issueId),
			type: 'get',
			contentType: 'application/json',
			cache: false,
			processData: false,
			success: function (issue) {
				callback(issue);
			},
			error: function (jqXHR, textStatus, errorThrown) {
				if (jqXHR.responseText) {
					me.handleError(jqXHR.responseText);
				} else {
					me.handleError(errorThrown);
				}
			}
		});
	},

	/**
	 * @param {String} errorMessage
	 */
	handleError: function(errorMessage) {
		AJS.messages.error({
			body: errorMessage,
			fadeout: true
		});
	}
};