/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.manifests;

import com.jcabi.aspects.aj.MethodValidator;
import com.jcabi.log.Logger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.servlet.ServletContext;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.SerializationUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public final class Manifests {
    private static final Map<String, String> INJECTED;
    private static Map<String, String> attributes;
    private static Map<URI, String> failures;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    static {
        Manifests.ajc$preClinit();
        INJECTED = new ConcurrentHashMap<String, String>();
        attributes = Manifests.load();
    }

    private Manifests() {
    }

    public static String read(@NotNull(message="attribute name can't be NULL") @Pattern(regexp=".+", message="attribute name can't be empty") String string) {
        String name;
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_0, null, null, string2);
        MethodValidator.aspectOf().beforeMethod(joinPoint);
        if (attributes == null) {
            throw new IllegalArgumentException("Manifests haven't been loaded yet, internal error");
        }
        if (!Manifests.exists(name)) {
            StringBuilder bldr = new StringBuilder(Logger.format("Atribute '%s' not found in MANIFEST.MF file(s) among %d other attribute(s) %[list]s and %d injection(s)", name, attributes.size(), new TreeSet(attributes.keySet()), INJECTED.size()));
            if (!failures.isEmpty()) {
                bldr.append("; failures: ").append(Logger.format("%[list]s", failures.keySet()));
            }
            throw new IllegalArgumentException(bldr.toString());
        }
        String result = INJECTED.containsKey(name) ? INJECTED.get(name) : attributes.get(name);
        Logger.debug(Manifests.class, "#read('%s'): found '%s'", name, result);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public static void inject(@NotNull(message="injected name can't be NULL") @Pattern(regexp=".+", message="name of attribute can't be empty") String string, @NotNull(message="inected value can't be NULL") String string2) {
        void value;
        String name;
        String string3 = string;
        String string4 = string2;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_1, null, null, string3, string4);
        MethodValidator.aspectOf().beforeMethod(joinPoint);
        if (INJECTED.containsKey(name)) {
            Logger.info(Manifests.class, "#inject(%s, '%s'): replaced previous injection '%s'", name, value, INJECTED.get(name));
        } else {
            Logger.info(Manifests.class, "#inject(%s, '%s'): injected", name, value);
        }
        INJECTED.put(name, (String)value);
    }

    public static boolean exists(@NotNull(message="name of attribute can't be NULL") @Pattern(regexp=".+", message="name of attribute can't be empty") String string) {
        String name;
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_2, null, null, string2);
        MethodValidator.aspectOf().beforeMethod(joinPoint);
        boolean exists = attributes.containsKey(name) || INJECTED.containsKey(name);
        Logger.debug(Manifests.class, "#exists('%s'): %B", name, exists);
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] snapshot() {
        byte[] snapshot;
        Map<String, String> map = INJECTED;
        synchronized (map) {
            snapshot = SerializationUtils.serialize((Serializable)((Object)INJECTED));
        }
        Logger.debug(Manifests.class, "#snapshot(): created (%d bytes)", snapshot.length);
        return snapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void revert(@NotNull byte[] byArray) {
        byte[] snapshot;
        byte[] byArray2 = byArray;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_3, null, null, (Object)byArray2);
        MethodValidator.aspectOf().beforeMethod(joinPoint);
        Map<String, String> map = INJECTED;
        synchronized (map) {
            INJECTED.clear();
            INJECTED.putAll((Map)SerializationUtils.deserialize(snapshot));
        }
        Logger.debug(Manifests.class, "#revert(%d bytes): reverted", snapshot.length);
    }

    public static void append(@NotNull ServletContext servletContext) throws IOException {
        URL main;
        ServletContext ctx;
        ServletContext servletContext2 = servletContext;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_4, null, null, servletContext2);
        MethodValidator.aspectOf().beforeMethod(joinPoint);
        long start = System.currentTimeMillis();
        try {
            main = ctx.getResource("/META-INF/MANIFEST.MF");
        }
        catch (MalformedURLException ex) {
            throw new IOException(ex);
        }
        if (main == null) {
            Logger.warn(Manifests.class, "#append(%s): MANIFEST.MF not found in WAR package", ctx.getClass().getName());
        } else {
            Map<String, String> attrs = Manifests.loadOneFile(main);
            attributes.putAll(attrs);
            Logger.info(Manifests.class, "#append(%s): %d attribs loaded from %s in %[ms]s (%d total): %[list]s", ctx.getClass().getName(), attrs.size(), main, System.currentTimeMillis() - start, attributes.size(), new TreeSet(attrs.keySet()));
        }
    }

    public static void append(@NotNull File file) throws IOException {
        Map<String, String> attrs;
        File file2;
        File file3 = file;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_5, null, null, file3);
        MethodValidator.aspectOf().beforeMethod(joinPoint);
        long start = System.currentTimeMillis();
        try {
            attrs = Manifests.loadOneFile(file2.toURI().toURL());
        }
        catch (MalformedURLException ex) {
            throw new IOException(ex);
        }
        attributes.putAll(attrs);
        Logger.info(Manifests.class, "#append('%s'): %d attributes loaded in %[ms]s (%d total): %[list]s", file2, attrs.size(), System.currentTimeMillis() - start, attributes.size(), new TreeSet(attrs.keySet()));
    }

    private static Map<String, String> load() {
        long start = System.currentTimeMillis();
        failures = new ConcurrentHashMap<URI, String>();
        ConcurrentHashMap<String, String> attrs = new ConcurrentHashMap<String, String>();
        int count = 0;
        for (URI uri : Manifests.uris()) {
            try {
                attrs.putAll(Manifests.loadOneFile(uri.toURL()));
            }
            catch (IOException ex) {
                failures.put(uri, ex.getMessage());
                Logger.error(Manifests.class, "#load(): '%s' failed %[exception]s", uri, ex);
            }
            ++count;
        }
        Logger.info(Manifests.class, "#load(): %d attribs loaded from %d URL(s) in %[ms]s: %[list]s", attrs.size(), count, System.currentTimeMillis() - start, new TreeSet(attrs.keySet()));
        return attrs;
    }

    private static Set<URI> uris() {
        Enumeration<URL> resources;
        try {
            resources = Thread.currentThread().getContextClassLoader().getResources("META-INF/MANIFEST.MF");
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        HashSet<URI> uris = new HashSet<URI>();
        while (resources.hasMoreElements()) {
            try {
                uris.add(resources.nextElement().toURI());
            }
            catch (URISyntaxException ex) {
                throw new IllegalStateException(ex);
            }
        }
        return uris;
    }

    private static Map<String, String> loadOneFile(URL url) throws IOException {
        ConcurrentHashMap<String, String> props = new ConcurrentHashMap<String, String>();
        InputStream stream = url.openStream();
        try {
            try {
                Manifest manifest = new Manifest(stream);
                Attributes attrs = manifest.getMainAttributes();
                for (Object key : attrs.keySet()) {
                    String value = attrs.getValue((Attributes.Name)key);
                    props.put(key.toString(), value);
                }
                Logger.debug(Manifests.class, "#loadOneFile('%s'): %d attributes loaded (%[list]s)", url, props.size(), new TreeSet(props.keySet()));
            }
            catch (RuntimeException ex) {
                Logger.error(Manifests.class, "#getMainAttributes(): '%s' failed %[exception]s", url, ex);
                IOUtils.closeQuietly(stream);
            }
        }
        finally {
            IOUtils.closeQuietly(stream);
        }
        return props;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("Manifests.java", Manifests.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "read", "com.jcabi.manifests.Manifests", "java.lang.String", "name", "", "java.lang.String"), 185);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "inject", "com.jcabi.manifests.Manifests", "java.lang.String:java.lang.String", "name:value", "", "void"), 234);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "exists", "com.jcabi.manifests.Manifests", "java.lang.String", "name", "", "boolean"), 269);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "revert", "com.jcabi.manifests.Manifests", "[B", "snapshot", "", "void"), 309);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "append", "com.jcabi.manifests.Manifests", "javax.servlet.ServletContext", "ctx", "java.io.IOException", "void"), 337);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "append", "com.jcabi.manifests.Manifests", "java.io.File", "file", "java.io.IOException", "void"), 377);
    }
}

