/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.log;

import com.jcabi.aspects.aj.MethodValidator;
import com.jcabi.log.Logger;
import com.jcabi.log.VerboseRunnable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public final class VerboseProcess {
    private final transient Process process;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public VerboseProcess(@NotNull Process prc) {
        Process process = prc;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_0, (Object)this, (Object)this, process);
        MethodValidator.aspectOf().beforeCtor(joinPoint);
        this.process = prc;
    }

    public VerboseProcess(@NotNull ProcessBuilder builder) {
        ProcessBuilder processBuilder = builder;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_1, (Object)this, (Object)this, processBuilder);
        MethodValidator.aspectOf().beforeCtor(joinPoint);
        builder.redirectErrorStream(true);
        try {
            this.process = builder.start();
            this.process.getOutputStream().close();
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public String stdout() {
        String stdout;
        long start = System.currentTimeMillis();
        try {
            stdout = this.waitFor();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(ex);
        }
        int code = this.process.exitValue();
        Logger.debug(this, "#stdout(): process %s completed (code=%d, size=%d) in %[ms]s", this.process, code, stdout.length(), System.currentTimeMillis() - start);
        if (code != 0) {
            throw new IllegalArgumentException(Logger.format("Non-zero exit code %d: %[text]s", code, stdout));
        }
        return stdout;
    }

    private String waitFor() throws InterruptedException {
        final BufferedReader reader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
        final CountDownLatch done = new CountDownLatch(1);
        final StringBuffer stdout = new StringBuffer();
        new Thread(new VerboseRunnable(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String line;
                while ((line = reader.readLine()) != null) {
                    Logger.info(VerboseProcess.class, ">> %s", line);
                    stdout.append(line);
                }
                done.countDown();
                return null;
            }
        }, false)).start();
        Logger.debug(this, "#waitFor(): waiting for stdout of %s...", this.process);
        try {
            this.process.waitFor();
        }
        catch (Throwable throwable) {
            Logger.debug(this, "#waitFor(): process finished", this.process);
            done.await(1L, TimeUnit.SECONDS);
            try {
                reader.close();
            }
            catch (IOException ex) {
                Logger.error(this, "failed to close reader: %[exception]s", ex);
            }
            throw throwable;
        }
        Logger.debug(this, "#waitFor(): process finished", this.process);
        done.await(1L, TimeUnit.SECONDS);
        try {
            reader.close();
        }
        catch (IOException ex) {
            Logger.error(this, "failed to close reader: %[exception]s", ex);
        }
        return stdout.toString();
    }

    static {
        VerboseProcess.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("VerboseProcess.java", VerboseProcess.class);
        ajc$tjp_0 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "com.jcabi.log.VerboseProcess", "java.lang.Process", "prc", ""), 69);
        ajc$tjp_1 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "com.jcabi.log.VerboseProcess", "java.lang.ProcessBuilder", "builder", ""), 78);
    }
}

