/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.aspects.aj;

import com.jcabi.aspects.Loggable;
import com.jcabi.log.Logger;
import java.lang.reflect.Method;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public final class MethodLogger {
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ MethodLogger ajc$perSingletonInstance;

    @Around(value="(execution(* *(..)) || initialization(*.new(..))) && @annotation(com.jcabi.aspects.Loggable)")
    public Object wrap(ProceedingJoinPoint point) throws Throwable {
        long start = System.nanoTime();
        Method method = ((MethodSignature)MethodSignature.class.cast(point.getSignature())).getMethod();
        try {
            Object result = point.proceed();
            this.log(method.getAnnotation(Loggable.class).value(), method.getDeclaringClass(), this.compose(method, point, Logger.format("returned %s in %[nano]s", MethodLogger.text(result), System.nanoTime() - start)));
            return result;
        }
        catch (Throwable ex) {
            this.log(4, method.getDeclaringClass(), this.compose(method, point, Logger.format("thrown %[type]s (%s) in %[nano]s", ex, MethodLogger.text(ex.getMessage()), System.nanoTime() - start)));
            throw ex;
        }
    }

    private String compose(Method method, ProceedingJoinPoint point, String result) {
        StringBuilder log = new StringBuilder();
        log.append('#').append(method.getName()).append('(');
        Object[] args = point.getArgs();
        int pos = 0;
        while (pos < args.length) {
            if (pos > 0) {
                log.append(", ");
            }
            log.append(MethodLogger.text(args[pos]));
            ++pos;
        }
        log.append("): ").append(result);
        return log.toString();
    }

    private void log(int level, Class<?> log, String message) {
        if (level == 0) {
            Logger.trace(log, message, new Object[0]);
        } else if (level == 2) {
            Logger.debug(log, message, new Object[0]);
        } else if (level == 1) {
            Logger.info(log, message, new Object[0]);
        } else if (level == 3) {
            Logger.warn(log, message, new Object[0]);
        } else if (level == 4) {
            Logger.error(log, message, new Object[0]);
        }
    }

    private static String text(Object arg) {
        String text = arg == null ? "NULL" : Logger.format("'%s'", arg);
        return text;
    }

    public static MethodLogger aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("com.jcabi.aspects.aj.MethodLogger", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }

    static {
        try {
            MethodLogger.ajc$perSingletonInstance = new MethodLogger();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }
}

