/*
 * Decompiled with CFR 0.152.
 */
package aptis.plugins.shareYourJira.upgradeTask;

import aptis.plugins.shareYourJira.setting.ProjectSetting;
import aptis.plugins.shareYourJira.setting.ProjectSettingsManager;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public class UpgradeTaskProjectConfigurationAo
implements PluginUpgradeTask {
    private PluginLicenseManager pluginLicenseManager;
    private PluginSettingsFactory pluginSettingsFactory;
    private ProjectManager projectManager;
    private ProjectSettingsManager projectSettingsManager;

    public UpgradeTaskProjectConfigurationAo(PluginLicenseManager pluginLicenseManager, PluginSettingsFactory pluginSettingsFactory, ActiveObjects activeObjects) {
        this.pluginLicenseManager = pluginLicenseManager;
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.projectManager = ComponentAccessor.getProjectManager();
        this.projectSettingsManager = new ProjectSettingsManager(activeObjects);
    }

    public int getBuildNumber() {
        return 10;
    }

    public String getPluginKey() {
        return this.pluginLicenseManager.getPluginKey();
    }

    public String getShortDescription() {
        return "This upgrade task takes the project settings that are stored as xml plugin settings and converts it to active objects.";
    }

    public Collection<Message> doUpgrade() throws Exception {
        List projects = this.projectManager.getProjects();
        for (Project project : projects) {
            PluginSettings pluginSettings;
            ProjectSetting projectSetting = this.projectSettingsManager.findSetting(project.getId());
            if (projectSetting != null || (projectSetting = this.getMigratedPluginSettingsToAo(project, pluginSettings = this.pluginSettingsFactory.createSettingsForKey("project_" + project.getId()))) == null) continue;
            projectSetting.save();
        }
        return Collections.emptySet();
    }

    @Nullable
    private ProjectSetting getMigratedPluginSettingsToAo(Project project, PluginSettings pluginSettings) {
        Object shareAllowedProjectRoleIds = pluginSettings.get(this.buildCompleteConfigKey("shareAllowedProjectRoleIds"));
        Object shareEmailSystem = pluginSettings.get(this.buildCompleteConfigKey("shareEmailSystem"));
        Object jetiTemplate = pluginSettings.get(this.buildCompleteConfigKey("shareJetiTemplate"));
        Object shareCustomEmailTemplate = pluginSettings.get(this.buildCompleteConfigKey("shareCustomEmailTemplate"));
        if (shareEmailSystem == null && shareAllowedProjectRoleIds == null && jetiTemplate == null && shareCustomEmailTemplate == null) {
            return null;
        }
        ProjectSetting projectSetting = this.projectSettingsManager.createEmptyProjectSetting(project);
        projectSetting.setCustomize(true);
        Gson gson = new Gson();
        if (shareAllowedProjectRoleIds instanceof ArrayList) {
            projectSetting.setShareAllowedProjectRoleIds(gson.toJson(shareAllowedProjectRoleIds));
        }
        if (shareEmailSystem instanceof String) {
            projectSetting.setEmailSystem((String)shareEmailSystem);
        }
        if (jetiTemplate instanceof String) {
            projectSetting.setJetiTemplate((String)jetiTemplate);
        }
        if (shareCustomEmailTemplate instanceof String) {
            projectSetting.setEmailTemplateVariant("custom");
            projectSetting.setCustomEmailTemplate((String)shareCustomEmailTemplate);
        }
        return projectSetting;
    }

    private String buildCompleteConfigKey(String configKey) {
        return "aptis.plugins.shareYourJira." + configKey;
    }
}

