/*
 * Decompiled with CFR 0.152.
 */
package aptis.plugins.shareYourJira.upgradeTask;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.managedconfiguration.ConfigurationItemAccessLevel;
import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItem;
import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItemService;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.context.GlobalIssueContext;
import com.atlassian.jira.issue.context.JiraContextNode;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.ofbiz.core.entity.GenericEntityException;

public class UpgradeTaskCreateShareLinkCustomfield
implements PluginUpgradeTask {
    private final PluginLicenseManager pluginLicenseManager;
    private final ManagedConfigurationItemService managedConfigurationItemService;

    public UpgradeTaskCreateShareLinkCustomfield(PluginLicenseManager pluginLicenseManager, ManagedConfigurationItemService managedConfigurationItemService) {
        this.pluginLicenseManager = pluginLicenseManager;
        this.managedConfigurationItemService = managedConfigurationItemService;
    }

    public int getBuildNumber() {
        return 12;
    }

    public String getShortDescription() {
        return "This upgrade tasks creates the Auto Share Customfield and locks it.";
    }

    public Collection<Message> doUpgrade() throws Exception {
        CustomField customField = this.createShareLinkCustomfield();
        if (customField != null) {
            this.lockCustomfield(customField, this.managedConfigurationItemService);
        }
        return Collections.emptySet();
    }

    public String getPluginKey() {
        return this.pluginLicenseManager.getPluginKey();
    }

    private void lockCustomfield(CustomField customField, ManagedConfigurationItemService managedConfigurationItemService) {
        ManagedConfigurationItem managedConfigurationItem = managedConfigurationItemService.getManagedCustomField(customField);
        managedConfigurationItem = managedConfigurationItem.newBuilder().setManaged(true).setConfigurationItemAccessLevel(ConfigurationItemAccessLevel.LOCKED).build();
        managedConfigurationItemService.updateManagedConfigurationItem(managedConfigurationItem);
    }

    private CustomField createShareLinkCustomfield() throws GenericEntityException {
        CustomFieldManager customFieldManager = ComponentAccessor.getCustomFieldManager();
        ArrayList<Object> issueTypes = new ArrayList<Object>(1);
        issueTypes.add(null);
        CustomFieldType customFieldType = customFieldManager.getCustomFieldType("aptis.plugins.shareYourJira:aptis-share-link-field");
        CustomField shareLinkCustomfield = customFieldManager.createCustomField("Auto share link", "Field that automatically creates a link to view issues externally.", customFieldType, null, (List)Lists.newArrayList((Object[])new JiraContextNode[]{GlobalIssueContext.getInstance()}), issueTypes);
        ComponentAccessor.getTranslationManager().setCustomFieldTranslation(shareLinkCustomfield, new Locale("de", "DE"), "Auto teilen Link", "Ein Feld das automatisch einen Link erstellt um Vorg\u00e4nge extern anzusehen.");
        return shareLinkCustomfield;
    }
}

