/*
 * Decompiled with CFR 0.152.
 */
package aptis.plugins.shareYourJira.tabpanels;

import aptis.plugins.shareYourJira.common.RenderHelper;
import aptis.plugins.shareYourJira.sharedContainer.DisplayFieldManager;
import aptis.plugins.shareYourJira.sharedContainer.IssueShare;
import aptis.plugins.shareYourJira.sharedContainer.IssueShareManager;
import aptis.plugins.shareYourJira.sharedContainer.TokenManager;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.plugin.issuetabpanel.AbstractIssueAction;
import com.atlassian.jira.plugin.issuetabpanel.IssueTabPanelModuleDescriptor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;

public class IssueShareHistoryAction
extends AbstractIssueAction {
    private final Issue issue;
    private final ApplicationUser currentUser;
    private final ActiveObjects activeObjects;
    private final IssueShareManager issueShareManager;
    private final DateTimeFormatterFactory dateTimeFormatterFactory;
    private final RenderHelper renderHelper;
    private final UserManager userManager;

    public IssueShareHistoryAction(IssueTabPanelModuleDescriptor issueTabPanelModuleDescriptor, Issue issue, ApplicationUser currentUser, ActiveObjects activeObjects, DateTimeFormatterFactory dateTimeFormatterFactory, I18nResolver i18nResolver, SearchRequestService searchRequestService, UserManager userManager) {
        super(issueTabPanelModuleDescriptor);
        this.issue = issue;
        this.currentUser = currentUser;
        this.activeObjects = activeObjects;
        this.userManager = userManager;
        TokenManager tokenManager = new TokenManager(this.activeObjects);
        DisplayFieldManager displayFieldManager = new DisplayFieldManager(this.activeObjects);
        this.issueShareManager = new IssueShareManager(this.activeObjects, tokenManager, displayFieldManager);
        this.dateTimeFormatterFactory = dateTimeFormatterFactory;
        this.renderHelper = new RenderHelper(searchRequestService, i18nResolver, dateTimeFormatterFactory, activeObjects);
    }

    public Date getTimePerformed() {
        return null;
    }

    public void populateVelocityParams(Map params) {
        ArrayList<IssueShare> allShareItems = new ArrayList<IssueShare>();
        allShareItems.addAll(this.issueShareManager.getAllIssueShareForIssue(this.issue));
        DateTimeFormatter dateTimeFormatter = this.dateTimeFormatterFactory.formatter().forLoggedInUser();
        params.put("allShareItems", allShareItems);
        params.put("userManager", ComponentAccessor.getUserManager());
        params.put("avatarManager", ComponentAccessor.getAvatarService());
        params.put("dateTimeFormatter", dateTimeFormatter);
        params.put("currentUser", this.currentUser);
        params.put("renderHelper", this.renderHelper);
        params.put("canEditAllShares", this.userManager.isSystemAdmin(this.currentUser.getUsername()));
        params.put("baseUrl", ComponentAccessor.getApplicationProperties().getString("jira.baseurl"));
    }
}

