/*
 * Decompiled with CFR 0.152.
 */
package aptis.plugins.shareYourJira.sharedContainer;

import aptis.plugins.shareYourJira.shareTemplate.ShareTemplateResponse;
import aptis.plugins.shareYourJira.sharedContainer.DisplayField;
import aptis.plugins.shareYourJira.sharedContainer.DisplayFieldManager;
import aptis.plugins.shareYourJira.sharedContainer.ShareTemplate;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.user.ApplicationUser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;

public class ShareTemplateManager {
    private final ActiveObjects activeObjects;
    private final DisplayFieldManager displayFieldManager;

    public ShareTemplateManager(ActiveObjects activeObjects, DisplayFieldManager displayFieldManager) {
        this.activeObjects = activeObjects;
        this.displayFieldManager = displayFieldManager;
    }

    public ShareTemplate createShareTemplate(ApplicationUser user, String name, List<String> displayFieldIds) throws Exception {
        ShareTemplate shareTemplate = (ShareTemplate)this.activeObjects.create(ShareTemplate.class, new DBParam[]{new DBParam("USER_KEY", (Object)user.getKey()), new DBParam("NAME", (Object)name)});
        shareTemplate.save();
        if (displayFieldIds != null) {
            for (String displayFieldId : displayFieldIds) {
                this.displayFieldManager.createDisplayField(shareTemplate, displayFieldId);
            }
        }
        return shareTemplate;
    }

    public ShareTemplate findShareTemplateById(int shareTemplateId) {
        ShareTemplate[] dataResult = (ShareTemplate[])this.activeObjects.find(ShareTemplate.class, Query.select().where("ID = ?", new Object[]{shareTemplateId}));
        if (dataResult.length == 0) {
            return null;
        }
        return dataResult[0];
    }

    public List<ShareTemplate> getAllShareTemplates() {
        ArrayList<ShareTemplate> result = new ArrayList<ShareTemplate>();
        ShareTemplate[] foundResult = (ShareTemplate[])this.activeObjects.find(ShareTemplate.class);
        if (foundResult.length > 0) {
            result.addAll(Arrays.asList(foundResult));
        }
        return result;
    }

    public List<ShareTemplate> getAllShareTemplatesCreatedByUser(ApplicationUser user) {
        ArrayList<ShareTemplate> result = new ArrayList<ShareTemplate>();
        ShareTemplate[] foundResult = (ShareTemplate[])this.activeObjects.find(ShareTemplate.class, Query.select().alias(ShareTemplate.class, "shareTemplate").where("USER_KEY = ?", new Object[]{user.getKey()}).order("shareTemplate.NAME DESC"));
        if (foundResult.length > 0) {
            result.addAll(Arrays.asList(foundResult));
        }
        return result;
    }

    public void deleteShareTemplate(ShareTemplate shareTemplate) {
        if (shareTemplate == null) {
            return;
        }
        List<DisplayField> displayFields = this.displayFieldManager.findDisplayFieldsByShareId(shareTemplate.getID(), "template");
        for (DisplayField displayField : displayFields) {
            this.activeObjects.delete(new RawEntity[]{displayField});
        }
        this.activeObjects.delete(new RawEntity[]{shareTemplate});
    }

    public void deleteAllShareTemplates() {
        List<ShareTemplate> shareTemplates = this.getAllShareTemplates();
        for (ShareTemplate shareTemplate : shareTemplates) {
            List<DisplayField> displayFields = this.displayFieldManager.findDisplayFieldsByShareId(shareTemplate.getID(), "template");
            for (DisplayField displayField : displayFields) {
                this.activeObjects.delete(new RawEntity[]{displayField});
            }
            this.activeObjects.delete(new RawEntity[]{shareTemplate});
        }
    }

    public List<String> getDisplayFieldIdsByShareTemplateId(int shareTemplateId) {
        ArrayList<String> displayFieldIds = new ArrayList<String>();
        displayFieldIds.addAll(this.displayFieldManager.getListOfDisplayFieldIds(this.findShareTemplateById(shareTemplateId)));
        return displayFieldIds;
    }

    public List<String> getDisplayFieldIds(ShareTemplate shareTemplate) {
        ArrayList<String> displayFieldIds = new ArrayList<String>();
        displayFieldIds.addAll(this.displayFieldManager.getListOfDisplayFieldIds(shareTemplate));
        return displayFieldIds;
    }

    public ShareTemplateResponse createPostResponse(ShareTemplate shareTemplate) {
        ShareTemplateResponse response = new ShareTemplateResponse();
        response.setTemplateId(shareTemplate.getID());
        response.setDisplayFieldIds(this.getDisplayFieldIds(shareTemplate));
        response.setName(shareTemplate.getName());
        return response;
    }

    public ShareTemplateResponse createGetResponse(int shareTemplateId) {
        ShareTemplateResponse response = new ShareTemplateResponse();
        response.setTemplateId(shareTemplateId);
        response.setDisplayFieldIds(this.getDisplayFieldIdsByShareTemplateId(shareTemplateId));
        return response;
    }
}

