/*
 * Decompiled with CFR 0.152.
 */
package aptis.plugins.shareYourJira.sharedContainer;

import aptis.plugins.common.ErrorDetailProvider;
import aptis.plugins.common.ExceptionWithoutTechnicalInformation;
import aptis.plugins.common.PluginLicenseValidator;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ShareManagementServlet
extends HttpServlet {
    private final TemplateRenderer templateRenderer;
    private final PluginLicenseManager pluginLicenseManager;
    private final UserManager userManager;
    private final I18nResolver i18nResolver;

    public ShareManagementServlet(TemplateRenderer templateRenderer, PluginLicenseManager pluginLicenseManager, UserManager userManager, I18nResolver i18nResolver) {
        this.templateRenderer = templateRenderer;
        this.pluginLicenseManager = pluginLicenseManager;
        this.userManager = userManager;
        this.i18nResolver = i18nResolver;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Map context = ComponentAccessor.getVelocityParamFactory().getDefaultVelocityParams();
        try {
            PluginLicenseValidator pluginLicenseValidator = new PluginLicenseValidator(this.pluginLicenseManager);
            if (!pluginLicenseValidator.hasValidLicense()) {
                throw new ExceptionWithoutTechnicalInformation(pluginLicenseValidator.getLocalizedErrorMessage(request.getLocale()));
            }
            UserProfile userProfile = this.userManager.getRemoteUser(request);
            if (userProfile == null || userProfile.getUserKey() == null) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("issue.operations.error.401"));
            }
            context.put("baseUrl", ComponentAccessor.getApplicationProperties().getString("jira.baseurl"));
            this.templateRenderer.render("templates/sharedContainer/shareManagementDocument.vm", context, (Writer)response.getWriter());
        }
        catch (Throwable exception) {
            context.put("errorDetailProvider", new ErrorDetailProvider(exception, request));
            context.put("exception", exception);
            this.templateRenderer.render("templates/errorDocument.vm", context, (Writer)response.getWriter());
        }
    }
}

