/*
 * Decompiled with CFR 0.152.
 */
package aptis.plugins.shareYourJira.sharedContainer;

import aptis.plugins.common.ExceptionWithoutTechnicalInformation;
import aptis.plugins.common.PluginLicenseValidator;
import aptis.plugins.shareYourJira.common.RenderHelper;
import aptis.plugins.shareYourJira.common.ShareSettingsJsonBuilder;
import aptis.plugins.shareYourJira.sharedContainer.DisplayFieldManager;
import aptis.plugins.shareYourJira.sharedContainer.FilterShare;
import aptis.plugins.shareYourJira.sharedContainer.FilterShareManager;
import aptis.plugins.shareYourJira.sharedContainer.IssueShare;
import aptis.plugins.shareYourJira.sharedContainer.IssueShareManager;
import aptis.plugins.shareYourJira.sharedContainer.TokenManager;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.net.URI;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/shareManagement")
public class ShareManagementRestService {
    private final ActiveObjects activeObjects;
    private final PluginLicenseManager pluginLicenseManager;
    private final com.atlassian.sal.api.user.UserManager userManager;
    private final UserManager jiraUserManager;
    private final I18nResolver i18nResolver;
    private final RenderHelper renderHelper;

    public ShareManagementRestService(ActiveObjects activeObjects, PluginLicenseManager pluginLicenseManager, com.atlassian.sal.api.user.UserManager userManager, I18nResolver i18nResolver, SearchRequestService searchRequestService, DateTimeFormatterFactory dateTimeFormatterFactory) {
        this.activeObjects = activeObjects;
        this.pluginLicenseManager = pluginLicenseManager;
        this.userManager = userManager;
        this.jiraUserManager = ComponentAccessor.getUserManager();
        this.i18nResolver = i18nResolver;
        this.renderHelper = new RenderHelper(searchRequestService, i18nResolver, dateTimeFormatterFactory, activeObjects);
    }

    @GET
    @Produces(value={"application/json"})
    public Response get(@Context HttpServletRequest request) {
        try {
            JsonObject shareItemJson;
            PluginLicenseValidator pluginLicenseValidator = new PluginLicenseValidator(this.pluginLicenseManager);
            if (!pluginLicenseValidator.hasValidLicense()) {
                throw new ExceptionWithoutTechnicalInformation(pluginLicenseValidator.getLocalizedErrorMessage(request.getLocale()));
            }
            UserProfile userProfile = this.userManager.getRemoteUser(request);
            if (userProfile == null || userProfile.getUserKey() == null) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("issue.operations.error.401"));
            }
            TokenManager tokenManager = new TokenManager(this.activeObjects);
            DisplayFieldManager displayFieldManager = new DisplayFieldManager(this.activeObjects);
            ApplicationUser user = this.jiraUserManager.getUserByKey(userProfile.getUserKey().getStringValue());
            IssueShareManager issueShareManager = new IssueShareManager(this.activeObjects, tokenManager, displayFieldManager);
            FilterShareManager filterShareManager = new FilterShareManager(this.activeObjects, tokenManager, displayFieldManager);
            ShareSettingsJsonBuilder shareSettingsJsonBuilder = new ShareSettingsJsonBuilder(displayFieldManager);
            ArrayList<IssueShare> issueShares = new ArrayList<IssueShare>();
            ArrayList<FilterShare> filterShares = new ArrayList<FilterShare>();
            if (this.userManager.isSystemAdmin(userProfile.getUserKey())) {
                issueShares.addAll(issueShareManager.getAllIssueShares());
            } else {
                issueShares.addAll(issueShareManager.getAllIssueShareCreatedByUser(user));
            }
            if (this.userManager.isSystemAdmin(userProfile.getUserKey())) {
                filterShares.addAll(filterShareManager.getAllFilterShares());
            } else {
                filterShares.addAll(filterShareManager.getAllFilterShareCreatedByUser(user));
            }
            JsonObject responseJson = new JsonObject();
            JsonArray shareItemsJson = new JsonArray();
            for (IssueShare issueShare : issueShares) {
                shareItemJson = this.buildShareItemJson(issueShare, user);
                shareItemJson.add("configuration", shareSettingsJsonBuilder.getJsonSettingsForIssueShare(issueShare));
                shareItemsJson.add(shareItemJson);
            }
            for (FilterShare filterShare : filterShares) {
                shareItemJson = this.buildShareItemJson(filterShare, user);
                shareItemJson.add("configuration", shareSettingsJsonBuilder.getJsonSettingsForFilterShare(filterShare));
                shareItemsJson.add(shareItemJson);
            }
            responseJson.add("shareItems", shareItemsJson);
            Gson gson = new Gson();
            return Response.ok((Object)gson.toJson(responseJson)).build();
        }
        catch (Throwable exception) {
            return Response.serverError().entity((Object)exception.getLocalizedMessage()).build();
        }
    }

    private JsonObject buildShareItemJson(IssueShare shareItem, ApplicationUser user) {
        return this.getJsonObject(shareItem.getID(), shareItem.getIssueId(), this.renderHelper.getKey(shareItem, user), shareItem.isActive(), "issue", this.renderHelper.getName(shareItem, user), this.renderHelper.getCreator(shareItem), shareItem.getToken().getCreated().getTime(), this.renderHelper.getCountCalls(shareItem), this.renderHelper.getUrl(shareItem), this.renderHelper.getNote(shareItem), user);
    }

    private JsonObject buildShareItemJson(FilterShare shareItem, ApplicationUser user) {
        return this.getJsonObject(shareItem.getID(), shareItem.getFilterId(), null, shareItem.isActive(), "filter", this.renderHelper.getName(shareItem, user), this.renderHelper.getCreator(shareItem), shareItem.getToken().getCreated().getTime(), this.renderHelper.getCountCalls(shareItem), this.renderHelper.getUrl(shareItem), this.renderHelper.getNote(shareItem), user);
    }

    private JsonObject getJsonObject(int id, long itemId, @Nullable String itemKey, boolean isActive, String type, String name, ApplicationUser creator, long createdDate, int countCalls, String url, String note, ApplicationUser user) {
        JsonObject shareItemJson = new JsonObject();
        shareItemJson.addProperty("id", id);
        shareItemJson.addProperty("itemId", itemId);
        shareItemJson.addProperty("itemKey", itemKey);
        shareItemJson.addProperty("isActive", isActive);
        shareItemJson.addProperty("type", type);
        shareItemJson.addProperty("name", name);
        JsonObject creatorUser = new JsonObject();
        JsonObject avatarUrls = new JsonObject();
        URI avatarURL = ComponentAccessor.getAvatarService().getAvatarURL(user, creator, Avatar.Size.SMALL);
        avatarUrls.addProperty("16x16", avatarURL.toString());
        creatorUser.addProperty("displayName", creator.getDisplayName());
        creatorUser.addProperty("key", creator.getKey());
        creatorUser.add("avatarUrls", avatarUrls);
        shareItemJson.add("creator", creatorUser);
        shareItemJson.addProperty("createdDate", createdDate);
        shareItemJson.addProperty("callCount", countCalls);
        shareItemJson.addProperty("shareLinkUrl", url);
        shareItemJson.addProperty("note", note);
        return shareItemJson;
    }
}

