/*
 * Decompiled with CFR 0.152.
 */
package aptis.plugins.shareYourJira.sharedContainer;

import aptis.plugins.common.AOConverter;
import aptis.plugins.shareYourJira.common.PasswordHashConverter;
import aptis.plugins.shareYourJira.issue.CreateShareLinkRequest;
import aptis.plugins.shareYourJira.sharedContainer.DisplayField;
import aptis.plugins.shareYourJira.sharedContainer.DisplayFieldManager;
import aptis.plugins.shareYourJira.sharedContainer.IssueShare;
import aptis.plugins.shareYourJira.sharedContainer.Token;
import aptis.plugins.shareYourJira.sharedContainer.TokenManager;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;

public class IssueShareManager {
    private final ActiveObjects activeObjects;
    private final TokenManager tokenManager;
    private final DisplayFieldManager displayFieldManager;

    public IssueShareManager(ActiveObjects activeObjects, TokenManager tokenManager, DisplayFieldManager displayFieldManager) {
        this.activeObjects = activeObjects;
        this.tokenManager = tokenManager;
        this.displayFieldManager = displayFieldManager;
    }

    public IssueShare createIssueShare(ApplicationUser user, Issue issue, CreateShareLinkRequest config) throws Exception {
        PasswordHashConverter passwordHashConverter = new PasswordHashConverter();
        Token token = this.tokenManager.createToken(user);
        IssueShare issueShare = (IssueShare)this.activeObjects.create(IssueShare.class, new DBParam[]{new DBParam("ACTIVE", (Object)true), new DBParam("ISSUE_ID", (Object)issue.getId()), new DBParam("TOKEN_ID", (Object)token.getID()), new DBParam("VALID_PERIOD_FROM", (Object)config.getValidPeriodFrom()), new DBParam("VALID_PERIOD_TO", (Object)config.getValidPeriodTo()), new DBParam("PASSWORD_HASH", config.getPassword() == null ? null : passwordHashConverter.hashPassword(config.getPassword().toCharArray())), new DBParam("IPS_LOCK", (Object)config.getIPsLock()), new DBParam("NOTE", (Object)config.getNote()), new DBParam("ONLY_LOGGED_IN_USER", (Object)config.getOnlyLoggedInUser()), new DBParam("ATTACHMENT_VISIBILITY_STRING", (Object)AOConverter.convertToString(config.getAttachmentVisibility())), new DBParam("COMMENT_VISIBILITY_STRING", (Object)AOConverter.convertToString(config.getCommentVisibility()))});
        issueShare.save();
        if (config.getDisplayingFields() != null) {
            for (String displayFieldId : config.getDisplayingFields()) {
                this.displayFieldManager.createDisplayField(issueShare, displayFieldId);
            }
        }
        return issueShare;
    }

    public IssueShare findIssueShareById(int id) {
        IssueShare[] dataResult = (IssueShare[])this.activeObjects.find(IssueShare.class, Query.select().where("ID = ?", new Object[]{id}));
        if (dataResult.length == 0) {
            return null;
        }
        return dataResult[0];
    }

    public List<IssueShare> getAllIssueShares() {
        ArrayList<IssueShare> result = new ArrayList<IssueShare>();
        IssueShare[] foundResult = (IssueShare[])this.activeObjects.find(IssueShare.class);
        if (foundResult.length > 0) {
            result.addAll(Arrays.asList(foundResult));
        }
        return result;
    }

    public List<IssueShare> getAllIssueShareForIssue(Issue issue) {
        ArrayList<IssueShare> result = new ArrayList<IssueShare>();
        IssueShare[] foundResult = (IssueShare[])this.activeObjects.find(IssueShare.class, Query.select().alias(IssueShare.class, "issueShare").where("issueShare.ISSUE_ID = ?", new Object[]{issue.getId()}).order("issueShare.ID DESC"));
        if (foundResult.length > 0) {
            result.addAll(Arrays.asList(foundResult));
        }
        return result;
    }

    public List<IssueShare> getAllIssueShareCreatedByUser(ApplicationUser user) {
        ArrayList<IssueShare> result = new ArrayList<IssueShare>();
        IssueShare[] foundResult = (IssueShare[])this.activeObjects.find(IssueShare.class, Query.select().alias(IssueShare.class, "issueShare").alias(Token.class, "token").join(Token.class, "token.ID = issueShare.TOKEN_ID").where("token.USER_KEY = ?", new Object[]{user.getKey()}));
        if (foundResult.length > 0) {
            result.addAll(Arrays.asList(foundResult));
        }
        return result;
    }

    public void deleteIssueShare(IssueShare issueShare) {
        List<DisplayField> displayFields = this.displayFieldManager.findDisplayFieldsByShareId(issueShare.getID(), "issue");
        for (DisplayField displayField : displayFields) {
            this.activeObjects.delete(new RawEntity[]{displayField});
        }
        Token token = issueShare.getToken();
        this.activeObjects.delete(new RawEntity[]{issueShare});
        this.activeObjects.delete(new RawEntity[]{token});
    }
}

