/*
 * Decompiled with CFR 0.152.
 */
package aptis.plugins.shareYourJira.sharedContainer;

import aptis.plugins.shareYourJira.sharedContainer.IssueAutomaticShare;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.issue.Issue;
import java.util.UUID;
import javax.annotation.Nullable;
import net.java.ao.DBParam;
import net.java.ao.Query;

public class IssueAutomaticShareManager {
    private final ActiveObjects activeObjects;

    public IssueAutomaticShareManager(ActiveObjects activeObjects) {
        this.activeObjects = activeObjects;
    }

    public IssueAutomaticShare createIssueShare(Issue issue) {
        IssueAutomaticShare share = this.findByIssueId(issue.getId());
        if (share != null) {
            return share;
        }
        String token = UUID.randomUUID().toString();
        IssueAutomaticShare issueShare = (IssueAutomaticShare)this.activeObjects.create(IssueAutomaticShare.class, new DBParam[]{new DBParam("ISSUE_ID", (Object)issue.getId()), new DBParam("TOKEN", (Object)token), new DBParam("ACTIVE", (Object)true)});
        issueShare.save();
        return issueShare;
    }

    @Nullable
    public IssueAutomaticShare findByIssueId(Long issueId) {
        IssueAutomaticShare[] dataResult = (IssueAutomaticShare[])this.activeObjects.find(IssueAutomaticShare.class, Query.select().where("ISSUE_ID = ?", new Object[]{issueId}));
        if (dataResult.length == 0) {
            return null;
        }
        return dataResult[0];
    }
}

