/*
 * Decompiled with CFR 0.152.
 */
package aptis.plugins.shareYourJira.sharedContainer;

import aptis.plugins.shareYourJira.common.PasswordHashConverter;
import aptis.plugins.shareYourJira.filter.CreateShareLinkRequest;
import aptis.plugins.shareYourJira.sharedContainer.DisplayField;
import aptis.plugins.shareYourJira.sharedContainer.DisplayFieldManager;
import aptis.plugins.shareYourJira.sharedContainer.FilterShare;
import aptis.plugins.shareYourJira.sharedContainer.Token;
import aptis.plugins.shareYourJira.sharedContainer.TokenManager;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.user.ApplicationUser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;

public class FilterShareManager {
    private final ActiveObjects activeObjects;
    private final TokenManager tokenManager;
    private final DisplayFieldManager displayFieldManager;

    public FilterShareManager(ActiveObjects activeObjects, TokenManager tokenManager, DisplayFieldManager displayFieldManager) {
        this.activeObjects = activeObjects;
        this.tokenManager = tokenManager;
        this.displayFieldManager = displayFieldManager;
    }

    public FilterShare createFilterShare(ApplicationUser user, SearchRequest filter, CreateShareLinkRequest config) throws Exception {
        PasswordHashConverter passwordHashConverter = new PasswordHashConverter();
        Token token = this.tokenManager.createToken(user);
        FilterShare filterShare = (FilterShare)this.activeObjects.create(FilterShare.class, new DBParam[]{new DBParam("ACTIVE", (Object)true), new DBParam("FILTER_ID", (Object)filter.getId()), new DBParam("TOKEN_ID", (Object)token.getID()), new DBParam("VALID_PERIOD_FROM", (Object)config.getValidPeriodFrom()), new DBParam("VALID_PERIOD_TO", (Object)config.getValidPeriodTo()), new DBParam("PASSWORD_HASH", config.getPassword() == null ? null : passwordHashConverter.hashPassword(config.getPassword().toCharArray())), new DBParam("IPS_LOCK", (Object)config.getIPsLock()), new DBParam("NOTE", (Object)config.getNote()), new DBParam("ONLY_LOGGED_IN_USER", (Object)config.getOnlyLoggedInUser())});
        filterShare.save();
        if (config.getDisplayingFields() != null) {
            for (String displayFieldId : config.getDisplayingFields()) {
                this.displayFieldManager.createDisplayField(filterShare, displayFieldId);
            }
        }
        return filterShare;
    }

    public FilterShare findFilterShareById(int filterShareId) {
        FilterShare[] dataResult = (FilterShare[])this.activeObjects.find(FilterShare.class, Query.select().where("ID = ?", new Object[]{filterShareId}));
        if (dataResult.length == 0) {
            return null;
        }
        return dataResult[0];
    }

    public List<FilterShare> getAllFilterShares() {
        ArrayList<FilterShare> result = new ArrayList<FilterShare>();
        FilterShare[] foundResult = (FilterShare[])this.activeObjects.find(FilterShare.class);
        if (foundResult.length > 0) {
            result.addAll(Arrays.asList(foundResult));
        }
        return result;
    }

    public List<FilterShare> getAllFilterShareForFilter(SearchRequest filter) {
        ArrayList<FilterShare> result = new ArrayList<FilterShare>();
        FilterShare[] foundResult = (FilterShare[])this.activeObjects.find(FilterShare.class, Query.select().alias(FilterShare.class, "filterShare").where("filterShare.FILTER_ID = ?", new Object[]{filter.getId()}).order("filterShare.ID DESC"));
        if (foundResult.length > 0) {
            result.addAll(Arrays.asList(foundResult));
        }
        return result;
    }

    public List<FilterShare> getAllFilterShareCreatedByUser(ApplicationUser user) {
        ArrayList<FilterShare> result = new ArrayList<FilterShare>();
        FilterShare[] foundResult = (FilterShare[])this.activeObjects.find(FilterShare.class, Query.select().alias(FilterShare.class, "filterShare").alias(Token.class, "token").join(Token.class, "token.ID = filterShare.TOKEN_ID").where("token.USER_KEY = ?", new Object[]{user.getKey()}));
        if (foundResult.length > 0) {
            result.addAll(Arrays.asList(foundResult));
        }
        return result;
    }

    public void deleteFilterShare(FilterShare filterShare) {
        List<DisplayField> displayFields = this.displayFieldManager.findDisplayFieldsByShareId(filterShare.getID(), "filter");
        for (DisplayField displayField : displayFields) {
            this.activeObjects.delete(new RawEntity[]{displayField});
        }
        Token token = filterShare.getToken();
        this.activeObjects.delete(new RawEntity[]{filterShare});
        this.activeObjects.delete(new RawEntity[]{token});
    }
}

