/*
 * Decompiled with CFR 0.152.
 */
package aptis.plugins.shareYourJira.sharedContainer;

import aptis.plugins.shareYourJira.sharedContainer.AutomaticShareItem;
import aptis.plugins.shareYourJira.sharedContainer.DisplayField;
import aptis.plugins.shareYourJira.sharedContainer.FilterShare;
import aptis.plugins.shareYourJira.sharedContainer.IssueShare;
import aptis.plugins.shareYourJira.sharedContainer.ShareTemplate;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayout;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutItem;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.user.ApplicationUser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;

public class DisplayFieldManager {
    private final ActiveObjects activeObjects;
    public static final String SHARE_TYPE_ISSUE = "issue";
    public static final String SHARE_TYPE_FILTER = "filter";
    public static final String SHARE_TYPE_TEMPLATE = "template";

    public DisplayFieldManager(ActiveObjects activeObjects) {
        this.activeObjects = activeObjects;
    }

    public static List<String> getDefaultDisplayingIssueFieldIds() {
        ArrayList<String> defaultDisplayingFieldIds = new ArrayList<String>();
        defaultDisplayingFieldIds.add("updated");
        defaultDisplayingFieldIds.add("reporter");
        defaultDisplayingFieldIds.add("assignee");
        defaultDisplayingFieldIds.add("description");
        defaultDisplayingFieldIds.add("summary");
        defaultDisplayingFieldIds.add("created");
        defaultDisplayingFieldIds.add("project");
        defaultDisplayingFieldIds.add("status");
        return defaultDisplayingFieldIds;
    }

    public static List<String> getDisplayingFieldIdsByFilter(SearchRequest filter, ApplicationUser user) {
        try {
            if (user == null) {
                return new ArrayList<String>();
            }
            ColumnLayout columnLayout = ComponentAccessor.getColumnLayoutManager().getColumnLayout(user, filter);
            List columns = columnLayout.getAllVisibleColumnLayoutItems(user);
            ArrayList<String> result = new ArrayList<String>();
            for (ColumnLayoutItem item : columns) {
                result.add(item.getId());
            }
            return result;
        }
        catch (Exception exception) {
            return new ArrayList<String>();
        }
    }

    public DisplayField createDisplayField(IssueShare issueShare, String displayFieldId) throws Exception {
        DisplayField displayField = (DisplayField)this.activeObjects.create(DisplayField.class, new DBParam[]{new DBParam("SHARE_ID", (Object)issueShare.getID()), new DBParam("SHARE_TYPE", (Object)SHARE_TYPE_ISSUE), new DBParam("FIELD_ID", (Object)displayFieldId)});
        displayField.save();
        return displayField;
    }

    public List<DisplayField> findDisplayFieldsByShareId(int shareId, String shareType) {
        ArrayList<DisplayField> result = new ArrayList<DisplayField>();
        DisplayField[] dataResult = (DisplayField[])this.activeObjects.find(DisplayField.class, Query.select().where("SHARE_ID = ? AND SHARE_TYPE= ?", new Object[]{shareId, shareType}));
        if (dataResult.length > 0) {
            result.addAll(Arrays.asList(dataResult));
        }
        return result;
    }

    public void updateDisplayFields(IssueShare issueShare, List<String> newDisplayFields) throws Exception {
        for (DisplayField displayField : this.findDisplayFieldsByShareId(issueShare.getID(), SHARE_TYPE_ISSUE)) {
            if (newDisplayFields.contains(displayField.getFieldId())) continue;
            this.activeObjects.delete(new RawEntity[]{displayField});
        }
        ArrayList<String> existingDisplayFields = this.getListOfDisplayFieldIds(issueShare);
        for (String displayFieldId : newDisplayFields) {
            if (existingDisplayFields.contains(displayFieldId)) continue;
            this.createDisplayField(issueShare, displayFieldId);
        }
    }

    public ArrayList<String> getListOfDisplayFieldIds(IssueShare issueShare) {
        if (issueShare instanceof AutomaticShareItem) {
            return new ArrayList<String>(this.getListOfDisplayFieldIds((AutomaticShareItem)issueShare));
        }
        ArrayList<String> displayFields = new ArrayList<String>();
        for (DisplayField displayField : this.findDisplayFieldsByShareId(issueShare.getID(), SHARE_TYPE_ISSUE)) {
            displayFields.add(displayField.getFieldId());
        }
        return displayFields;
    }

    public List<String> getListOfDisplayFieldIds(AutomaticShareItem issueShare) {
        return issueShare.getShareFields();
    }

    public DisplayField createDisplayField(FilterShare filterShare, String displayFieldId) throws Exception {
        DisplayField displayField = (DisplayField)this.activeObjects.create(DisplayField.class, new DBParam[]{new DBParam("SHARE_ID", (Object)filterShare.getID()), new DBParam("SHARE_TYPE", (Object)SHARE_TYPE_FILTER), new DBParam("FIELD_ID", (Object)displayFieldId)});
        displayField.save();
        return displayField;
    }

    public void updateDisplayFields(FilterShare filterShare, List<String> newDisplayFields) throws Exception {
        List<String> existingDisplayFields = this.getListOfDisplayFieldIds(filterShare);
        if (!existingDisplayFields.equals(newDisplayFields)) {
            for (DisplayField displayField : this.findDisplayFieldsByShareId(filterShare.getID(), SHARE_TYPE_FILTER)) {
                this.activeObjects.delete(new RawEntity[]{displayField});
            }
            for (String displayFieldId : newDisplayFields) {
                this.createDisplayField(filterShare, displayFieldId);
            }
        }
    }

    public List<String> getListOfDisplayFieldIds(FilterShare filterShare) {
        ArrayList<String> displayFields = new ArrayList<String>();
        for (DisplayField displayField : this.findDisplayFieldsByShareId(filterShare.getID(), SHARE_TYPE_FILTER)) {
            displayFields.add(displayField.getFieldId());
        }
        return displayFields;
    }

    public DisplayField createDisplayField(ShareTemplate shareTemplate, String displayFieldId) throws Exception {
        DisplayField displayField = (DisplayField)this.activeObjects.create(DisplayField.class, new DBParam[]{new DBParam("SHARE_ID", (Object)shareTemplate.getID()), new DBParam("SHARE_TYPE", (Object)SHARE_TYPE_TEMPLATE), new DBParam("FIELD_ID", (Object)displayFieldId)});
        displayField.save();
        return displayField;
    }

    public List<String> getListOfDisplayFieldIds(ShareTemplate shareTemplate) {
        ArrayList<String> displayFields = new ArrayList<String>();
        for (DisplayField displayField : this.findDisplayFieldsByShareId(shareTemplate.getID(), SHARE_TYPE_TEMPLATE)) {
            displayFields.add(displayField.getFieldId());
        }
        return displayFields;
    }

    public List<DisplayField> findDisplayFieldsByShareType(String shareType) {
        ArrayList<DisplayField> result = new ArrayList<DisplayField>();
        DisplayField[] dataResult = (DisplayField[])this.activeObjects.find(DisplayField.class, Query.select().where("SHARE_TYPE= ?", new Object[]{shareType}));
        if (dataResult.length > 0) {
            result.addAll(Arrays.asList(dataResult));
        }
        return result;
    }
}

