/*
 * Decompiled with CFR 0.152.
 */
package aptis.plugins.shareYourJira.shareTemplate;

import aptis.plugins.common.ExceptionWithoutTechnicalInformation;
import aptis.plugins.common.PluginLicenseValidator;
import aptis.plugins.shareYourJira.shareTemplate.ShareTemplateRequest;
import aptis.plugins.shareYourJira.shareTemplate.ShareTemplateResponse;
import aptis.plugins.shareYourJira.sharedContainer.DisplayFieldManager;
import aptis.plugins.shareYourJira.sharedContainer.ShareTemplate;
import aptis.plugins.shareYourJira.sharedContainer.ShareTemplateManager;
import aptis.plugins.shareYourJira.sharedContainer.TokenManager;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.upm.api.license.PluginLicenseManager;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/shareTemplate")
public class ShareTemplateRestService {
    private final ActiveObjects activeObjects;
    private final I18nResolver i18nResolver;
    private final PluginLicenseManager pluginLicenseManager;

    public ShareTemplateRestService(ActiveObjects activeObjects, I18nResolver i18nResolver, PluginLicenseManager pluginLicenseManager) {
        this.activeObjects = activeObjects;
        this.i18nResolver = i18nResolver;
        this.pluginLicenseManager = pluginLicenseManager;
    }

    @GET
    @Produces(value={"application/json"})
    public Response get(@Context HttpServletRequest request) {
        try {
            int shareTemplateId = Integer.parseInt(request.getParameter("shareTemplateId"));
            if (shareTemplateId <= 0) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("rest.common.missing.required.param", (Serializable[])new String[]{"shareTemplateId"}));
            }
            PluginLicenseValidator pluginLicenseValidator = new PluginLicenseValidator(this.pluginLicenseManager);
            if (!pluginLicenseValidator.hasValidLicense()) {
                throw new ExceptionWithoutTechnicalInformation(pluginLicenseValidator.getLocalizedErrorMessage(request.getLocale()));
            }
            JiraAuthenticationContext jiraAuthenticationContext = ComponentAccessor.getJiraAuthenticationContext();
            if (!jiraAuthenticationContext.isLoggedInUser()) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            TokenManager tokenManager = new TokenManager(this.activeObjects);
            DisplayFieldManager displayFieldManager = new DisplayFieldManager(this.activeObjects);
            ShareTemplateManager shareTemplateManager = new ShareTemplateManager(this.activeObjects, displayFieldManager);
            ShareTemplateResponse response = shareTemplateManager.createGetResponse(shareTemplateId);
            return Response.ok((Object)response).build();
        }
        catch (Throwable exception) {
            return Response.serverError().entity((Object)exception.getLocalizedMessage()).build();
        }
    }

    @POST
    @Produces(value={"application/json"})
    public Response post(ShareTemplateRequest config, @Context HttpServletRequest request) {
        try {
            PluginLicenseValidator pluginLicenseValidator = new PluginLicenseValidator(this.pluginLicenseManager);
            if (!pluginLicenseValidator.hasValidLicense()) {
                throw new ExceptionWithoutTechnicalInformation(pluginLicenseValidator.getLocalizedErrorMessage(request.getLocale()));
            }
            JiraAuthenticationContext jiraAuthenticationContext = ComponentAccessor.getJiraAuthenticationContext();
            if (!jiraAuthenticationContext.isLoggedInUser()) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            ApplicationUser user = jiraAuthenticationContext.getLoggedInUser();
            TokenManager tokenManager = new TokenManager(this.activeObjects);
            DisplayFieldManager displayFieldManager = new DisplayFieldManager(this.activeObjects);
            ShareTemplateManager shareTemplateManager = new ShareTemplateManager(this.activeObjects, displayFieldManager);
            ShareTemplate shareTemplate = shareTemplateManager.createShareTemplate(user, config.getName(), config.getDisplayingFields());
            ShareTemplateResponse response = shareTemplateManager.createPostResponse(shareTemplate);
            return Response.ok((Object)response).build();
        }
        catch (Throwable exception) {
            return Response.serverError().entity((Object)exception.getLocalizedMessage()).build();
        }
    }

    @DELETE
    @Produces(value={"application/json"})
    public Response delete(@Context HttpServletRequest request) {
        try {
            int shareTemplateId = Integer.parseInt(request.getParameter("shareTemplateId"));
            JiraAuthenticationContext jiraAuthenticationContext = ComponentAccessor.getJiraAuthenticationContext();
            if (!jiraAuthenticationContext.isLoggedInUser()) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            TokenManager tokenManager = new TokenManager(this.activeObjects);
            DisplayFieldManager displayFieldManager = new DisplayFieldManager(this.activeObjects);
            ShareTemplateManager shareTemplateManager = new ShareTemplateManager(this.activeObjects, displayFieldManager);
            ShareTemplate shareTemplate = shareTemplateManager.findShareTemplateById(shareTemplateId);
            if (shareTemplate == null) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("aptis-syj-template-not-found", (Serializable[])new String[]{String.valueOf(shareTemplateId)}));
            }
            shareTemplateManager.deleteShareTemplate(shareTemplate);
            return Response.ok().build();
        }
        catch (Throwable exception) {
            return Response.serverError().entity((Object)exception.getLocalizedMessage()).build();
        }
    }
}

