/*
 * Decompiled with CFR 0.152.
 */
package aptis.plugins.shareYourJira.setting;

import aptis.plugins.shareYourJira.setting.GlobalSetting;
import aptis.plugins.shareYourJira.setting.ProjectSetting;
import com.atlassian.jira.component.ComponentAccessor;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;

public class SettingProvider {
    public String getMailTemplate(ProjectSetting projectSettings, GlobalSetting globalSettings) {
        String template = "";
        if (projectSettings != null && projectSettings.isCustomize() != null && projectSettings.isCustomize().booleanValue()) {
            if (projectSettings.getEmailTemplateVariant().equals("custom")) {
                template = projectSettings.getCustomEmailTemplate();
            }
        } else if (globalSettings != null) {
            if (globalSettings.getEmailTemplateVariant().equals("custom")) {
                template = globalSettings.getCustomEmailTemplate();
            }
        }
        if (template == null || template.equals("")) {
            try {
                template = this.getDefaultEmailTemplate();
            }
            catch (IOException exception) {
                return "";
            }
        }
        return template;
    }

    public String getEmailSystem(ProjectSetting projectSettings, GlobalSetting globalSettings) {
        String mailSystem = "";
        if (projectSettings != null && projectSettings.isCustomize() != null && projectSettings.isCustomize().booleanValue()) {
            mailSystem = projectSettings.getEmailSystem();
        } else if (globalSettings != null) {
            mailSystem = globalSettings.getEmailSystem();
        }
        if (mailSystem == null || mailSystem.equals("")) {
            mailSystem = "shareYourJira";
        }
        return mailSystem;
    }

    public String getIssueTemplate(ProjectSetting projectSettings, GlobalSetting globalSettings) {
        String template = "";
        if (projectSettings != null && projectSettings.isCustomize().booleanValue()) {
            if (projectSettings.getIssueTemplateVariant().equals("custom")) {
                template = projectSettings.getCustomIssueTemplate();
            }
        } else if (globalSettings != null) {
            if (globalSettings.getIssueTemplateVariant().equals("custom")) {
                template = globalSettings.getCustomIssueTemplate();
            }
        }
        return template;
    }

    public String getTemplateVariant(ProjectSetting projectSettings, GlobalSetting globalSettings) {
        String templateVariant = "default";
        if (projectSettings != null && projectSettings.isCustomize().booleanValue()) {
            templateVariant = projectSettings.getIssueTemplateVariant();
        } else if (globalSettings != null) {
            templateVariant = globalSettings.getIssueTemplateVariant();
        }
        return templateVariant;
    }

    public String getDefaultIssueTemplate() throws IOException {
        return this.getTemplateContent("/templates/issue/sharedViewDocument.vm");
    }

    public String getDefaultEmailTemplate() throws IOException {
        return this.getTemplateContent("/templates/issue/shareMailTemplate.vm");
    }

    public String getTemplateContent(String template) throws IOException {
        InputStream templateInputStream = ComponentAccessor.getPluginAccessor().getPlugin("aptis.plugins.shareYourJira").getResourceAsStream(template);
        if (templateInputStream == null) {
            throw new IOException("Default-Email-Template  not found.");
        }
        return IOUtils.toString(templateInputStream, StandardCharsets.UTF_8);
    }
}

