/*
 * Decompiled with CFR 0.152.
 */
package aptis.plugins.shareYourJira.setting;

import aptis.plugins.common.ErrorDetailProvider;
import aptis.plugins.common.ExceptionWithoutTechnicalInformation;
import aptis.plugins.common.PluginLicenseValidator;
import aptis.plugins.shareYourJira.setting.ProjectPermissionManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ProjectSettingsServlet
extends HttpServlet {
    private final TemplateRenderer templateRenderer;
    private final I18nResolver i18nResolver;
    private final PluginLicenseManager pluginLicenseManager;
    private final ProjectRoleManager projectRoleManager;
    private final UserManager userManager;

    public ProjectSettingsServlet(TemplateRenderer templateRenderer, I18nResolver i18nResolver, PluginLicenseManager pluginLicenseManager, UserManager userManager) {
        this.templateRenderer = templateRenderer;
        this.i18nResolver = i18nResolver;
        this.pluginLicenseManager = pluginLicenseManager;
        this.userManager = userManager;
        this.projectRoleManager = (ProjectRoleManager)ComponentAccessor.getComponent(ProjectRoleManager.class);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Map context = ComponentAccessor.getVelocityParamFactory().getDefaultVelocityParams();
        try {
            PluginLicenseValidator pluginLicenseValidator = new PluginLicenseValidator(this.pluginLicenseManager);
            if (!pluginLicenseValidator.hasValidLicense()) {
                throw new ExceptionWithoutTechnicalInformation(pluginLicenseValidator.getLocalizedErrorMessage(request.getLocale()));
            }
            String projectId = request.getParameter("projectId");
            if (projectId == null || projectId.equals("")) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("rest.common.missing.required.param", (Serializable[])new String[]{"projectId"}));
            }
            Project project = ComponentAccessor.getProjectManager().getProjectObj(Long.valueOf(Long.parseLong(projectId)));
            if (project == null) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("project.not.found.page.title"));
            }
            UserProfile userProfile = this.userManager.getRemoteUser(request);
            if (userProfile == null || userProfile.getUserKey() == null) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("issue.operations.error.401"));
            }
            ProjectPermissionManager projectPermissionManager = new ProjectPermissionManager();
            ApplicationUser user = ComponentAccessor.getUserManager().getUserByKey(userProfile.getUserKey().getStringValue());
            if (!projectPermissionManager.isUserAdminInProject(user, project)) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("aptis-sjy-no-project-admin"));
            }
            context.put("project", project);
            context.put("allProjectRoles", this.projectRoleManager.getProjectRoles());
            context.put("jetiIsEnabled", ComponentAccessor.getPluginAccessor().isPluginEnabled("com.metainf.jira.plugin.emailissue"));
            this.templateRenderer.render("templates/setting/projectSettingsDocument.vm", context, (Writer)response.getWriter());
        }
        catch (Throwable exception) {
            context.put("errorDetailProvider", new ErrorDetailProvider(exception, request));
            context.put("exception", exception);
            this.templateRenderer.render("templates/errorDocument.vm", context, (Writer)response.getWriter());
        }
    }
}

