/*
 * Decompiled with CFR 0.152.
 */
package aptis.plugins.shareYourJira.setting;

import aptis.plugins.common.ExceptionWithoutTechnicalInformation;
import aptis.plugins.shareYourJira.setting.ProjectPermissionManager;
import aptis.plugins.shareYourJira.setting.ProjectSetting;
import aptis.plugins.shareYourJira.setting.ProjectSettingsManager;
import aptis.plugins.shareYourJira.setting.ProjectSettingsModel;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/projectSettings")
public class ProjectSettingsService {
    private final I18nResolver i18nResolver;
    private final UserManager userManager;
    private final ActiveObjects activeObjects;
    private final ProjectSettingsManager projectSettingsManager;

    public ProjectSettingsService(I18nResolver i18nResolver, UserManager userManager, ActiveObjects activeObjects) {
        this.i18nResolver = i18nResolver;
        this.userManager = userManager;
        this.activeObjects = activeObjects;
        this.projectSettingsManager = new ProjectSettingsManager(activeObjects);
    }

    @GET
    @Produces(value={"application/json"})
    public Response get(@Context HttpServletRequest request) {
        try {
            String projectId = request.getParameter("projectId");
            if (projectId == null || projectId.equals("")) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("rest.common.missing.required.param", (Serializable[])new String[]{"projectId"}));
            }
            Project project = ComponentAccessor.getProjectManager().getProjectObj(Long.valueOf(Long.parseLong(projectId)));
            if (project == null) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("project.not.found.page.title"));
            }
            UserProfile userProfile = this.userManager.getRemoteUser(request);
            if (userProfile == null || userProfile.getUserKey() == null) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("issue.operations.error.401"));
            }
            ProjectPermissionManager projectPermissionManager = new ProjectPermissionManager();
            ApplicationUser user = ComponentAccessor.getUserManager().getUserByKey(userProfile.getUserKey().getStringValue());
            if (!projectPermissionManager.isUserAdminInProject(user, project)) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("aptis-sjy-no-project-admin"));
            }
            ProjectSetting projectSettings = this.projectSettingsManager.findSetting(Long.parseLong(projectId));
            if (projectSettings == null) {
                return Response.status((int)404).build();
            }
            ProjectSettingsModel projectSettingsModel = new ProjectSettingsModel(projectSettings);
            Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().setDateFormat("yyyy-MM-dd").create();
            return Response.ok((Object)gson.toJson(projectSettingsModel)).build();
        }
        catch (Throwable exception) {
            return Response.serverError().entity((Object)exception.getLocalizedMessage()).build();
        }
    }

    @PUT
    @Produces(value={"application/json"})
    public Response put(ProjectSettingsModel newProjectSettings, @Context HttpServletRequest request) {
        try {
            if (newProjectSettings.getProjectId() == 0L) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("rest.common.missing.required.param", (Serializable[])new String[]{"projectId"}));
            }
            Project project = ComponentAccessor.getProjectManager().getProjectObj(newProjectSettings.getProjectId());
            if (project == null) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("project.not.found.page.title"));
            }
            UserProfile userProfile = this.userManager.getRemoteUser(request);
            if (userProfile == null || userProfile.getUserKey() == null) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("issue.operations.error.401"));
            }
            ProjectPermissionManager projectPermissionManager = new ProjectPermissionManager();
            ApplicationUser user = ComponentAccessor.getUserManager().getUserByKey(userProfile.getUserKey().getStringValue());
            if (!projectPermissionManager.isUserAdminInProject(user, project)) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("aptis-sjy-no-project-admin"));
            }
            ProjectSettingsManager projectSettingsManager = new ProjectSettingsManager(this.activeObjects);
            ProjectSetting currentProjectSetting = projectSettingsManager.findSetting(newProjectSettings.getProjectId());
            if (currentProjectSetting == null) {
                currentProjectSetting = projectSettingsManager.createProjectSetting(project, newProjectSettings);
            } else {
                currentProjectSetting = projectSettingsManager.setConfigurationValues(newProjectSettings, currentProjectSetting);
                currentProjectSetting.save();
            }
            Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().setDateFormat("yyyy-MM-dd").create();
            return Response.ok((Object)gson.toJson(new ProjectSettingsModel(currentProjectSetting))).build();
        }
        catch (Exception exception) {
            return Response.serverError().entity((Object)exception.getLocalizedMessage()).build();
        }
    }
}

