/*
 * Decompiled with CFR 0.152.
 */
package aptis.plugins.shareYourJira.setting;

import aptis.plugins.common.PasswordAuthentication;
import aptis.plugins.shareYourJira.setting.ProjectSetting;
import com.google.gson.Gson;
import com.google.gson.annotations.Expose;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import net.java.ao.EntityManager;
import net.java.ao.RawEntity;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonIgnoreProperties(value={"hasPassword"})
public class ProjectSettingsModel
implements ProjectSetting {
    @JsonIgnore
    @Expose(serialize=true)
    private boolean hasPassword;
    @Expose(serialize=true)
    private Long projectId;
    @Expose(serialize=true)
    private Boolean automaticShareActive;
    @Expose(serialize=true)
    private String automaticShareUserKey;
    @Expose(serialize=true)
    private Boolean customize;
    @Expose(serialize=true)
    private List<String> shareFields;
    @Expose(serialize=true)
    private List<String> shareAllowedProjectRoleIds;
    @Expose(serialize=true)
    private String emailSystem;
    @Expose(serialize=true)
    private String jetiTemplate;
    @Expose(serialize=true)
    private String emailTemplateVariant;
    @Expose(serialize=true)
    private String customEmailTemplate;
    @Expose(serialize=true)
    private String issueTemplateVariant;
    @Expose(serialize=true)
    private String customIssueTemplate;
    @Expose(serialize=true)
    private Date validPeriodFrom;
    @Expose(serialize=true)
    private Date validPeriodTo;
    @Expose(serialize=true)
    private Boolean changePassword = false;
    @Expose(serialize=false)
    private String passwordHash;
    @Expose(serialize=true)
    private String IPsLock;
    @Expose(serialize=true)
    private Boolean onlyLoggedInUser;

    public ProjectSettingsModel() {
    }

    public ProjectSettingsModel(ProjectSetting projectSettings) {
        Gson gson = new Gson();
        this.hasPassword = projectSettings.getPasswordHash() != null;
        this.projectId = projectSettings.getProjectId();
        this.automaticShareActive = projectSettings.isAutomaticShareActive();
        this.automaticShareUserKey = projectSettings.getAutomaticShareUserKey();
        this.customize = projectSettings.isCustomize();
        this.emailSystem = projectSettings.getEmailSystem();
        this.jetiTemplate = projectSettings.getJetiTemplate();
        this.emailTemplateVariant = projectSettings.getEmailTemplateVariant();
        this.customEmailTemplate = projectSettings.getCustomEmailTemplate();
        this.issueTemplateVariant = projectSettings.getIssueTemplateVariant();
        this.customIssueTemplate = projectSettings.getCustomIssueTemplate();
        this.validPeriodFrom = projectSettings.getValidPeriodFrom();
        this.validPeriodTo = projectSettings.getValidPeriodTo();
        this.passwordHash = projectSettings.getPasswordHash();
        this.IPsLock = projectSettings.getIPsLock();
        this.onlyLoggedInUser = projectSettings.getOnlyLoggedInUser();
        if (projectSettings.getShareAllowedProjectRoleIds() != null && !projectSettings.getShareAllowedProjectRoleIds().equals("null")) {
            String[] shareAllowedProjectRoleIds = gson.fromJson(projectSettings.getShareAllowedProjectRoleIds(), String[].class);
            this.shareAllowedProjectRoleIds = Arrays.asList(shareAllowedProjectRoleIds);
        }
        if (projectSettings.getShareFields() != null && !projectSettings.getShareFields().equals("null")) {
            String[] shareFields = gson.fromJson(projectSettings.getShareFields(), String[].class);
            this.shareFields = shareFields == null ? null : Arrays.asList(shareFields);
        }
    }

    @Override
    public Long getProjectId() {
        return this.projectId;
    }

    @Override
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    @Override
    public Boolean isAutomaticShareActive() {
        return this.automaticShareActive;
    }

    @Override
    public void setAutomaticShareActive(Boolean automaticShareActive) {
        this.automaticShareActive = automaticShareActive;
    }

    @Override
    public String getAutomaticShareUserKey() {
        return this.automaticShareUserKey;
    }

    @Override
    public Boolean isCustomize() {
        return this.customize;
    }

    @Override
    public void setCustomize(Boolean customize) {
        this.customize = customize;
    }

    @Override
    public void setAutomaticShareUserKey(String automaticShareUserKey) {
        this.automaticShareUserKey = automaticShareUserKey;
    }

    @Override
    public String getShareAllowedProjectRoleIds() {
        Gson gson = new Gson();
        return gson.toJson(this.shareAllowedProjectRoleIds);
    }

    public List<String> getShareAllowedProjectRoleIdsList() {
        return this.shareAllowedProjectRoleIds;
    }

    @JsonProperty(value="shareAllowedProjectRoleIds")
    public void setShareAllowedProjectRoleIds(List<String> shareAllowedProjectRoleIds) {
        this.shareAllowedProjectRoleIds = shareAllowedProjectRoleIds;
    }

    @Override
    @JsonIgnore
    public void setShareAllowedProjectRoleIds(String json) {
    }

    @Override
    public String getShareFields() {
        Gson gson = new Gson();
        return gson.toJson(this.shareFields);
    }

    public List<String> getShareFieldsList() {
        return this.shareFields;
    }

    @Override
    @JsonIgnore
    public void setShareFields(String shareFields) {
    }

    @JsonProperty(value="shareFields")
    public void setShareFields(List<String> shareFields) {
        this.shareFields = shareFields;
    }

    @Override
    public String getEmailSystem() {
        return this.emailSystem;
    }

    @Override
    public void setEmailSystem(String emailSystem) {
        this.emailSystem = emailSystem;
    }

    @Override
    public String getJetiTemplate() {
        return this.jetiTemplate;
    }

    @Override
    public void setJetiTemplate(String jetiTemplate) {
        this.jetiTemplate = jetiTemplate;
    }

    @Override
    public String getEmailTemplateVariant() {
        return this.emailTemplateVariant;
    }

    @Override
    public void setEmailTemplateVariant(String emailTemplateVariant) {
        this.emailTemplateVariant = emailTemplateVariant;
    }

    @Override
    public String getCustomEmailTemplate() {
        return this.customEmailTemplate;
    }

    @Override
    public void setCustomEmailTemplate(String customEmailTemplate) {
        this.customEmailTemplate = customEmailTemplate;
    }

    @Override
    public String getIssueTemplateVariant() {
        return this.issueTemplateVariant;
    }

    @Override
    public void setIssueTemplateVariant(String issueTemplateVariant) {
        this.issueTemplateVariant = issueTemplateVariant;
    }

    @Override
    public String getCustomIssueTemplate() {
        return this.customIssueTemplate;
    }

    @Override
    public void setCustomIssueTemplate(String customIssueTemplate) {
        this.customIssueTemplate = customIssueTemplate;
    }

    @Override
    public Date getValidPeriodFrom() {
        return this.validPeriodFrom;
    }

    @Override
    public void setValidPeriodFrom(Date validPeriodFrom) {
        this.validPeriodFrom = validPeriodFrom;
    }

    @Override
    public Date getValidPeriodTo() {
        return this.validPeriodTo;
    }

    @Override
    public void setValidPeriodTo(Date validPeriodTo) {
        this.validPeriodTo = validPeriodTo;
    }

    @Override
    public String getPasswordHash() {
        return this.passwordHash;
    }

    @Override
    @JsonIgnore
    public void setPasswordHash(String passwordHash) {
        this.passwordHash = passwordHash;
    }

    @JsonProperty(value="password")
    public void setPassword(char[] password) {
        try {
            if (password != null) {
                this.setChangePassword(true);
                this.passwordHash = password.length == 0 ? null : new PasswordAuthentication(5).hash(password);
            }
        }
        catch (Exception exeption) {
            this.passwordHash = null;
        }
    }

    public void setChangePassword(Boolean changePassword) {
        this.changePassword = changePassword;
    }

    public Boolean isChangePassword() {
        return this.changePassword;
    }

    @Override
    public String getIPsLock() {
        return this.IPsLock;
    }

    @Override
    public void setIPsLock(String ipsLock) {
        this.IPsLock = ipsLock;
    }

    @Override
    public Boolean getOnlyLoggedInUser() {
        return this.onlyLoggedInUser;
    }

    @Override
    public void setOnlyLoggedInUser(Boolean onlyLoggedInUser) {
        this.onlyLoggedInUser = onlyLoggedInUser;
    }

    public int getID() {
        return 0;
    }

    public void init() {
    }

    public void save() {
    }

    public EntityManager getEntityManager() {
        return null;
    }

    public <X extends RawEntity<Integer>> Class<X> getEntityType() {
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }
}

