/*
 * Decompiled with CFR 0.152.
 */
package aptis.plugins.shareYourJira.setting;

import aptis.plugins.shareYourJira.setting.ProjectSetting;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.project.Project;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.java.ao.DBParam;
import net.java.ao.Query;

public class ProjectSettingsManager {
    private final ActiveObjects activeObjects;

    public ProjectSettingsManager(ActiveObjects activeObjects) {
        this.activeObjects = activeObjects;
    }

    public ProjectSetting createProjectSetting(Project project, ProjectSetting newSettings) {
        ProjectSetting currentSettings = this.findSetting(project.getId());
        if (currentSettings != null) {
            return currentSettings;
        }
        currentSettings = (ProjectSetting)this.activeObjects.create(ProjectSetting.class, new DBParam[]{new DBParam("PROJECT_ID", (Object)project.getId()), new DBParam("AUTOMATIC_SHARE_ACTIVE", (Object)false)});
        currentSettings = this.setConfigurationValues(newSettings, currentSettings);
        currentSettings.save();
        return currentSettings;
    }

    public ProjectSetting createEmptyProjectSetting(Project project) {
        ProjectSetting currentSettings = this.findSetting(project.getId());
        if (currentSettings != null) {
            return currentSettings;
        }
        currentSettings = (ProjectSetting)this.activeObjects.create(ProjectSetting.class, new DBParam[]{new DBParam("PROJECT_ID", (Object)project.getId()), new DBParam("AUTOMATIC_SHARE_ACTIVE", (Object)false)});
        currentSettings.save();
        return currentSettings;
    }

    @Nullable
    public ProjectSetting findSetting(Long projectId) {
        ProjectSetting[] dataResult = (ProjectSetting[])this.activeObjects.find(ProjectSetting.class, Query.select().where("PROJECT_ID = ?", new Object[]{projectId}));
        if (dataResult.length == 0) {
            return null;
        }
        return dataResult[0];
    }

    public static List<String> getShareAllowedProjectRoleIdsFromJson(@Nullable ProjectSetting projectSettings) {
        if (projectSettings == null) {
            return new ArrayList<String>();
        }
        Gson gson = new Gson();
        String allowedProjectRoleIdsString = projectSettings.getShareAllowedProjectRoleIds();
        if (allowedProjectRoleIdsString == null || allowedProjectRoleIdsString.equals("null")) {
            return new ArrayList<String>();
        }
        String[] shareAllowedProjectRoleIds = gson.fromJson(allowedProjectRoleIdsString, String[].class);
        return Arrays.asList(shareAllowedProjectRoleIds);
    }

    public static List<String> getShareFieldsFromJson(@Nullable ProjectSetting projectSettings) {
        if (projectSettings == null) {
            return new ArrayList<String>();
        }
        Gson gson = new Gson();
        String[] shareFields = gson.fromJson(projectSettings.getShareFields(), String[].class);
        return Arrays.asList(shareFields);
    }

    public ProjectSetting setConfigurationValues(ProjectSetting newProjectSettings, ProjectSetting currentProjectSettings) {
        if (newProjectSettings.getShareAllowedProjectRoleIds() != null) {
            currentProjectSettings.setShareAllowedProjectRoleIds(newProjectSettings.getShareAllowedProjectRoleIds());
        }
        if (newProjectSettings.getShareFields() != null) {
            currentProjectSettings.setShareFields(newProjectSettings.getShareFields());
        }
        if (newProjectSettings.getJetiTemplate() != null) {
            currentProjectSettings.setJetiTemplate(newProjectSettings.getJetiTemplate());
        }
        if (newProjectSettings.getCustomEmailTemplate() != null) {
            currentProjectSettings.setCustomEmailTemplate(newProjectSettings.getCustomEmailTemplate());
        }
        if (newProjectSettings.isAutomaticShareActive() != null) {
            currentProjectSettings.setAutomaticShareActive(newProjectSettings.isAutomaticShareActive());
        }
        if (newProjectSettings.getAutomaticShareUserKey() != null) {
            currentProjectSettings.setAutomaticShareUserKey(newProjectSettings.getAutomaticShareUserKey());
        }
        if (newProjectSettings.getValidPeriodFrom() != null) {
            currentProjectSettings.setValidPeriodFrom(newProjectSettings.getValidPeriodFrom());
        }
        if (newProjectSettings.getValidPeriodTo() != null) {
            currentProjectSettings.setValidPeriodTo(newProjectSettings.getValidPeriodTo());
        }
        if (newProjectSettings.getPasswordHash() != null) {
            currentProjectSettings.setPasswordHash(newProjectSettings.getPasswordHash());
        }
        if (newProjectSettings.getIPsLock() != null) {
            currentProjectSettings.setIPsLock(newProjectSettings.getIPsLock());
        }
        if (newProjectSettings.getOnlyLoggedInUser() != null) {
            currentProjectSettings.setOnlyLoggedInUser(newProjectSettings.getOnlyLoggedInUser());
        }
        if (newProjectSettings.isCustomize() != null) {
            currentProjectSettings.setCustomize(newProjectSettings.isCustomize());
        }
        if (newProjectSettings.getEmailTemplateVariant() != null) {
            currentProjectSettings.setEmailTemplateVariant(newProjectSettings.getEmailTemplateVariant());
        }
        if (newProjectSettings.getEmailSystem() != null) {
            currentProjectSettings.setEmailSystem(newProjectSettings.getEmailSystem());
        }
        if (newProjectSettings.getIssueTemplateVariant() != null) {
            currentProjectSettings.setIssueTemplateVariant(newProjectSettings.getIssueTemplateVariant());
        }
        if (newProjectSettings.getCustomIssueTemplate() != null) {
            currentProjectSettings.setCustomIssueTemplate(newProjectSettings.getCustomIssueTemplate());
        }
        return currentProjectSettings;
    }
}

