/*
 * Decompiled with CFR 0.152.
 */
package aptis.plugins.shareYourJira.setting;

import aptis.plugins.common.ErrorDetailProvider;
import aptis.plugins.common.ExceptionWithoutTechnicalInformation;
import aptis.plugins.common.PluginLicenseValidator;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.Map;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GlobalSettingsServlet
extends HttpServlet {
    private final TemplateRenderer templateRenderer;
    private final I18nResolver i18nResolver;
    private final PluginLicenseManager pluginLicenseManager;
    private final UserManager userManager;
    private final LoginUriProvider loginUriProvider;
    private final WebSudoManager webSudoManager;

    public GlobalSettingsServlet(TemplateRenderer templateRenderer, I18nResolver i18nResolver, PluginLicenseManager pluginLicenseManager, UserManager userManager, LoginUriProvider loginUriProvider, WebSudoManager webSudoManager) {
        this.templateRenderer = templateRenderer;
        this.i18nResolver = i18nResolver;
        this.pluginLicenseManager = pluginLicenseManager;
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.webSudoManager = webSudoManager;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        UserKey userKey = this.userManager.getRemoteUserKey(request);
        if (userKey == null) {
            this.redirectToLogin(request, response);
            return;
        }
        Map context = ComponentAccessor.getVelocityParamFactory().getDefaultVelocityParams();
        try {
            this.webSudoManager.willExecuteWebSudoRequest(request);
            PluginLicenseValidator pluginLicenseValidator = new PluginLicenseValidator(this.pluginLicenseManager);
            if (!pluginLicenseValidator.hasValidLicense()) {
                throw new ExceptionWithoutTechnicalInformation(pluginLicenseValidator.getLocalizedErrorMessage(request.getLocale()));
            }
            if (!this.userManager.isSystemAdmin(userKey)) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("aptis-sjy-no-permission"));
            }
            context.put("jetiIsEnabled", ComponentAccessor.getPluginAccessor().isPluginEnabled("com.metainf.jira.plugin.emailissue"));
            context.put("title", this.i18nResolver.getText("aptis-syj-global-configuration-title"));
            this.templateRenderer.render("templates/setting/globalSettingsDocument.vm", context, (Writer)response.getWriter());
        }
        catch (WebSudoSessionException wes) {
            this.webSudoManager.enforceWebSudoProtection(request, response);
        }
        catch (Throwable exception) {
            context.put("errorDetailProvider", new ErrorDetailProvider(exception, request));
            context.put("exception", exception);
            this.templateRenderer.render("templates/errorDocument.vm", context, (Writer)response.getWriter());
        }
    }

    private void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }
}

