/*
 * Decompiled with CFR 0.152.
 */
package aptis.plugins.shareYourJira.rest;

import aptis.plugins.common.ExceptionWithoutTechnicalInformation;
import aptis.plugins.shareYourJira.setting.ProjectPermissionManager;
import aptis.plugins.shareYourJira.setting.ProjectSetting;
import aptis.plugins.shareYourJira.setting.ProjectSettingsManager;
import aptis.plugins.shareYourJira.sharedContainer.DisplayFieldManager;
import aptis.plugins.shareYourJira.sharedContainer.FilterShareManager;
import aptis.plugins.shareYourJira.sharedContainer.IssueShareManager;
import aptis.plugins.shareYourJira.sharedContainer.TokenManager;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/sharedCount")
public class SharedCountService {
    private final I18nResolver i18nResolver;
    private final IssueShareManager issueShareManager;
    private final FilterShareManager filterShareManager;
    private final ProjectSettingsManager projectSettingsManager;
    private final SearchRequestService searchRequestService;

    public SharedCountService(I18nResolver i18nResolver, ActiveObjects activeObjects, UserManager userManager, SearchRequestService searchRequestService) {
        this.i18nResolver = i18nResolver;
        this.projectSettingsManager = new ProjectSettingsManager(activeObjects);
        this.searchRequestService = searchRequestService;
        TokenManager tokenManager = new TokenManager(activeObjects);
        DisplayFieldManager displayFieldManager = new DisplayFieldManager(activeObjects);
        this.issueShareManager = new IssueShareManager(activeObjects, tokenManager, displayFieldManager);
        this.filterShareManager = new FilterShareManager(activeObjects, tokenManager, displayFieldManager);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/issue/{issueId}")
    public Response getShareIssueCount(@PathParam(value="issueId") Long issueId, @Context HttpServletRequest request) {
        try {
            if (issueId == null) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("rest.common.missing.required.param", (Serializable[])new String[]{"issueId"}));
            }
            JiraAuthenticationContext jiraAuthenticationContext = ComponentAccessor.getJiraAuthenticationContext();
            if (!jiraAuthenticationContext.isLoggedInUser()) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            ApplicationUser user = jiraAuthenticationContext.getLoggedInUser();
            MutableIssue issue = ComponentAccessor.getIssueManager().getIssueObject(issueId);
            if (issue == null) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("aptis-sjy-error-no-valid-link"));
            }
            ProjectSetting projectSettings = this.projectSettingsManager.findSetting(issue.getProjectId());
            ProjectPermissionManager projectPermissionManager = new ProjectPermissionManager();
            if (!projectPermissionManager.isUserInProjectRole(user, issue.getProjectObject(), ProjectSettingsManager.getShareAllowedProjectRoleIdsFromJson(projectSettings))) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("aptis-sjy-share-for-project-not-allowed"));
            }
            Integer sharedIssues = this.issueShareManager.getAllIssueShareForIssue((Issue)issue).size();
            return Response.ok((Object)sharedIssues).build();
        }
        catch (Throwable exception) {
            return Response.serverError().entity((Object)exception.getLocalizedMessage()).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/filter/{filterId}")
    public Response getShareFilterCount(@PathParam(value="filterId") Long filterId, @Context HttpServletRequest request) {
        try {
            if (filterId == null) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("rest.common.missing.required.param", (Serializable[])new String[]{"issueId"}));
            }
            JiraAuthenticationContext jiraAuthenticationContext = ComponentAccessor.getJiraAuthenticationContext();
            if (!jiraAuthenticationContext.isLoggedInUser()) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            ApplicationUser user = jiraAuthenticationContext.getLoggedInUser();
            JiraServiceContextImpl serviceContext = new JiraServiceContextImpl(user);
            SearchRequest filter = this.searchRequestService.getFilter((JiraServiceContext)serviceContext, filterId);
            if (filter == null) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("aptis-sjy-filter-not-found", (Serializable[])new String[]{filterId.toString()}));
            }
            Integer sharedfiltersCount = this.filterShareManager.getAllFilterShareForFilter(filter).size();
            return Response.ok((Object)sharedfiltersCount).build();
        }
        catch (Throwable exception) {
            return Response.serverError().entity((Object)exception.getLocalizedMessage()).build();
        }
    }
}

