/*
 * Decompiled with CFR 0.152.
 */
package aptis.plugins.shareYourJira.rest;

import aptis.plugins.shareYourJira.setting.GlobalSetting;
import aptis.plugins.shareYourJira.setting.GlobalSettingManager;
import aptis.plugins.shareYourJira.setting.GlobalSettingsModel;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.gson.Gson;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/globalConfiguration")
public class GlobalConfigurationService {
    private ActiveObjects activeObjects;
    private final I18nResolver i18nResolver;
    private JiraAuthenticationContext jiraAuthenticationContext;
    private GlobalPermissionManager globalPermissionManager;

    public GlobalConfigurationService(ActiveObjects activeObjects, I18nResolver i18nResolver) {
        this.activeObjects = activeObjects;
        this.i18nResolver = i18nResolver;
        this.jiraAuthenticationContext = ComponentAccessor.getJiraAuthenticationContext();
        this.globalPermissionManager = (GlobalPermissionManager)ComponentAccessor.getComponent(GlobalPermissionManager.class);
    }

    @PUT
    @Produces(value={"application/json"})
    public Response put(GlobalSettingsModel globalSettings, @Context HttpServletRequest request) {
        ApplicationUser loggedInUser = this.jiraAuthenticationContext.getLoggedInUser();
        boolean hasPermission = this.globalPermissionManager.hasPermission(GlobalPermissionKey.SYSTEM_ADMIN, loggedInUser);
        if (!hasPermission) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.i18nResolver.getText("aptis-sjy-no-permission")).build();
        }
        GlobalSettingManager globalSettingsManager = new GlobalSettingManager(this.activeObjects);
        GlobalSetting existingSettings = globalSettingsManager.findSetting();
        if (existingSettings == null) {
            existingSettings = globalSettingsManager.createGlobalSetting(globalSettings);
        } else {
            existingSettings = globalSettingsManager.setConfigurationValues(globalSettings, existingSettings);
            existingSettings.save();
        }
        Gson gson = new Gson();
        return Response.ok((Object)gson.toJson(new GlobalSettingsModel(existingSettings))).build();
    }

    @GET
    @Produces(value={"application/json"})
    public Response get() {
        ApplicationUser loggedInUser = this.jiraAuthenticationContext.getLoggedInUser();
        if (loggedInUser == null) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.i18nResolver.getText("epic-sum-up-login-required")).build();
        }
        GlobalSettingManager globalSettingManager = new GlobalSettingManager(this.activeObjects);
        GlobalSetting globalSetting = globalSettingManager.findSetting();
        if (globalSetting == null) {
            return Response.serverError().entity((Object)"no settings").build();
        }
        Gson gson = new Gson();
        return Response.ok((Object)gson.toJson(new GlobalSettingsModel(globalSetting))).build();
    }
}

