/*
 * Decompiled with CFR 0.152.
 */
package aptis.plugins.shareYourJira.rest;

import aptis.plugins.shareYourJira.setting.SettingProvider;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.gson.JsonObject;
import java.io.IOException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/defaultTemplates")
public class DefaultTemplateService {
    private final I18nResolver i18nResolver;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final SettingProvider settingProvider;

    public DefaultTemplateService(I18nResolver i18nResolver, JiraAuthenticationContext jiraAuthenticationContext, PluginAccessor pluginAccessor) {
        this.i18nResolver = i18nResolver;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.settingProvider = new SettingProvider();
    }

    @GET
    @Produces(value={"application/json"})
    public Response get() {
        ApplicationUser loggedInUser = this.jiraAuthenticationContext.getLoggedInUser();
        if (loggedInUser == null) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.i18nResolver.getText("epic-sum-up-login-required")).build();
        }
        try {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("defaultIssueTemplate", this.getDefaultIssueTemplate());
            jsonObject.addProperty("defaultMailTemplate", this.getDefaultMailTemplate());
            return Response.ok((Object)jsonObject.toString()).build();
        }
        catch (IOException exception) {
            return Response.serverError().entity((Object)exception.getLocalizedMessage()).build();
        }
    }

    private String getDefaultIssueTemplate() throws IOException {
        return this.settingProvider.getDefaultIssueTemplate();
    }

    private String getDefaultMailTemplate() throws IOException {
        return this.settingProvider.getDefaultEmailTemplate();
    }
}

