/*
 * Decompiled with CFR 0.152.
 */
package aptis.plugins.shareYourJira.issue;

import aptis.plugins.common.AOConverter;
import aptis.plugins.common.ErrorDetailProvider;
import aptis.plugins.common.ExceptionWithoutTechnicalInformation;
import aptis.plugins.common.FieldRenderer;
import aptis.plugins.common.PluginLicenseValidator;
import aptis.plugins.common.RequestDataProvider;
import aptis.plugins.shareYourJira.common.AttachmentManager;
import aptis.plugins.shareYourJira.common.CommentManager;
import aptis.plugins.shareYourJira.common.PasswordHashConverter;
import aptis.plugins.shareYourJira.common.ShowShareBaseValidator;
import aptis.plugins.shareYourJira.history.ShareHistoryManager;
import aptis.plugins.shareYourJira.setting.GlobalSetting;
import aptis.plugins.shareYourJira.setting.GlobalSettingManager;
import aptis.plugins.shareYourJira.setting.ProjectPermissionManager;
import aptis.plugins.shareYourJira.setting.ProjectSetting;
import aptis.plugins.shareYourJira.setting.ProjectSettingsManager;
import aptis.plugins.shareYourJira.setting.SettingProvider;
import aptis.plugins.shareYourJira.sharedContainer.AutomaticShareItem;
import aptis.plugins.shareYourJira.sharedContainer.DisplayFieldManager;
import aptis.plugins.shareYourJira.sharedContainer.IssueAutomaticShare;
import aptis.plugins.shareYourJira.sharedContainer.IssueAutomaticShareManager;
import aptis.plugins.shareYourJira.sharedContainer.IssueShare;
import aptis.plugins.shareYourJira.sharedContainer.IssueShareManager;
import aptis.plugins.shareYourJira.sharedContainer.TokenManager;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.bc.issue.properties.IssuePropertyService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ShowIssueServlet
extends HttpServlet {
    private TemplateRenderer templateRenderer;
    private final ApplicationProperties applicationProperties;
    private final I18nResolver i18nResolver;
    private final PluginLicenseManager pluginLicenseManager;
    private final DisplayFieldManager displayFieldManager;
    private final FieldRenderer fieldRenderer;
    private final IssueShareManager issueShareManager;
    private final ActiveObjects activeObjects;
    private final PermissionManager permissionManager;
    private final CommentManager commentManager;
    private final AttachmentManager attachmentManager;
    private final IssuePropertyService issuePropertyService;
    private final IssueAutomaticShareManager issueAutomaticShareManager;
    private final ProjectSettingsManager projectSettingsManager;
    private final GlobalSettingManager globalSettingsManager;
    private final SettingProvider settingProvider;

    public ShowIssueServlet(TemplateRenderer templateRenderer, ActiveObjects activeObjects, ApplicationProperties applicationProperties, I18nResolver i18nResolver, PluginLicenseManager pluginLicenseManager, DateTimeFormatterFactory dateTimeFormatterFactory, IssuePropertyService issuePropertyService) {
        this.templateRenderer = templateRenderer;
        this.applicationProperties = applicationProperties;
        this.i18nResolver = i18nResolver;
        this.pluginLicenseManager = pluginLicenseManager;
        this.displayFieldManager = new DisplayFieldManager(activeObjects);
        this.fieldRenderer = new FieldRenderer(this.i18nResolver, this.templateRenderer, dateTimeFormatterFactory);
        TokenManager tokenManager = new TokenManager(activeObjects);
        this.issueShareManager = new IssueShareManager(activeObjects, tokenManager, this.displayFieldManager);
        this.activeObjects = activeObjects;
        this.permissionManager = ComponentAccessor.getPermissionManager();
        this.commentManager = new CommentManager(i18nResolver);
        this.attachmentManager = new AttachmentManager(i18nResolver);
        this.issuePropertyService = issuePropertyService;
        this.issueAutomaticShareManager = new IssueAutomaticShareManager(this.activeObjects);
        this.projectSettingsManager = new ProjectSettingsManager(this.activeObjects);
        this.globalSettingsManager = new GlobalSettingManager(this.activeObjects);
        this.settingProvider = new SettingProvider();
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Map context = ComponentAccessor.getVelocityParamFactory().getDefaultVelocityParams();
        try {
            Long issueId;
            IssueAutomaticShare issueAutomaticShare;
            PluginLicenseValidator pluginLicenseValidator = new PluginLicenseValidator(this.pluginLicenseManager);
            if (!pluginLicenseValidator.hasValidLicense()) {
                throw new ExceptionWithoutTechnicalInformation(pluginLicenseValidator.getLocalizedErrorMessage(request.getLocale()));
            }
            if (request.getParameter("token") == null) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("rest.common.missing.required.param", (Serializable[])new String[]{"token"}));
            }
            if (request.getParameter("id") == null && request.getParameter("issueId") == null) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("rest.common.missing.required.param", (Serializable[])new String[]{"id"}));
            }
            String givenToken = request.getParameter("token");
            IssueShare issueShare = null;
            ApplicationUser userFromToken = null;
            MutableIssue issue = null;
            int shareId = 0;
            ProjectSetting projectSettings = null;
            if (request.getParameter("id") != null) {
                shareId = Integer.parseInt(request.getParameter("id"));
                issueShare = this.issueShareManager.findIssueShareById(shareId);
                if (issueShare == null) {
                    throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("aptis-sjy-error-no-valid-link"));
                }
                userFromToken = ComponentAccessor.getUserManager().getUserByKey(issueShare.getToken().getUserKey());
                if (userFromToken == null || !userFromToken.isActive()) {
                    throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("aptis-sjy-error-no-valid-link"));
                }
                issue = ComponentAccessor.getIssueManager().getIssueObject(Long.valueOf(issueShare.getIssueId()));
                if (issue == null) {
                    throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("aptis-sjy-error-no-valid-link"));
                }
                projectSettings = this.projectSettingsManager.findSetting(issue.getProjectId());
                ProjectPermissionManager projectPermissionManager = new ProjectPermissionManager();
                if (!projectPermissionManager.isUserInProjectRole(userFromToken, issue.getProjectObject(), ProjectSettingsManager.getShareAllowedProjectRoleIdsFromJson(projectSettings))) {
                    throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("aptis-sjy-error-no-valid-link"));
                }
                if (!this.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, (Issue)issue, userFromToken)) {
                    throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("aptis-sjy-error-no-valid-link"));
                }
            } else if (request.getParameter("issueId") != null && (issueAutomaticShare = this.issueAutomaticShareManager.findByIssueId(issueId = Long.valueOf(Long.parseLong(request.getParameter("issueId"))))) != null && issueAutomaticShare.isActive().booleanValue()) {
                shareId = issueAutomaticShare.getID();
                issue = ComponentAccessor.getIssueManager().getIssueObject(issueAutomaticShare.getIssueId());
                if (issue == null) {
                    throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("aptis-sjy-error-no-valid-link"));
                }
                projectSettings = this.projectSettingsManager.findSetting(issue.getProjectId());
                if (projectSettings != null && projectSettings.isAutomaticShareActive().booleanValue()) {
                    issueShare = new AutomaticShareItem(issueAutomaticShare, projectSettings);
                }
            }
            if (issueShare == null) {
                return;
            }
            ShowShareBaseValidator showShareBaseValidator = new ShowShareBaseValidator();
            if (!showShareBaseValidator.isShareItemValidForCall(issueShare, request)) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("aptis-sjy-error-no-valid-link"));
            }
            if (!givenToken.equals(issueShare.getToken().getToken())) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("aptis-sjy-error-no-valid-link"));
            }
            List<String> displayingFields = this.getDisplayingFields((Issue)issue, issueShare, context);
            List<String> commentVisibility = AOConverter.convertToStringArray(issueShare.getCommentVisibilityString());
            List<Comment> visibleComments = this.commentManager.getVisibleComments(this.commentManager.getCommentsByIssue((Issue)issue), commentVisibility, userFromToken);
            List<String> attachmentVisibility = AOConverter.convertToStringArray(issueShare.getAttachmentVisibilityString());
            List<Attachment> visibleAttachments = this.attachmentManager.getVisibleAttachments(this.attachmentManager.getAttachmentsByIssue((Issue)issue), attachmentVisibility);
            context.put("issue", issue);
            context.put("displayingFields", displayingFields);
            context.put("attachments", visibleAttachments);
            context.put("comments", visibleComments);
            context.put("fieldRenderer", this.fieldRenderer);
            context.put("baseUrl", this.applicationProperties.getString("jira.baseurl"));
            context.put("jiraTitle", ComponentAccessor.getApplicationProperties().getString("jira.title"));
            context.put("givenToken", givenToken);
            context.put("shareId", shareId);
            GlobalSetting globalSetting = this.globalSettingsManager.findSetting();
            String issueTemplateVariant = this.settingProvider.getTemplateVariant(projectSettings, globalSetting);
            String customIssueTemplate = this.settingProvider.getIssueTemplate(projectSettings, this.globalSettingsManager.findSetting());
            if (issueShare.getPasswordHash() == null || issueShare.getPasswordHash().equals("")) {
                this.renderIssueDocument(context, issueTemplateVariant, customIssueTemplate, response);
                this.countCall(issueShare, request);
            } else {
                char[] passwordEnteredByUser;
                char[] cArray = passwordEnteredByUser = request.getParameter("password") != null ? request.getParameter("password").toCharArray() : null;
                if (passwordEnteredByUser == null) {
                    this.templateRenderer.render("/templates/common/askForPasswordDocument.vm", context, (Writer)response.getWriter());
                } else {
                    PasswordHashConverter passwordHashConverter = new PasswordHashConverter();
                    if (passwordHashConverter.authenticate(passwordEnteredByUser, issueShare.getPasswordHash()).booleanValue()) {
                        this.renderIssueDocument(context, issueTemplateVariant, customIssueTemplate, response);
                        this.countCall(issueShare, request);
                    } else {
                        context.put("showWrongInputNotification", true);
                        this.templateRenderer.render("/templates/common/askForPasswordDocument.vm", context, (Writer)response.getWriter());
                    }
                }
            }
        }
        catch (Exception exception) {
            context.put("errorDetailProvider", new ErrorDetailProvider(exception, request));
            context.put("exception", exception);
            this.templateRenderer.render("/templates/errorDocumentForExternalUser.vm", context, (Writer)response.getWriter());
        }
    }

    private void renderIssueDocument(Map<String, Object> context, String issueTemplateVariant, String customIssueTemplate, HttpServletResponse response) throws Exception {
        if (issueTemplateVariant.equals("custom")) {
            response.getWriter().write(this.templateRenderer.renderFragment(customIssueTemplate, context));
        } else {
            this.templateRenderer.render("/templates/issue/sharedViewDocument.vm", context, (Writer)response.getWriter());
        }
    }

    private void countCall(IssueShare issueShare, HttpServletRequest request) {
        ShareHistoryManager shareHistoryManager = new ShareHistoryManager(this.activeObjects);
        JiraAuthenticationContext jiraAuthenticationContext = ComponentAccessor.getJiraAuthenticationContext();
        if (jiraAuthenticationContext.isLoggedInUser()) {
            shareHistoryManager.addIssueCalled(issueShare.getIssueId(), issueShare.getID(), jiraAuthenticationContext.getLoggedInUser());
        } else {
            shareHistoryManager.addIssueCalled(issueShare.getIssueId(), issueShare.getID(), RequestDataProvider.getClientIPAddress(request));
        }
    }

    private List<String> getDisplayingFields(Issue issue, IssueShare issueShare, Map<String, Object> context) {
        boolean hasProjectField;
        boolean hasDescriptionField;
        boolean hasSummaryField;
        ArrayList<String> displayingFields = this.displayFieldManager.getListOfDisplayFieldIds(issueShare);
        boolean hasKeyField = displayingFields.contains("issuekey");
        if (hasKeyField) {
            displayingFields.remove("issuekey");
        }
        if (hasSummaryField = displayingFields.contains("summary")) {
            displayingFields.remove("summary");
        }
        if (hasDescriptionField = displayingFields.contains("description")) {
            displayingFields.remove("description");
        }
        if (hasProjectField = displayingFields.contains("project")) {
            displayingFields.remove("project");
        }
        context.put("hasKeyField", hasKeyField);
        context.put("hasSummaryField", hasSummaryField);
        context.put("hasDescriptionField", hasDescriptionField);
        context.put("hasProjectField", hasProjectField);
        context.put("title", this.getTitle(issue, hasSummaryField));
        return displayingFields;
    }

    private String getTitle(Issue issue, Boolean hasSummaryField) {
        String title = "[" + issue.getKey() + "]";
        if (hasSummaryField.booleanValue()) {
            title = title + " " + issue.getSummary();
        }
        return title;
    }
}

