/*
 * Decompiled with CFR 0.152.
 */
package aptis.plugins.shareYourJira.issue;

import aptis.plugins.common.AOConverter;
import aptis.plugins.common.ExceptionWithoutTechnicalInformation;
import aptis.plugins.common.PluginLicenseValidator;
import aptis.plugins.shareYourJira.UrlBuilder;
import aptis.plugins.shareYourJira.common.EventManager;
import aptis.plugins.shareYourJira.common.PasswordHashConverter;
import aptis.plugins.shareYourJira.history.ShareHistoryItem;
import aptis.plugins.shareYourJira.history.ShareHistoryLogItemFormatter;
import aptis.plugins.shareYourJira.history.ShareHistoryManager;
import aptis.plugins.shareYourJira.issue.CreateShareLinkRequest;
import aptis.plugins.shareYourJira.issue.CreateShareLinkResponse;
import aptis.plugins.shareYourJira.issue.DeleteShareLinkRequest;
import aptis.plugins.shareYourJira.issue.EditShareLinkRequest;
import aptis.plugins.shareYourJira.setting.GlobalSetting;
import aptis.plugins.shareYourJira.setting.GlobalSettingManager;
import aptis.plugins.shareYourJira.setting.ProjectPermissionManager;
import aptis.plugins.shareYourJira.setting.ProjectSetting;
import aptis.plugins.shareYourJira.setting.ProjectSettingsManager;
import aptis.plugins.shareYourJira.setting.SettingProvider;
import aptis.plugins.shareYourJira.sharedContainer.DisplayFieldManager;
import aptis.plugins.shareYourJira.sharedContainer.IssueShare;
import aptis.plugins.shareYourJira.sharedContainer.IssueShareManager;
import aptis.plugins.shareYourJira.sharedContainer.TokenManager;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/issueShareLink")
public class ShareLinkRestService {
    private final ActiveObjects activeObjects;
    private final I18nResolver i18nResolver;
    private final PluginLicenseManager pluginLicenseManager;
    private final DateTimeFormatterFactory dateTimeFormatterFactory;
    private final ShareHistoryManager shareHistoryManager;
    private final ShareHistoryLogItemFormatter shareHistoryLogItemFormatter;
    private final UrlBuilder urlBuilder;
    private final TemplateRenderer templateRenderer;
    private final ProjectSettingsManager projectSettingsManager;
    private final GlobalSettingManager globalSettingManager;
    private final SettingProvider settingProvider;
    private final PermissionManager permissionManager;

    public ShareLinkRestService(ActiveObjects activeObjects, I18nResolver i18nResolver, PluginLicenseManager pluginLicenseManager, DateTimeFormatterFactory dateTimeFormatterFactory, TemplateRenderer templateRenderer) {
        this.activeObjects = activeObjects;
        this.i18nResolver = i18nResolver;
        this.pluginLicenseManager = pluginLicenseManager;
        this.dateTimeFormatterFactory = dateTimeFormatterFactory;
        this.shareHistoryManager = new ShareHistoryManager(activeObjects);
        this.shareHistoryLogItemFormatter = new ShareHistoryLogItemFormatter();
        this.urlBuilder = new UrlBuilder();
        this.templateRenderer = templateRenderer;
        this.projectSettingsManager = new ProjectSettingsManager(activeObjects);
        this.globalSettingManager = new GlobalSettingManager(activeObjects);
        this.settingProvider = new SettingProvider();
        this.permissionManager = ComponentAccessor.getPermissionManager();
    }

    @GET
    @Produces(value={"application/json"})
    public Response get(@Context HttpServletRequest request) throws Exception {
        try {
            String issueId = request.getParameter("issueId");
            if (issueId == null) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("rest.common.missing.required.param", (Serializable[])new String[]{"issueId"}));
            }
            PluginLicenseValidator pluginLicenseValidator = new PluginLicenseValidator(this.pluginLicenseManager);
            if (!pluginLicenseValidator.hasValidLicense()) {
                throw new ExceptionWithoutTechnicalInformation(pluginLicenseValidator.getLocalizedErrorMessage(request.getLocale()));
            }
            JiraAuthenticationContext jiraAuthenticationContext = ComponentAccessor.getJiraAuthenticationContext();
            if (!jiraAuthenticationContext.isLoggedInUser()) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            MutableIssue issue = ComponentAccessor.getIssueManager().getIssueObject(Long.valueOf(Long.parseLong(issueId)));
            if (issue == null) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("aptis-sjy-issue-not-found", (Serializable[])new String[]{issueId}));
            }
            if (!this.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, (Issue)issue, jiraAuthenticationContext.getLoggedInUser())) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("aptis-sjy-error-no-valid-link"));
            }
            TokenManager tokenManager = new TokenManager(this.activeObjects);
            DisplayFieldManager displayFieldManager = new DisplayFieldManager(this.activeObjects);
            IssueShareManager issueShareManager = new IssueShareManager(this.activeObjects, tokenManager, displayFieldManager);
            List<IssueShare> shareList = issueShareManager.getAllIssueShareForIssue((Issue)issue);
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            Gson gson = new Gson();
            JsonArray jsonResult = new JsonArray();
            shareList.forEach(share -> {
                JsonObject configuration = new JsonObject();
                configuration.addProperty("id", share.getID());
                configuration.addProperty("active", share.isActive());
                configuration.addProperty("validPeriodFrom", share.getValidPeriodFrom() != null ? dateFormat.format(share.getValidPeriodFrom()) : null);
                configuration.addProperty("validPeriodTo", share.getValidPeriodTo() != null ? dateFormat.format(share.getValidPeriodTo()) : null);
                configuration.addProperty("hasPassword", share.getPasswordHash() != null && !share.getPasswordHash().equals(""));
                configuration.addProperty("ipsLock", share.getIPsLock());
                configuration.addProperty("onlyLoggedInUser", share.getOnlyLoggedInUser());
                JsonArray commentVisibility = new JsonArray();
                if (share.getCommentVisibilityString() != null && share.getCommentVisibilityString().length() > 0) {
                    for (String field : share.getCommentVisibilityString().split(";")) {
                        commentVisibility.add(new JsonPrimitive(field));
                    }
                }
                JsonArray attachmentVisibility = new JsonArray();
                if (share.getAttachmentVisibilityString() != null && share.getAttachmentVisibilityString().length() > 0) {
                    for (String field : share.getAttachmentVisibilityString().split(";")) {
                        attachmentVisibility.add(new JsonPrimitive(field));
                    }
                }
                JsonArray displayingFields = new JsonArray();
                for (String field : displayFieldManager.getListOfDisplayFieldIds((IssueShare)share)) {
                    displayingFields.add(new JsonPrimitive(field));
                }
                configuration.add("commentVisibility", commentVisibility);
                configuration.add("attachmentVisibility", attachmentVisibility);
                configuration.add("displayingFields", displayingFields);
                JsonObject entry = new JsonObject();
                entry.addProperty("id", share.getID());
                entry.addProperty("isActive", share.isActive());
                entry.addProperty("callCount", this.shareHistoryManager.getCountCallsByShareId(share.getID(), ShareHistoryItem.SharedItemType.ISSUE));
                entry.addProperty("token", share.getToken().getToken());
                entry.addProperty("shareLinkUrl", this.urlBuilder.buildUrl((IssueShare)share));
                entry.addProperty("createdDate", this.shareHistoryManager.getCreatedDateByShareId(share.getID(), ShareHistoryItem.SharedItemType.ISSUE).toString());
                ApplicationUser user = this.shareHistoryManager.getShareCreatorByShareId(share.getID(), ShareHistoryItem.SharedItemType.ISSUE);
                JsonObject userJson = new JsonObject();
                if (user != null) {
                    JsonObject avatarUrls = new JsonObject();
                    avatarUrls.addProperty("16x16", ComponentAccessor.getAvatarService().getAvatarURL(jiraAuthenticationContext.getLoggedInUser(), user, Avatar.Size.SMALL).toString());
                    userJson.add("avatarUrls", avatarUrls);
                    userJson.addProperty("displayName", user.getDisplayName());
                    userJson.addProperty("key", user.getKey());
                    userJson.addProperty("name", user.getName());
                } else {
                    userJson.addProperty("displayName", this.shareHistoryManager.getShareCreatorDisplayNameByShareId(share.getID(), ShareHistoryItem.SharedItemType.ISSUE));
                }
                entry.add("creator", userJson);
                entry.add("configuration", configuration);
                jsonResult.add(entry);
            });
            return Response.ok((Object)gson.toJson(jsonResult)).build();
        }
        catch (Throwable exception) {
            return Response.serverError().entity((Object)exception.getLocalizedMessage()).build();
        }
    }

    @POST
    @Produces(value={"application/json"})
    public Response post(CreateShareLinkRequest config, @Context HttpServletRequest request) {
        try {
            PluginLicenseValidator pluginLicenseValidator = new PluginLicenseValidator(this.pluginLicenseManager);
            if (!pluginLicenseValidator.hasValidLicense()) {
                throw new ExceptionWithoutTechnicalInformation(pluginLicenseValidator.getLocalizedErrorMessage(request.getLocale()));
            }
            JiraAuthenticationContext jiraAuthenticationContext = ComponentAccessor.getJiraAuthenticationContext();
            if (!jiraAuthenticationContext.isLoggedInUser()) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            MutableIssue issue = ComponentAccessor.getIssueManager().getIssueObject(Long.valueOf(config.getIssueId()));
            if (issue == null) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("aptis-sjy-issue-not-found", (Serializable[])new String[]{String.valueOf(config.getIssueId())}));
            }
            ApplicationUser user = jiraAuthenticationContext.getUser();
            ProjectSetting projectSettings = this.projectSettingsManager.findSetting(issue.getProjectId());
            ProjectPermissionManager projectPermissionManager = new ProjectPermissionManager();
            if (!projectPermissionManager.isUserInProjectRole(user, issue.getProjectObject(), ProjectSettingsManager.getShareAllowedProjectRoleIdsFromJson(projectSettings))) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("aptis-sjy-error-no-valid-link"));
            }
            TokenManager tokenManager = new TokenManager(this.activeObjects);
            DisplayFieldManager displayFieldManager = new DisplayFieldManager(this.activeObjects);
            IssueShareManager issueShareManager = new IssueShareManager(this.activeObjects, tokenManager, displayFieldManager);
            IssueShare issueShare = issueShareManager.createIssueShare(user, (Issue)issue, config);
            I18nHelper i18nHelper = ComponentAccessor.getI18nHelperFactory().getInstance(user);
            this.shareHistoryManager.addIssueCreated(issue.getId(), issueShare.getID(), this.shareHistoryLogItemFormatter.getShareSummaryForIssue(i18nHelper, this.i18nResolver, this.dateTimeFormatterFactory, config), user);
            String shareLinkUrl = this.urlBuilder.buildUrl(issueShare);
            CreateShareLinkResponse response = new CreateShareLinkResponse();
            GlobalSetting globalSettings = this.globalSettingManager.findSetting();
            EventManager eventManager = new EventManager();
            eventManager.fireIssueEvent("Issue Public Shared", (Issue)issue, user);
            response.setId(issueShare.getID());
            response.setIssueShareUrl(shareLinkUrl);
            return Response.ok((Object)response).build();
        }
        catch (Throwable exception) {
            return Response.serverError().entity((Object)exception.getLocalizedMessage()).build();
        }
    }

    @PUT
    @Produces(value={"application/json"})
    public Response put(EditShareLinkRequest config, @Context HttpServletRequest request) {
        try {
            JiraAuthenticationContext jiraAuthenticationContext = ComponentAccessor.getJiraAuthenticationContext();
            if (!jiraAuthenticationContext.isLoggedInUser()) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            TokenManager tokenManager = new TokenManager(this.activeObjects);
            DisplayFieldManager displayFieldManager = new DisplayFieldManager(this.activeObjects);
            IssueShareManager issueShareManager = new IssueShareManager(this.activeObjects, tokenManager, displayFieldManager);
            IssueShare issueShare = issueShareManager.findIssueShareById(config.getId());
            if (issueShare == null) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("aptis-sjy-issue-not-found", (Serializable[])new String[]{String.valueOf(config.getId())}));
            }
            if (config.getDisplayingFields() != null) {
                displayFieldManager.updateDisplayFields(issueShare, config.getDisplayingFields());
            }
            issueShare.setValidPeriodFrom(config.getValidPeriodFrom());
            issueShare.setValidPeriodTo(config.getValidPeriodTo());
            issueShare.setIPsLock(config.getIPsLock());
            issueShare.setNote(config.getNote());
            issueShare.setOnlyLoggedInUser(config.getOnlyLoggedInUser());
            issueShare.setCommentVisibilityString(AOConverter.convertToString(config.getCommentVisibility()));
            issueShare.setAttachmentVisibilityString(AOConverter.convertToString(config.getAttachmentVisibility()));
            PasswordHashConverter passwordHashConverter = new PasswordHashConverter();
            Boolean hasPassword = config.getHasPassword();
            if (hasPassword != null && !hasPassword.booleanValue()) {
                issueShare.setPasswordHash(null);
            } else if (config.getPassword() != null) {
                issueShare.setPasswordHash(passwordHashConverter.hashPassword(config.getPassword().toCharArray()));
            }
            issueShare.save();
            I18nHelper i18nHelper = ComponentAccessor.getI18nHelperFactory().getInstance(jiraAuthenticationContext.getLocale());
            this.shareHistoryManager.addIssueChanged(issueShare.getIssueId(), issueShare.getID(), this.shareHistoryLogItemFormatter.getShareSummaryForIssue(i18nHelper, this.i18nResolver, this.dateTimeFormatterFactory, config), jiraAuthenticationContext.getUser());
            MutableIssue issue = ComponentAccessor.getIssueManager().getIssueObject(Long.valueOf(issueShare.getIssueId()));
            if (issue == null) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("aptis-sjy-issue-not-found", (Serializable[])new String[]{String.valueOf(issueShare.getIssueId())}));
            }
            CreateShareLinkResponse response = new CreateShareLinkResponse();
            response.setIssueShareUrl(this.urlBuilder.buildUrl(issueShare));
            return Response.ok((Object)response).build();
        }
        catch (Throwable exception) {
            return Response.serverError().entity((Object)exception.getLocalizedMessage()).build();
        }
    }

    @DELETE
    @Produces(value={"application/json"})
    public Response delete(DeleteShareLinkRequest config, @Context HttpServletRequest request) {
        try {
            JiraAuthenticationContext jiraAuthenticationContext = ComponentAccessor.getJiraAuthenticationContext();
            if (!jiraAuthenticationContext.isLoggedInUser()) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            TokenManager tokenManager = new TokenManager(this.activeObjects);
            DisplayFieldManager displayFieldManager = new DisplayFieldManager(this.activeObjects);
            IssueShareManager issueShareManager = new IssueShareManager(this.activeObjects, tokenManager, displayFieldManager);
            IssueShare issueShare = issueShareManager.findIssueShareById(config.getId());
            if (issueShare == null) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("aptis-sjy-issue-not-found", (Serializable[])new String[]{String.valueOf(config.getId())}));
            }
            issueShareManager.deleteIssueShare(issueShare);
            this.shareHistoryManager.addIssueDeleted(issueShare.getIssueId(), issueShare.getID(), jiraAuthenticationContext.getUser());
            return Response.ok().build();
        }
        catch (Throwable exception) {
            return Response.serverError().entity((Object)exception.getLocalizedMessage()).build();
        }
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="activeStatus")
    public Response activate(EditShareLinkRequest config, @Context HttpServletRequest request) {
        try {
            JiraAuthenticationContext jiraAuthenticationContext = ComponentAccessor.getJiraAuthenticationContext();
            if (!jiraAuthenticationContext.isLoggedInUser()) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            TokenManager tokenManager = new TokenManager(this.activeObjects);
            DisplayFieldManager displayFieldManager = new DisplayFieldManager(this.activeObjects);
            IssueShareManager issueShareManager = new IssueShareManager(this.activeObjects, tokenManager, displayFieldManager);
            IssueShare issueShare = issueShareManager.findIssueShareById(config.getId());
            if (issueShare == null) {
                throw new ExceptionWithoutTechnicalInformation(this.i18nResolver.getText("aptis-sjy-issue-not-found", (Serializable[])new String[]{String.valueOf(config.getId())}));
            }
            issueShare.setActive(config.getActive());
            issueShare.save();
            I18nHelper i18nHelper = ComponentAccessor.getI18nHelperFactory().getInstance(jiraAuthenticationContext.getLocale());
            this.shareHistoryManager.addIssueChanged(issueShare.getIssueId(), issueShare.getID(), this.shareHistoryLogItemFormatter.getShareSummaryForActiveStatus(i18nHelper, issueShare), jiraAuthenticationContext.getUser());
            return Response.ok().build();
        }
        catch (Throwable exception) {
            return Response.serverError().entity((Object)exception.getLocalizedMessage()).build();
        }
    }
}

